/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.SplitTicketsHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchCCListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchCashListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchPKListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchRegistryListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchSubsidizedReportRegistryRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchSummaryListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchThumbsListWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TchReportRenderHandler
extends BasePoiSalesReportRenderHandler<TchTicket> {
    public static String getReportPeriod(Map<String, Object> data) {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        StringBuilder sb = new StringBuilder();
        sb.append(params.getPeriodBegin() != null ? sdf.format(params.getPeriodBegin()) : "null");
        sb.append("-");
        sdf = new SimpleDateFormat("dd.MM.yyyy");
        sb.append(params.getPeriodEnd() != null ? sdf.format(params.getPeriodEnd()) : "null");
        return sb.toString();
    }

    public static String getReportTitle(Map<String, Object> data, String messageKey) {
        return L10nResourcesManager.createL10nMessage((String)messageKey, (Object[])new Object[]{TchReportRenderHandler.getReportPeriod(data)}).toString();
    }

    @Override
    protected List<PoiWorksheetData<TchTicket>> createDataList() {
        ArrayList<PoiWorksheetData<TchTicket>> result = new ArrayList<PoiWorksheetData<TchTicket>>();
        result.add(new BaseWorksheetData<TchTicket>(){

            @Override
            public String getBatchId() {
                return "CASH";
            }

            @Override
            public PoiWorksheetDefinition<TchTicket> getDefinition() {
                return Definitions.CASH;
            }

            @Override
            public int getProirity() {
                return 2;
            }
        });
        result.add(new BaseWorksheetData<TchTicket>(){

            @Override
            public String getBatchId() {
                return "CC";
            }

            @Override
            public PoiWorksheetDefinition<TchTicket> getDefinition() {
                return Definitions.CREDITCARD;
            }

            @Override
            public int getProirity() {
                return 1;
            }
        });
        result.add(new BaseWorksheetData<TchTicket>(){

            @Override
            public String getBatchId() {
                return "PK";
            }

            @Override
            public PoiWorksheetDefinition<TchTicket> getDefinition() {
                return Definitions.CREDITCARD_TCH;
            }

            @Override
            public int getProirity() {
                return 0;
            }
        });
        result.add(new BaseWorksheetData<TchTicket>(){

            @Override
            public String getBatchId() {
                return "PACK";
            }

            @Override
            public PoiWorksheetDefinition<TchTicket> getDefinition() {
                return Definitions.PACK;
            }

            @Override
            public int getProirity() {
                return 3;
            }
        });
        result.add(new BaseWorksheetData<TchTicket>(){

            @Override
            public String getBatchId() {
                return "SUMMARY";
            }

            @Override
            public PoiWorksheetDefinition<TchTicket> getDefinition() {
                return Definitions.SUMMARY;
            }

            @Override
            public int getProirity() {
                return 4;
            }
        });
        result.add(new BaseWorksheetData<TchTicket>(){

            @Override
            public String getBatchId() {
                return "THUMBS";
            }

            @Override
            public PoiWorksheetDefinition<TchTicket> getDefinition() {
                return Definitions.THUMBS;
            }

            @Override
            public int getProirity() {
                return 5;
            }
        });
        return result;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return TchReportRenderHandler.getReportTitle(data, Messages.TchReportRenderHandler_reportTitle);
    }

    @Override
    protected String getTemplateFileName() {
        return "TCH.xls";
    }

    @Override
    public String getId() {
        return "tch-sales-report";
    }

    @Override
    public EntityContainer<? extends BaseReportDocument> renderReport(Map<String, Object> data) throws Exception {
        EntityContainer<BaseReportDocument> result = super.renderReport(data);
        this.addSubsidizedRegistries(result, data);
        this.addAdditionalRegistries(result, data);
        return result;
    }

    protected void addAdditionalRegistries(EntityContainer<ReportDocument> result, Map<String, Object> data) throws Exception {
        AdditionalRegistryRenderHandler additionalRegistryRenderHandler = new AdditionalRegistryRenderHandler();
        EntityContainer<BaseReportDocument> ctr = additionalRegistryRenderHandler.renderReport(data);
        List batches = (List)data.get("key-summary-data");
        if (batches == null || batches.size() == 0) {
            return;
        }
        ReportDocument doc = (ReportDocument)ctr.getEntity();
        ReportFile reportFile = (ReportFile)doc.getFiles().get(0);
        reportFile.setTitle(TchReportRenderHandler.getReportTitle(data, Messages.TchReportRenderHandler_additional_registries_reportTitle));
        reportFile.setName(String.format("TCH-additional-registries-%s.xls", TchReportRenderHandler.getReportPeriod(data)));
        ((ReportDocument)result.getEntity()).getFiles().add(reportFile);
    }

    protected void addSubsidizedRegistries(EntityContainer<ReportDocument> result, Map<String, Object> data) throws Exception {
        List batches = (List)data.get("key-subsidized-registry-batches");
        if (batches != null) {
            List<ReportFile> files = new TchSubsidizedReportRegistryRenderHandler().getRegistries(batches, (ReportParameters)data.get("key-report-params"), (String)data.get("key-tch-agency-code"));
            ((ReportDocument)result.getEntity()).getFiles().addAll(files);
        }
    }

    public static class AdditionalRegistryRenderHandler
    extends BasePoiSalesReportRenderHandler<TchTicket> {
        @Override
        protected String getTemplateFileName() {
            return "TCH-additional-registries.xls";
        }

        @Override
        public String getId() {
            return "tch-sales-reportadditional-registries";
        }

        @Override
        protected String getReportTitle(Map<String, Object> data) {
            return TchReportRenderHandler.getReportTitle(data, Messages.TchReportRenderHandler_additional_registries_reportTitle);
        }

        @Override
        protected List<PoiWorksheetData<TchTicket>> createDataList() {
            ArrayList<PoiWorksheetData<TchTicket>> result = new ArrayList<PoiWorksheetData<TchTicket>>();
            result.add(new BaseWorksheetData<TchTicket>(){

                @Override
                public String getBatchId() {
                    return "PACK";
                }

                @Override
                public PoiWorksheetDefinition<TchTicket> getDefinition() {
                    return Definitions.PACK;
                }

                @Override
                public int getProirity() {
                    return 1;
                }
            });
            result.add(new BaseWorksheetData<TchTicket>(){

                @Override
                public String getBatchId() {
                    return "SUMMARY";
                }

                @Override
                public PoiWorksheetDefinition<TchTicket> getDefinition() {
                    return Definitions.SUMMARY;
                }

                @Override
                public int getProirity() {
                    return 2;
                }
            });
            result.add(new BaseWorksheetData<TchTicket>(){

                @Override
                public String getBatchId() {
                    return "THUMBS";
                }

                @Override
                public PoiWorksheetDefinition<TchTicket> getDefinition() {
                    return Definitions.THUMBS;
                }

                @Override
                public int getProirity() {
                    return 3;
                }
            });
            return result;
        }

        public static enum Definitions implements PoiWorksheetDefinition<TchTicket>
        {
            PACK{

                @Override
                public PoiWorksheetHandler<TchTicket> getHandler() {
                    return new TchRegistryListWorksheetHandler(SplitTicketsHelper.TchReportRegistriesSetType.ADDITTIONAL);
                }
            }
            ,
            SUMMARY{

                @Override
                public PoiWorksheetHandler<TchTicket> getHandler() {
                    return new TchSummaryListWorksheetHandler();
                }
            }
            ,
            THUMBS{

                @Override
                public PoiWorksheetHandler<TchTicket> getHandler() {
                    return new TchThumbsListWorksheetHandler();
                }
            };


            @Override
            public String getWorksheetTemplateName() {
                return this.name();
            }

            @Override
            public PoiWorksheetHandler<TchTicket> getHandler() {
                return null;
            }
        }
    }

    public static enum Definitions implements PoiWorksheetDefinition<TchTicket>
    {
        CASH{

            @Override
            public PoiWorksheetHandler<TchTicket> getHandler() {
                return new TchCashListWorksheetHandler();
            }
        }
        ,
        CREDITCARD{

            @Override
            public PoiWorksheetHandler<TchTicket> getHandler() {
                return new TchCCListWorksheetHandler();
            }
        }
        ,
        CREDITCARD_TCH{

            @Override
            public PoiWorksheetHandler<TchTicket> getHandler() {
                return new TchPKListWorksheetHandler();
            }
        }
        ,
        PACK{

            @Override
            public PoiWorksheetHandler<TchTicket> getHandler() {
                return new TchRegistryListWorksheetHandler(SplitTicketsHelper.TchReportRegistriesSetType.REQUIRED);
            }
        }
        ,
        SUMMARY{

            @Override
            public PoiWorksheetHandler<TchTicket> getHandler() {
                return new TchSummaryListWorksheetHandler();
            }
        }
        ,
        THUMBS{

            @Override
            public PoiWorksheetHandler<TchTicket> getHandler() {
                return new TchThumbsListWorksheetHandler();
            }
        };


        @Override
        public String getWorksheetTemplateName() {
            return this.name();
        }

        @Override
        public PoiWorksheetHandler<TchTicket> getHandler() {
            return null;
        }
    }
}

