/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.BasePoiSalesReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchSubsidizedTariffRegistryTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchSubsidizedTariffRegistryTicketsBatch;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class TchSubsidizedReportRegistryRenderHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReportFile> getRegistries(List<TchSubsidizedTariffRegistryTicketsBatch> batches, ReportParameters params, String agencyCode) throws Exception {
        ArrayList<ReportFile> result = new ArrayList<ReportFile>();
        String endDateStr = new SimpleDateFormat("ddMMyyyy").format(MiscUtil.setDayEndTime((Date)params.getPeriodEnd()));
        for (TchSubsidizedTariffRegistryTicketsBatch batch : batches) {
            try (InputStream is = IoUtil.getResourceInputStream((File)this.getTemplateFile());){
                POIFSFileSystem fs = new POIFSFileSystem(is);
                HSSFWorkbook wb = new HSSFWorkbook(fs);
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    new TchSubsidizedRegistryListWorksheetHandler(batch, wb).fill();
                    wb.write((OutputStream)os);
                    ReportFile file = new ReportFile();
                    file.setName(String.format("%s%s%s%s.xls", batch.getFlightType() == TchSubsidizedTariffRegistryTicketsBatch.FlightType.KALININGRAD ? "\u041a\u0414" : "\u0414\u0412", batch.isRefund() ? "\u0412" : "\u041f", agencyCode, endDateStr));
                    String arg1 = batch.isRefund() ? L10nResourcesManager.createL10nMessage((String)Messages.TchSubsidizedReport_refund, (Object[])new Object[0]).toString() : L10nResourcesManager.createL10nMessage((String)Messages.TchSubsidizedReport_sell, (Object[])new Object[0]).toString();
                    file.setTitle(L10nResourcesManager.createL10nMessage((String)Messages.TchSubsidizedReport_sell, (Object[])new Object[]{arg1, batch.getFlightType() == TchSubsidizedTariffRegistryTicketsBatch.FlightType.KALININGRAD ? "\u041a\u0414" : "\u0414\u0412"}).toString());
                    file.setContentType(ContentType.EXCEL);
                    file.setContent(os.toByteArray());
                    result.add(file);
                }
            }
        }
        return result;
    }

    protected File getTemplateFile() throws IOException {
        File result = IoUtil.url2file((URL)BasePoiSalesReportRenderHandler.class.getResource("/salesreports/TCHSubsidized.xls"));
        if (!result.exists()) {
            throw new IOException(L10nResourcesManager.createL10nMessage((String)Messages.TchSubsidizedReport_templateNotFound, (Object[])new Object[]{result.getCanonicalPath()}).toString());
        }
        return result;
    }

    static class TchSubsidizedRegistryListWorksheetHandler {
        private static final Locale ruLocale = LocaleUtil.createNormalizedLocale((Locale)new Locale("ru"));
        private final TchSubsidizedTariffRegistryTicketsBatch batch;
        private final HSSFWorkbook workbook;
        private static final int startIndex = 8;

        private DateFormat createDf() {
            return new SimpleDateFormat("yyyy.MM.dd", ruLocale);
        }

        TchSubsidizedRegistryListWorksheetHandler(TchSubsidizedTariffRegistryTicketsBatch batchData, HSSFWorkbook wb) {
            this.batch = batchData;
            this.workbook = wb;
        }

        void fill() throws Exception {
            int n;
            for (n = 0; n < this.batch.getSubBatches().size() - 1; ++n) {
                this.workbook.cloneSheet(0);
            }
            n = 0;
            for (Map.Entry<DictionaryReference<Airline>, List<TchSubsidizedTariffRegistryTicket>> entry : this.batch.getSubBatches().entrySet()) {
                DictionaryReference<Airline> carrier = entry.getKey();
                HSSFSheet sheet = this.workbook.getSheetAt(n);
                String carrierCode = this.getSheetName(carrier);
                this.workbook.setSheetName(n, carrierCode);
                ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)this.batch.getReportPeriod());
                ExcelUtils.replace((HSSFSheet)sheet, (String)"CARRIER", (String)carrierCode);
                ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)this.batch.getDirector());
                ExcelUtils.replace((HSSFSheet)sheet, (String)"WORK_PHONE", (String)this.batch.getPhone());
                ExcelUtils.replace((HSSFSheet)sheet, (String)"REGISTRY_TYPE", (String)(this.batch.isRefund() ? L10nResourcesManager.createL10nMessage((String)Messages.TchSubsidizedReport_refunds, (Object[])new Object[0]).toString() : L10nResourcesManager.createL10nMessage((String)Messages.TchSubsidizedReport_sells, (Object[])new Object[0]).toString()));
                ExcelUtils.replace((HSSFSheet)sheet, (String)"REGISTRY_DIRECTION", (String)(this.batch.getFlightType() == TchSubsidizedTariffRegistryTicketsBatch.FlightType.FAR_EAST ? L10nResourcesManager.createL10nMessage((String)Messages.TchSubsidizedReport_fromFarEastToEuro, (Object[])new Object[0]).toString() : L10nResourcesManager.createL10nMessage((String)Messages.TchSubsidizedReport_fromKaliningradToEuro, (Object[])new Object[0]).toString()));
                List<TchSubsidizedTariffRegistryTicket> tickets = entry.getValue();
                for (int m = 0; m < tickets.size() - 1; ++m) {
                    ExcelUtils.copyRows((HSSFSheet)sheet, (int)7, (int)7);
                }
                int currentIndex = 8;
                BigDecimal totalTariff = BigDecimal.ZERO;
                for (TchSubsidizedTariffRegistryTicket ticket : tickets) {
                    this.fillRow(ticket, sheet, currentIndex);
                    if (ticket.getSegmentEquivalentFare() != null) {
                        totalTariff = totalTariff.add(ticket.getSegmentEquivalentFare());
                    }
                    ++currentIndex;
                }
                ++n;
            }
        }

        private String getSheetName(DictionaryReference<Airline> carrierRef) {
            Airline carrier = (Airline)DictionaryCache.get().resolveReference(carrierRef);
            if (carrier == null || carrier.getCodeVariants().isEmpty()) {
                return carrierRef.getCode();
            }
            return carrier.getCodeVariants().get(CodeSystem.CRT.name()) == null ? carrier.getCode() : (String)carrier.getCodeVariants().get(CodeSystem.CRT.name());
        }

        private void fillRow(TchSubsidizedTariffRegistryTicket ticket, HSSFSheet sheet, int currentIndex) throws Exception {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)1, (int)(currentIndex - 8 + 1));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)2, (String)ticket.getIssueCity().toString(ruLocale));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)4, (String)ticket.getSystemNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)5, (String)this.toString(ticket.getIssueDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)6, (String)this.toString(ticket.getFlightDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)7, (String)ticket.getFlightNo());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)8, (String)this.toString(ticket.getDepartureLocation()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)9, (String)this.toString(ticket.getArrivalLocation()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)10, (String)ticket.getPassengerFullName());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)11, (String)ticket.getPassportNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)12, (String)this.toString(ticket.getPassengerCategory()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)13, (String)ticket.getFareBasis());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)14, (BigDecimal)ticket.getSegmentEquivalentFare());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)15, (String)this.toString(ticket.getBirthDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)16, (String)this.toString(ticket.getGender()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)currentIndex, (int)1, (int)1, (int)17, (String)ticket.getAgencyCode());
        }

        private String toString(TchSubsidizedTariffRegistryTicket.TchPassengerCategory passengerCategory) {
            if (passengerCategory == null) {
                return null;
            }
            switch (passengerCategory) {
                case ADULT: {
                    return "\u0412\u0417\u0420";
                }
                case CHILD_WITH_SEAT: {
                    return "\u0420\u041c";
                }
            }
            return "\u0420\u0411";
        }

        private String toString(Gender gender) {
            if (gender == null) {
                return null;
            }
            switch (gender) {
                case FEMALE: {
                    return L10nResourcesManager.createL10nMessage((String)Messages.TchSubsidizedReport_mrs, (Object[])new Object[0]).toString();
                }
            }
            return L10nResourcesManager.createL10nMessage((String)Messages.TchSubsidizedReport_mr, (Object[])new Object[0]).toString();
        }

        <D extends BaseDictionary> String toString(DictionaryReference<D> item) {
            if (item == null) {
                return null;
            }
            return item.toString(ruLocale);
        }

        String toString(Date item) {
            if (item == null) {
                return null;
            }
            return this.createDf().format(item);
        }
    }
}

