/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.BaseTchWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.BatchTotalInfo;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.LotInfo;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;

class TchThumbsListWorksheetHandler
extends BaseTchWorksheetHandler<TchTicket> {
    private final int thumbHeight = 19;
    private final int bandHeight = 41;

    TchThumbsListWorksheetHandler() {
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<TchTicket> data, Map<String, Object> globalData) throws Exception {
        int n;
        List totalInfos = (List)globalData.get("key-summary-data");
        if (totalInfos == null || totalInfos.isEmpty()) {
            wb.removeSheetAt(wb.getSheetIndex((Sheet)sheet));
            return;
        }
        wb.setSheetName(wb.getSheetIndex((Sheet)sheet), L10nResourcesManager.createL10nMessage((String)Messages.TchThumbsListWorksheetHandler_sheetName, (Object[])new Object[0]).toString());
        int size = totalInfos.size();
        for (n = 1; n < size; ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)0, (int)40);
        }
        for (n = 0; n < size; ++n) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(41 * n + 1), (int)1, (int)1, (int)1, (String)((BatchTotalInfo)totalInfos.get(n)).getGroupName());
        }
        int addBatchCount = 0;
        for (int n2 = 0; n2 < size; ++n2) {
            int m;
            BatchTotalInfo info = (BatchTotalInfo)totalInfos.get(n2);
            boolean isPta = "PTA".equals(info.getGroupCode()) || "ETPTA".equals(info.getGroupCode()) || "TPTA".equals(info.getGroupCode());
            for (m = 1; m < info.getLotsInfo().size(); ++m) {
                int shift = 41 * n2 + 2 + (addBatchCount + 1) * 20;
                ExcelUtils.copyRows((HSSFSheet)sheet, (int)shift, (int)(shift + 19));
            }
            int rowIndex = 41 * n2 + 2 + addBatchCount * 20;
            this.fillCommonPart(sheet, rowIndex, info, isPta);
            this.fillEnvelopePart(sheet, rowIndex, info);
            for (m = 0; m < info.getLotsInfo().size(); ++m) {
                int rowIndex2 = 41 * n2 + 2 + (addBatchCount + m + 1) * 20;
                this.fillCommonPart(sheet, rowIndex2, info, isPta);
                this.fillLotPart(sheet, rowIndex2, info.getLotsInfo().get(m), m + 1, isPta);
            }
            addBatchCount += info.getLotsInfo().size() - 1;
        }
    }

    private void fillCommonPart(HSSFSheet sheet, int rowIndex, BatchTotalInfo info, boolean isPta) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)3, (int)3, (String)info.getAgencyCode());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)5, (int)3, (Date)info.getEndDate());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)8, (int)6, (Date)info.getEndDate());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)3, (int)12, (String)info.getCurrencyCode());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)10, (int)11, (String)(isPta ? "PT  " : "\u0412\u0417  "));
    }

    private void fillEnvelopePart(HSSFSheet sheet, int rowIndex, BatchTotalInfo info) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)12, (int)3, (int)info.getLotsInfo().size());
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)8, (int)13, (String)this.buildFormula("M", rowIndex + 8 + 19 + 1, 20, info.getLotsInfo().size()));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)9, (int)13, (String)this.buildFormula("M", rowIndex + 9 + 19 + 1, 20, info.getLotsInfo().size()));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)10, (int)13, (String)this.buildFormula("M", rowIndex + 10 + 19 + 1, 20, info.getLotsInfo().size()));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)11, (int)13, (String)this.buildFormula("M", rowIndex + 11 + 19 + 1, 20, info.getLotsInfo().size()));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)16, (int)13, (String)this.buildFormula("M", rowIndex + 16 + 19 + 1, 20, info.getLotsInfo().size()));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)16, (int)16, (String)this.buildFormula("P", rowIndex + 16 + 19 + 1, 20, info.getLotsInfo().size()));
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)16, (int)19, (int)info.getMtdCount());
    }

    private String buildFormula(String column, int start, int period, int count) {
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < count; ++n) {
            sb.append(n == 0 ? "=" : "+");
            sb.append(column).append(start + n * period);
        }
        return sb.toString();
    }

    private void fillLotPart(HSSFSheet sheet, int rowIndex, LotInfo lotInfo, int lotIndex, boolean isPta) throws Exception {
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)10, (int)3, (int)lotIndex);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)8, (int)13, (String)lotInfo.getTotalCA());
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)9, (int)13, (String)lotInfo.getTotalKR());
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)10, (int)13, (String)(isPta ? lotInfo.getTotalPTA() : lotInfo.getTotalVZ()));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)11, (int)13, (String)lotInfo.getTotalCC());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)16, (int)13, (int)lotInfo.getTicketsCount());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)16, (int)16, (int)lotInfo.getCouponsCount());
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(rowIndex + 1), (int)1, (int)16, (int)19, (int)lotInfo.getMtdCount());
    }
}

