/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.tch;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TchCreditCardAccompanyingDocumentType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AgencyMemoProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class TchTicket
extends BaseSalesReportTicket {
    private static final long serialVersionUID = 5216563008811651610L;
    private static final String[] taxesForBlankCodes = AirProductTaxHelper.getTaxesForBlankCodes((DictionaryReference)new AirlineReference("\u04281"));
    static final Locale ruLocale = new Locale("ru");
    private static final Set<AgencyMemoProductEntryType> zzTaxEntryTypes = Collections.singleton(AgencyMemoProductEntryType.TAX_CARRIER);
    private boolean additionalSegment;
    private CardVendor cardVendor;
    private String carrierCode;
    private String[] carrierCodes;
    private String carrierName;
    private String[] carrierNames;
    private String carrierNumber;
    private String cashier;
    private boolean conjunctedTicket;
    protected boolean directContract;
    private boolean fakeProduct = false;
    private BigDecimal fareCash = BigDecimal.ZERO;
    private BigDecimal fareCC = BigDecimal.ZERO;
    private BigDecimal farePK = BigDecimal.ZERO;
    private BigDecimal penaltyCash = BigDecimal.ZERO;
    private BigDecimal penaltyCC = BigDecimal.ZERO;
    private BigDecimal penaltyPK = BigDecimal.ZERO;
    private BigDecimal krValue = BigDecimal.ZERO;
    private BigDecimal ptaValue = BigDecimal.ZERO;
    private BigDecimal pkFeeValue = BigDecimal.ZERO;
    private final HashSet<ProductFop> relatedProductFops = new HashSet();
    private String relatedTicketNo;
    private String scn;
    private BigDecimal tchTaxCash = BigDecimal.ZERO;
    private BigDecimal tchTaxCC = BigDecimal.ZERO;
    private BigDecimal tchTaxPK = BigDecimal.ZERO;
    private String validator;
    private boolean vatIncluded;
    private BigDecimal vzValue = BigDecimal.ZERO;
    private BigDecimal xtTaxCash = BigDecimal.ZERO;
    private BigDecimal xtTaxCC = BigDecimal.ZERO;
    private BigDecimal xtTaxPK = BigDecimal.ZERO;
    private boolean exchangePenaltyMCO = false;
    private boolean subsidizedTariff = false;
    private boolean agencyMemoProduct = false;
    private String subsidizedPackId;
    private boolean returnFareDifference;
    private BigDecimal pkClientFeeEquivalentValue = BigDecimal.ZERO;
    private TchCreditCardAccompanyingDocumentType creditCardAccompanyingDocumentType = null;

    public TchTicket() {
    }

    public TchTicket(AgencyMemoProduct agencyMemo, List<Message> messages) throws Exception {
        super(agencyMemo, messages);
        this.agencyMemoProduct = true;
        ArrayList codes = new ArrayList();
        Arrays.stream(GdsName.values()).forEach(gds -> codes.add(CommonReservationGdsNameInfoHelper.getBookingAgentDutyCode((Reservation)agencyMemo.getReservation(), (GdsName)gds)));
        this.cashier = codes.stream().filter(TextUtil::nonBlank).findAny().orElse(null);
        this.additionalSegment = false;
        this.directContract = false;
        this.relatedTicketNo = null;
        this.validator = null;
        this.scn = null;
        this.carrierNumber = agencyMemo.getAirlineCode();
        if (TextUtil.isBlank((String)this.carrierNumber)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"ADM/ACM {0}: \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u043a\u043e\u0434 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438", (Object[])new Object[]{agencyMemo.getSystemNumber()}));
            return;
        }
        Airline airline = DictHelper.findAirlineByNumber((String)this.carrierNumber);
        if (airline == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"ADM/ACM {0}: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0435 \u043f\u043e \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u043c\u0443 \u043a\u043e\u0434\u0443 {1}", (Object[])new Object[]{agencyMemo.getSystemNumber(), this.carrierNumber}));
            return;
        }
        this.carrierCode = this.getAirlineCode(airline);
        this.carrierName = airline.toString(ruLocale);
        this.carrierCodes = new String[]{this.carrierCode};
        this.carrierNames = new String[]{this.carrierName};
        this.fops = new HashSet();
        ProductFop fop = new ProductFop();
        fop.setType(PaymentType.CASH);
        Money amount = new Money();
        amount.setCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
        VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)agencyMemo, (ContractType)ContractType.VENDOR);
        amount.setValue(price == null ? BigDecimal.ZERO : price.getTotal());
        fop.setAmount(amount);
        this.fops.add(fop);
        this.fareCash = this.getAgencyMemoPriceComponent(agencyMemo, AgencyMemoProductHelper.tariffEntryTypes);
        this.tchTaxCash = this.getAgencyMemoPriceComponent(agencyMemo, zzTaxEntryTypes);
        this.xtTaxCash = this.getAgencyMemoPriceComponent(agencyMemo, AgencyMemoProductHelper.taxEntryTypes).subtract(this.tchTaxCash);
        this.penaltyCash = this.getAgencyMemoPriceComponent(agencyMemo, AgencyMemoProductHelper.penaltyEntryTypes);
        HashSet<AgencyMemoProductEntryType> commissionsAndBonuses = new HashSet<AgencyMemoProductEntryType>();
        commissionsAndBonuses.addAll(AgencyMemoProductHelper.commissionEntryTypes);
        if (agencyMemo.getType() == AgencyMemoProductType.ACM) {
            commissionsAndBonuses.addAll(AgencyMemoProductHelper.bonusEntryTypes);
        }
        this.vendorEquivalentCommission = this.getAgencyMemoPriceComponent(agencyMemo, commissionsAndBonuses).negate();
        this.fareCC = BigDecimal.ZERO;
        this.farePK = BigDecimal.ZERO;
        this.penaltyCC = BigDecimal.ZERO;
        this.penaltyPK = BigDecimal.ZERO;
        this.tchTaxCC = BigDecimal.ZERO;
        this.tchTaxPK = BigDecimal.ZERO;
        this.xtTaxCC = BigDecimal.ZERO;
        this.xtTaxPK = BigDecimal.ZERO;
        this.cashValue = fop.getAmount().getValue();
        this.krValue = BigDecimal.ZERO;
        this.vzValue = BigDecimal.ZERO;
        this.creditCardValue = BigDecimal.ZERO;
        this.ptaValue = BigDecimal.ZERO;
    }

    private BigDecimal getAgencyMemoPriceComponent(AgencyMemoProduct agencyMemo, Set<AgencyMemoProductEntryType> types) {
        BigDecimal result = AgencyMemoProductHelper.calculateEntriesEquivalentAmount((Collection)AgencyMemoProductHelper.filterEntries((Collection)agencyMemo.getEntries(), types, null, null));
        if (result == null) {
            result = BigDecimal.ZERO;
        }
        if (agencyMemo.getType() == AgencyMemoProductType.ACM) {
            result = result.negate();
        }
        return result;
    }

    public TchTicket(Product ticketObj, List<Message> messages) throws Exception {
        super(ticketObj, messages);
        PaymentType ptype;
        Product rp;
        ArrayList codes = new ArrayList();
        Arrays.stream(GdsName.values()).forEach(gds -> codes.add(CommonReservationGdsNameInfoHelper.getBookingAgentDutyCode((Reservation)ticketObj.getReservation(), (GdsName)gds)));
        this.cashier = codes.stream().filter(TextUtil::nonBlank).findAny().orElse(null);
        this.additionalSegment = false;
        this.returnFareDifference = ticketObj.isContainsReturnFareDifferenceData();
        this.directContract = false;
        this.relatedTicketNo = null;
        this.subsidizedTariff = ticketObj.isSubsidizedTariff();
        this.directContract = ticketObj.getTchDirectContract() != null;
        Product prevProd = ticketObj.getPreviousProduct();
        this.fakeProduct = ticketObj.getUid().startsWith("TCH_VIRTUAL:");
        if (this.productCategory == ProductCategory.AIR && this.status == ProductStatus.SELL && prevProd != null && prevProd.getStatus() == ProductStatus.EXCHANGE) {
            this.relatedTicketNo = prevProd.getSystemNumber();
        }
        this.vatIncluded = AirProductHelper.calculateTransportationType((Product)ticketObj) == TransportationType.DOMESTIC;
        this.subsidizedPackId = this.calculateSubsidizedPackId(ticketObj);
        if (!(this.productCategory != ProductCategory.MCO || this.mcoCategory != MCOCategory.PENALTY && this.mcoCategory != MCOCategory.REBOOKING && this.mcoCategory != MCOCategory.INFORMATION || ticketObj.getRelatedProducts().isEmpty())) {
            rp = AirProductHelper.findRelatedAirProduct((Product)ticketObj, null, (boolean)false);
            if (rp != null) {
                this.vatIncluded = true;
                this.relatedTicketNo = rp.getSystemNumber();
                List<ProductFop> rfops = TchTicket.collectFops(rp, false, messages);
                if (rfops == null) {
                    return;
                }
                this.relatedProductFops.addAll(rfops);
                if (rp.getStatus() == ProductStatus.EXCHANGE) {
                    this.exchangePenaltyMCO = true;
                }
                this.subsidizedPackId = this.calculateSubsidizedPackId(rp);
            } else {
                this.vatIncluded = true;
            }
        }
        if (this.productCategory == ProductCategory.EXCESS_BAGAGE) {
            rp = AirProductHelper.findRelatedAirProduct((Product)ticketObj, null, (boolean)true);
            this.vatIncluded = rp != null ? AirProductHelper.isHasVat((Product)rp) : true;
        }
        this.validator = ticketObj.getValidatorCode();
        this.scn = ticketObj.getScns().isEmpty() ? null : (String)ticketObj.getScns().get(0);
        this.carrierNumber = ticketObj.getUid().startsWith("TCH_VIRTUAL:") ? "99A" : ticketObj.getCarrierNumber();
        this.carrierCode = ticketObj.getUid().startsWith("TCH_VIRTUAL:") ? "\u04281" : this.getAirlineCode((DictionaryReference<Airline>)ticketObj.getCarrier());
        Airline airline = (Airline)DictionaryCache.get().resolveReference((DictionaryReference)(ticketObj.getUid().startsWith("TCH_VIRTUAL:") ? new AirlineReference("\u04281") : ticketObj.getCarrier()));
        this.carrierName = airline != null ? airline.toString(ruLocale) : null;
        for (ProductFop fop2 : AirProductHelper.getVendorFops((Product)ticketObj)) {
            if (fop2.getType() != PaymentType.CREDIT_CARD || fop2.getTchCCAccompanyingDocumentType() == null) continue;
            this.creditCardAccompanyingDocumentType = fop2.getTchCCAccompanyingDocumentType();
            break;
        }
        boolean isSpecialSchemeTicket = false;
        Product specialSchemeTicket = null;
        if (AirProductHelper.isSpecialSchemeTCHTicket((Product)ticketObj)) {
            for (BaseProduct bp : ticketObj.getReservation().getProducts()) {
                Product relProduct;
                if (ticketObj.equals((Object)bp) || !(bp instanceof Product) || (relProduct = (Product)bp).getStatus() != ticketObj.getStatus() || !AirProductHelper.isSpecialSchemeTCHTicket((Product)relProduct) || relProduct.getTraveller() == null || !relProduct.getTraveller().equals((Object)ticketObj.getTraveller()) || ticketObj.getProductCategory() != relProduct.getProductCategory()) continue;
                isSpecialSchemeTicket = true;
                specialSchemeTicket = relProduct;
                break;
            }
        }
        if (isSpecialSchemeTicket) {
            this.carrierNumber = ticketObj.getTourCode();
            this.carrierCode = "\u04281";
            this.carrierName = "\u0422\u041a\u041f";
        }
        LinkedHashSet<Airline> airlines = new LinkedHashSet<Airline>();
        Airline blankAirline = new Airline();
        blankAirline.setCode("null");
        if (ticketObj.getProductCategory() == ProductCategory.MCO && isSpecialSchemeTicket) {
            airlines.add(ticketObj.getCarrier() == null ? blankAirline : this.getAirline((DictionaryReference<Airline>)ticketObj.getCarrier()));
            airlines.add(specialSchemeTicket.getCarrier() == null ? blankAirline : this.getAirline((DictionaryReference<Airline>)specialSchemeTicket.getCarrier()));
        } else {
            ArrayList segmentTariffs = new ArrayList(ticketObj.getSegmentTariffs());
            if (isSpecialSchemeTicket) {
                segmentTariffs.addAll(specialSchemeTicket.getSegmentTariffs());
            }
            for (SegmentTariff tariff : segmentTariffs) {
                for (Segment seg : tariff.getSegments()) {
                    DictionaryReference al = seg.getAirline();
                    if (al == null) {
                        airlines.add(blankAirline);
                        continue;
                    }
                    airlines.add(this.getAirline((DictionaryReference<Airline>)al));
                }
            }
        }
        ArrayList airlineList = new ArrayList(airlines);
        Collections.sort(airlineList, new Comparator<Airline>(){

            @Override
            public int compare(Airline o1, Airline o2) {
                return TextUtil.compare((String)(o1 != null ? o1.toString(ruLocale) : null), (String)(o2 != null ? o2.toString(ruLocale) : null), (boolean)false, (boolean)true);
            }
        });
        int size = airlineList.size();
        this.carrierCodes = new String[size];
        this.carrierNames = new String[size];
        for (int n = 0; n < size; ++n) {
            Airline airlineCode = (Airline)airlineList.get(n);
            this.carrierCodes[n] = this.getAirlineCode(airlineCode);
            this.carrierNames[n] = airlineCode.toString(ruLocale);
        }
        if (this.carrierCodes.length == 0 && ("99A".equals(ticketObj.getCarrierNumber()) || "99\u0410".equals(ticketObj.getCarrierNumber()))) {
            SystemHelper.addMessage(messages, (String)Messages.TchTicket_noSegmentCarriers, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketObj.getSystemNumber()});
            return;
        }
        if (ticketObj.getProductCategory() == ProductCategory.MCO && ticketObj.getMcoCategory() == MCOCategory.INFORMATION) {
            this.fops = new HashSet();
            return;
        }
        if (ticketObj.getStatus() == ProductStatus.VOID || ticketObj.getStatus() == ProductStatus.VOID_BOOKING) {
            this.fops = new HashSet();
            return;
        }
        this.fops = TchTicket.collectFops(ticketObj, false, messages);
        if (this.fops == null) {
            this.fops = new HashSet();
            return;
        }
        for (ProductFop fop3 : this.fops) {
            if (fop3.getCard() == null || fop3.getCard().getVendor() == null) continue;
            this.cardVendor = fop3.getCard().getVendor();
            break;
        }
        double pkFeeRate = -1.0;
        BigDecimal pkBasis = BigDecimal.ZERO;
        ArrayList combinedFops = new ArrayList();
        combinedFops.addAll(AirProductHelper.getVendorFops((Product)ticketObj));
        AirProductHelper.getClientFops((Product)ticketObj).forEach(fop -> {
            if (!AirProductHelper.isServiceFop((ProductFop)fop)) {
                combinedFops.add(fop);
            }
        });
        for (ProductFop item : combinedFops) {
            if (item.getAmount() == null || item.getAmount().getValue() == null || item.getType() != PaymentType.CREDIT_CARD_TCH) continue;
            if (item.getCard() == null || item.getCard().getVendor() == null) {
                SystemHelper.addMessage(messages, (String)"\u0411\u0438\u043b\u0435\u0442 {0}: \u0434\u043b\u044f \u0424\u041e\u041f {1} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0422\u0438\u043f \u041a\u0430\u0440\u0442\u044b", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketObj.getSystemNumber(), item.getType()});
                return;
            }
            pkBasis = pkBasis.add(item.getAmount().getValue());
            if (!(pkFeeRate < 0.0)) continue;
            switch (item.getCard().getVendor()) {
                case VISA: {
                    pkFeeRate = 1.55;
                    break;
                }
                case MASTERCARD: {
                    pkFeeRate = 1.55;
                    break;
                }
                case DINERS_CLUB: {
                    pkFeeRate = 3.5;
                    break;
                }
                case AMEX: {
                    pkFeeRate = 3.5;
                    break;
                }
                case JCB: {
                    pkFeeRate = 2.5;
                    break;
                }
                case MIR: {
                    pkFeeRate = 1.55;
                    break;
                }
            }
        }
        if (pkFeeRate > 0.0) {
            this.pkFeeValue = BigDecimal.valueOf(pkFeeRate).multiply(pkBasis).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
            this.pkFeeValue = this.pkFeeValue.multiply(BigDecimal.valueOf(118L)).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        }
        if (ticketObj.getProductCategory() == ProductCategory.MCO && ticketObj.getMcoCategory() == MCOCategory.INFORMATION) {
            return;
        }
        if (BigDecimal.ZERO.compareTo(BookingHelper.calculateProductPrice((BaseProduct)ticketObj, (ContractType)ContractType.VENDOR).getTotal()) == 0) {
            return;
        }
        this.fareCash = BigDecimal.ZERO;
        this.fareCC = BigDecimal.ZERO;
        this.farePK = BigDecimal.ZERO;
        HashSet cashTaxes = new HashSet();
        HashSet ccTaxes = new HashSet();
        HashSet pkTaxes = new HashSet();
        this.penaltyCash = BigDecimal.ZERO;
        this.penaltyCC = BigDecimal.ZERO;
        this.penaltyPK = BigDecimal.ZERO;
        boolean hasCashFop = false;
        boolean hasCCFop = false;
        boolean hasPKFop = false;
        boolean hasCreditFop = false;
        boolean hasMtdFop = false;
        AirProductContractRelationData clientCR = AirProductHelper.getClientContractRelation((Product)ticketObj);
        for (ProductFop clientFop : clientCR.getFops()) {
            if (clientFop.getType() != PaymentType.CREDIT_CARD_TCH) continue;
            this.pkClientFeeEquivalentValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.pkClientFeeEquivalentValue, AirProductHelper.calculateCommissionsEquivalentValue((Collection)clientFop.getCommissions())});
        }
        for (ProductFop fop4 : this.fops) {
            if (fop4.getType() == null || fop4.getAmount() == null || fop4.getAmount().getValue() == null || fop4.getAmount().getValue().compareTo(BigDecimal.ZERO) == 0) continue;
            if (fop4.getType() == PaymentType.CREDIT_CARD) {
                hasCCFop = true;
                continue;
            }
            if (fop4.getType() == PaymentType.CREDIT) {
                hasCreditFop = true;
                continue;
            }
            if (fop4.getType() == PaymentType.CREDIT_CARD_TCH) {
                hasPKFop = true;
                continue;
            }
            if (fop4.getType() == PaymentType.MTD) {
                hasMtdFop = true;
                continue;
            }
            hasCashFop = true;
        }
        if (!(hasCCFop || hasCashFop || hasCreditFop || hasPKFop || hasMtdFop)) {
            SystemHelper.addMessage(messages, (String)Messages.TchTicket_noFops, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketObj.getSystemNumber(), PaymentType.CASH, PaymentType.CREDIT_CARD, PaymentType.CREDIT, PaymentType.CREDIT_CARD_TCH});
            return;
        }
        if (!(hasMtdFop || hasCreditFop || hasCCFop || hasPKFop || !hasCashFop)) {
            this.fareCash = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)ticketObj));
            cashTaxes.addAll(ticketObj.getTaxes());
            this.penaltyCash = MiscUtil.guarded((BigDecimal)ticketObj.getPenalty());
        } else if (!(!hasCCFop || hasCreditFop || hasMtdFop || hasCashFop || hasPKFop)) {
            this.fareCC = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)ticketObj));
            ccTaxes.addAll(ticketObj.getTaxes());
            this.penaltyCC = MiscUtil.guarded((BigDecimal)ticketObj.getPenalty());
        } else if (!(!hasPKFop || hasCCFop || hasCreditFop || hasMtdFop || hasCashFop)) {
            this.farePK = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)ticketObj));
            pkTaxes.addAll(ticketObj.getTaxes());
            this.penaltyPK = MiscUtil.guarded((BigDecimal)ticketObj.getPenalty());
        } else if ((hasCCFop || hasPKFop) && hasCashFop) {
            for (ProductFop fop4 : this.fops) {
                ptype = fop4.getType();
                if (fop4.getFares().isEmpty() && fop4.getTaxes().isEmpty() && !fop4.isHasPenaltyComponent()) {
                    SystemHelper.addMessage(messages, (String)Messages.TchTicket_fopNotConnected, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketObj.getSystemNumber(), fop4.getType()});
                    return;
                }
                if (ptype == PaymentType.CREDIT_CARD) {
                    this.fareCC = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.fareCC, this.getFare(fop4, ticketObj)});
                    ccTaxes.addAll(fop4.getTaxes());
                    this.penaltyCC = fop4.isHasPenaltyComponent() ? MiscUtil.guarded((BigDecimal)ticketObj.getPenalty()) : BigDecimal.ZERO;
                    continue;
                }
                if (ptype == PaymentType.CREDIT_CARD_TCH) {
                    this.farePK = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.farePK, this.getFare(fop4, ticketObj)});
                    pkTaxes.addAll(fop4.getTaxes());
                    this.penaltyPK = fop4.isHasPenaltyComponent() ? MiscUtil.guarded((BigDecimal)ticketObj.getPenalty()) : BigDecimal.ZERO;
                    continue;
                }
                this.fareCash = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.fareCash, this.getFare(fop4, ticketObj)});
                cashTaxes.addAll(fop4.getTaxes());
                this.penaltyCash = fop4.isHasPenaltyComponent() ? MiscUtil.guarded((BigDecimal)ticketObj.getPenalty()) : BigDecimal.ZERO;
            }
        } else if (hasCashFop && (hasCreditFop || hasMtdFop)) {
            for (ProductFop fop4 : this.fops) {
                ptype = fop4.getType();
                if (fop4.getFares().isEmpty() && fop4.getTaxes().isEmpty() && !fop4.isHasPenaltyComponent()) {
                    SystemHelper.addMessage(messages, (String)Messages.TchTicket_fopNotConnected, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketObj.getSystemNumber(), fop4.getType()});
                    return;
                }
                if (ptype != PaymentType.CASH) continue;
                this.fareCash = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.fareCash, this.getFare(fop4, ticketObj)});
                cashTaxes.addAll(fop4.getTaxes());
                this.penaltyCash = fop4.isHasPenaltyComponent() ? MiscUtil.guarded((BigDecimal)ticketObj.getPenalty()) : BigDecimal.ZERO;
            }
        } else if (hasCCFop && (hasCreditFop || hasMtdFop)) {
            for (ProductFop fop4 : this.fops) {
                ptype = fop4.getType();
                if (fop4.getFares().isEmpty() && fop4.getTaxes().isEmpty() && !fop4.isHasPenaltyComponent()) {
                    SystemHelper.addMessage(messages, (String)Messages.TchTicket_fopNotConnected, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketObj.getSystemNumber(), fop4.getType()});
                    return;
                }
                if (ptype != PaymentType.CREDIT_CARD) continue;
                this.fareCC = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.fareCC, this.getFare(fop4, ticketObj)});
                ccTaxes.addAll(fop4.getTaxes());
                this.penaltyCC = fop4.isHasPenaltyComponent() ? MiscUtil.guarded((BigDecimal)ticketObj.getPenalty()) : BigDecimal.ZERO;
            }
        } else if (hasPKFop && (hasCreditFop || hasMtdFop)) {
            for (ProductFop fop4 : this.fops) {
                ptype = fop4.getType();
                if (fop4.getFares().isEmpty() && fop4.getTaxes().isEmpty() && !fop4.isHasPenaltyComponent()) {
                    SystemHelper.addMessage(messages, (String)Messages.TchTicket_fopNotConnected, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticketObj.getSystemNumber(), fop4.getType()});
                    return;
                }
                if (ptype != PaymentType.CREDIT_CARD) continue;
                this.farePK = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.farePK, this.getFare(fop4, ticketObj)});
                pkTaxes.addAll(fop4.getTaxes());
                this.penaltyPK = fop4.isHasPenaltyComponent() ? MiscUtil.guarded((BigDecimal)ticketObj.getPenalty()) : BigDecimal.ZERO;
            }
        }
        this.tchTaxCash = BigDecimal.ZERO;
        this.xtTaxCash = BigDecimal.ZERO;
        for (Tax tax : cashTaxes) {
            if (tax.getEquivalentAmount() == null) continue;
            boolean tchTax = false;
            for (String code : taxesForBlankCodes) {
                if (!code.equals(tax.getCode())) continue;
                tchTax = true;
                break;
            }
            if (tchTax) {
                this.tchTaxCash = this.tchTaxCash.add(tax.getEquivalentAmount());
                continue;
            }
            this.xtTaxCash = this.xtTaxCash.add(tax.getEquivalentAmount());
        }
        this.tchTaxCC = BigDecimal.ZERO;
        this.xtTaxCC = BigDecimal.ZERO;
        for (Tax tax : ccTaxes) {
            if (tax.getEquivalentAmount() == null) continue;
            boolean tchTax = false;
            for (String code : taxesForBlankCodes) {
                if (!code.equals(tax.getCode())) continue;
                tchTax = true;
                break;
            }
            if (tchTax) {
                this.tchTaxCC = this.tchTaxCC.add(tax.getEquivalentAmount());
                continue;
            }
            this.xtTaxCC = this.xtTaxCC.add(tax.getEquivalentAmount());
        }
        this.tchTaxPK = BigDecimal.ZERO;
        this.xtTaxPK = BigDecimal.ZERO;
        for (Tax tax : pkTaxes) {
            if (tax.getEquivalentAmount() == null) continue;
            boolean tchTax = false;
            for (String code : taxesForBlankCodes) {
                if (!code.equals(tax.getCode())) continue;
                tchTax = true;
                break;
            }
            if (tchTax) {
                this.tchTaxPK = this.tchTaxPK.add(tax.getEquivalentAmount());
                continue;
            }
            this.xtTaxPK = this.xtTaxPK.add(tax.getEquivalentAmount());
        }
        this.cashValue = SalesReportHelper.getFopAmount(PaymentType.CASH, this, null).add(SalesReportHelper.getFopAmount(PaymentType.INVOICE, this, null)).add(SalesReportHelper.getFopAmount(PaymentType.CREDIT_CARD_TCH, this, null));
        this.krValue = SalesReportHelper.getFopAmount(PaymentType.CREDIT, this, null);
        this.vzValue = SalesReportHelper.getFopAmount(PaymentType.INTERLINE, this, null);
        this.creditCardValue = SalesReportHelper.getFopAmount(PaymentType.CREDIT_CARD, this, null);
        this.ptaValue = SalesReportHelper.getFopAmount(PaymentType.PTA, this, null);
        if (this.isExchangedPTA(ticketObj)) {
            this.fareCash = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)ticketObj.getPreviousProduct()));
            for (Tax tax : ticketObj.getPreviousProduct().getTaxes()) {
                if (tax.getEquivalentAmount() == null) continue;
                boolean tchTax = false;
                for (String code : taxesForBlankCodes) {
                    if (!code.equals(tax.getCode())) continue;
                    tchTax = true;
                    break;
                }
                if (tchTax) {
                    this.tchTaxCash = this.tchTaxCash.subtract(tax.getEquivalentAmount());
                    continue;
                }
                this.xtTaxCash = this.xtTaxCash.subtract(tax.getEquivalentAmount());
            }
        } else if (SalesReportHelper.isHasFop(AirProductHelper.getVendorContractRelation((Product)ticketObj).getFops(), PaymentType.PTA) || hasCreditFop && !hasCashFop && !hasCCFop && !hasPKFop) {
            this.fareCash = BigDecimal.ZERO;
            this.fareCC = BigDecimal.ZERO;
            this.farePK = BigDecimal.ZERO;
            this.tchTaxCash = BigDecimal.ZERO;
            this.tchTaxCC = BigDecimal.ZERO;
            this.tchTaxPK = BigDecimal.ZERO;
            this.xtTaxCash = BigDecimal.ZERO;
            this.xtTaxCC = BigDecimal.ZERO;
            this.xtTaxPK = BigDecimal.ZERO;
            this.penaltyCash = BigDecimal.ZERO;
            this.penaltyCC = BigDecimal.ZERO;
            this.penaltyPK = BigDecimal.ZERO;
        }
    }

    private BigDecimal getFare(ProductFop fop, Product prod) {
        BigDecimal fare = MiscUtil.guarded(fop.getAmount() == null ? null : fop.getAmount().getValue());
        for (Tax tax : fop.getTaxes()) {
            if (tax.getEquivalentAmount() == null) continue;
            fare = fare.subtract(tax.getEquivalentAmount());
        }
        if (fop.isHasPenaltyComponent()) {
            fare = prod.getStatus() == ProductStatus.REFUND ? fare.add(MiscUtil.guarded((BigDecimal)prod.getPenalty())) : fare.subtract(prod.getPenalty());
        }
        return fare;
    }

    private String calculateSubsidizedPackId(Product ticketObj) {
        boolean hasMOW = false;
        boolean hasKGD = false;
        for (SegmentTariff st : ticketObj.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                hasMOW = hasMOW || this.isMOW((DictionaryReference<GeoLocation>)seg.getDepartureLocation());
                hasMOW = hasMOW || this.isMOW((DictionaryReference<GeoLocation>)seg.getArriveLocation());
                hasKGD = hasKGD || this.isKGD((DictionaryReference<GeoLocation>)seg.getDepartureLocation());
                hasKGD = hasKGD || this.isKGD((DictionaryReference<GeoLocation>)seg.getArriveLocation());
            }
        }
        String direction = null;
        direction = hasKGD ? (hasMOW ? "MOW-KGD" : "REG") : (hasMOW ? "MOW-DVOST" : "REG");
        return String.format("%s-%s", this.getValidatingAirlineCode(ticketObj), direction);
    }

    private boolean isKGD(DictionaryReference<GeoLocation> loc) {
        return "KGD".equals(this.getLocationCode(loc));
    }

    private boolean isMOW(DictionaryReference<GeoLocation> loc) {
        return "MOW".equals(this.getLocationCode(loc));
    }

    private String getValidatingAirlineCode(Product ticketObj) {
        if (ticketObj.getCarrier() != null) {
            Airline airline = (Airline)DictionaryCache.get().resolveReference(ticketObj.getCarrier());
            if (airline != null) {
                String codeVariant = DictHelper.getCodeVariant((BaseDictionary)airline, (CodeSystem)CodeSystem.IATA);
                if (codeVariant != null) {
                    return codeVariant;
                }
                codeVariant = DictHelper.getCodeVariant((BaseDictionary)airline, (CodeSystem)CodeSystem.CRT);
                if (codeVariant != null) {
                    return codeVariant;
                }
                return airline.getCode();
            }
            return ticketObj.getCarrier().getCode();
        }
        return "???";
    }

    private String getLocationCode(DictionaryReference<GeoLocation> loc) {
        String result = DictHelper.findCityCode(loc, (CodeSystem)CodeSystem.IATA, (boolean)false);
        return TextUtil.isBlank((String)result) ? "???" : result;
    }

    private Airline getAirline(DictionaryReference<Airline> al) {
        Airline airline2 = (Airline)DictionaryCache.get().resolveReference(al);
        if (airline2 != null) {
            return airline2;
        }
        airline2 = new Airline();
        airline2.setCode(al.getCode());
        return airline2;
    }

    private boolean isExchangedPTA(Product ticketObj) {
        if (ticketObj.getStatus() != ProductStatus.SELL) {
            return false;
        }
        if (ticketObj.getProductCategory() != ProductCategory.AIR) {
            return false;
        }
        if (ticketObj.getPreviousProduct() == null || ticketObj.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) {
            return false;
        }
        if (!SalesReportHelper.isHasFop(AirProductHelper.getVendorContractRelation((Product)ticketObj.getPreviousProduct()).getFops(), PaymentType.PTA)) {
            return false;
        }
        return SalesReportHelper.isHasFop(AirProductHelper.getVendorContractRelation((Product)ticketObj).getFops(), PaymentType.CASH);
    }

    @Override
    public BigDecimal getEquivalentFare() {
        return this.equivalentFare != null ? this.equivalentFare : BigDecimal.ZERO;
    }

    private String getAirlineCode(Airline airline) {
        if (airline == null) {
            return null;
        }
        String code = (String)airline.getCodeVariants().get(CodeSystem.CRT.name());
        if (!TextUtil.isBlank((String)code)) {
            return code.trim();
        }
        code = (String)airline.getCodeVariants().get(CodeSystem.IATA.name());
        if (!TextUtil.isBlank((String)code)) {
            return code.trim();
        }
        return airline.getCode();
    }

    private String getAirlineCode(DictionaryReference<Airline> aBlankOwner) {
        if (aBlankOwner == null) {
            return null;
        }
        Airline item = (Airline)DictionaryCache.get().resolveReference(aBlankOwner);
        if (item == null) {
            return aBlankOwner.getCode();
        }
        return this.getAirlineCode(item);
    }

    public CardVendor getCardVendor() {
        return this.cardVendor;
    }

    public String getCarrierCode() {
        return this.carrierCode;
    }

    public String[] getCarrierCodes() {
        return this.carrierCodes;
    }

    public String getCarrierName() {
        return this.carrierName;
    }

    public String[] getCarrierNames() {
        return this.carrierNames;
    }

    public String getCarrierNumber() {
        return this.carrierNumber;
    }

    public String getCashier() {
        return this.cashier;
    }

    public BigDecimal getFareCash() {
        return this.fareCash;
    }

    public BigDecimal getFareCC() {
        return this.fareCC;
    }

    public BigDecimal getKrValue() {
        return this.krValue;
    }

    public BigDecimal getPtaValue() {
        return this.ptaValue;
    }

    public Set<ProductFop> getRelatedProductFops() {
        return this.relatedProductFops;
    }

    public String getRelatedTicketNo() {
        return this.relatedTicketNo;
    }

    public String getScn() {
        return this.scn;
    }

    public BigDecimal getTchTaxCash() {
        return this.tchTaxCash;
    }

    public BigDecimal getTchTaxCC() {
        return this.tchTaxCC;
    }

    public String getValidator() {
        return this.validator;
    }

    public BigDecimal getVzValue() {
        return this.vzValue;
    }

    public BigDecimal getXtTaxCash() {
        return this.xtTaxCash;
    }

    public BigDecimal getXtTaxCC() {
        return this.xtTaxCC;
    }

    public boolean isAdditionalSegment() {
        return this.additionalSegment;
    }

    public boolean isConjunctedTicket() {
        return this.conjunctedTicket;
    }

    public boolean isDirectContract() {
        return this.directContract;
    }

    public boolean isFakeProduct() {
        return this.fakeProduct;
    }

    public boolean isVatIncluded() {
        return this.vatIncluded;
    }

    public void setAdditionalSegment(boolean value) {
        this.additionalSegment = value;
    }

    public void setCardVendor(CardVendor value) {
        this.cardVendor = value;
    }

    public void setConjunctedTicket(boolean value) {
        this.conjunctedTicket = value;
    }

    public void setDirectContract(boolean value) {
        this.directContract = value;
    }

    public void setRelatedTicketNo(String value) {
        this.relatedTicketNo = value;
    }

    public boolean isExchangePenaltyMCO() {
        return this.exchangePenaltyMCO;
    }

    public boolean isSubsidizedTariff() {
        return this.subsidizedTariff;
    }

    public String toString() {
        return String.format("%s, status = %s, airline = %s", this.getTicketNumber(), this.getStatus(), this.getCarrierName());
    }

    public boolean isAgencyMemo() {
        return this.agencyMemoProduct;
    }

    public static boolean isIncludePrintedTicketsInReport(ReportParameters params) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(params.getPeriodBegin());
        return cal.get(1) >= 2015 && (cal.get(1) != 2015 || cal.get(2) != 0 || cal.get(5) >= 11);
    }

    public TchCreditCardAccompanyingDocumentType getCreditCardAccompanyingDocumentType() {
        return this.creditCardAccompanyingDocumentType;
    }

    public String getSubsidizedPackId() {
        return this.subsidizedPackId;
    }

    public boolean isReturnFareDifference() {
        return this.returnFareDifference;
    }

    public BigDecimal getFarePK() {
        return this.farePK;
    }

    public BigDecimal getTchTaxPK() {
        return this.tchTaxPK;
    }

    public BigDecimal getXtTaxPK() {
        return this.xtTaxPK;
    }

    public BigDecimal getPkFeeValue() {
        return this.pkFeeValue;
    }

    public BigDecimal getPenaltyCash() {
        return this.penaltyCash;
    }

    public BigDecimal getPenaltyCC() {
        return this.penaltyCC;
    }

    public BigDecimal getPenaltyPK() {
        return this.penaltyPK;
    }

    public BigDecimal getPkClientFeeEquivalentValue() {
        return this.pkClientFeeEquivalentValue;
    }
}

