/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.u6;

import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.BaseU6ReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.U6SalesReportTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class U6TicketLuggageRegistryReportWorksheetHandler
extends BaseU6ReportWorksheetHandler {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<U6SalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        if (data.getTickets().isEmpty()) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        int startRow = 11;
        int endRow = 19;
        int rowCounter = 0;
        if (data.getTickets().size() > 1) {
            sheet.shiftRows(startRow - 1, endRow - 1, data.getTickets().size() - 1);
        }
        int currentRow = startRow;
        ArrayList<U6SalesReportTicket> tickets = new ArrayList<U6SalesReportTicket>();
        tickets.addAll(data.getTickets());
        Collections.sort(tickets, new Comparator<U6SalesReportTicket>(){

            @Override
            public int compare(U6SalesReportTicket o1, U6SalesReportTicket o2) {
                if (o1.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE && o2.getMcoCategory() != MCOCategory.EXCESS_LUGGAGE) {
                    return 1;
                }
                if (o2.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE && o1.getMcoCategory() != MCOCategory.EXCESS_LUGGAGE) {
                    return -1;
                }
                if (TextUtil.isBlank((String)o1.getTicketNumber()) && !TextUtil.isBlank((String)o2.getTicketNumber())) {
                    return 1;
                }
                if (TextUtil.isBlank((String)o2.getTicketNumber()) && !TextUtil.isBlank((String)o1.getTicketNumber())) {
                    return -1;
                }
                if (TextUtil.isBlank((String)o1.getTicketNumber()) && TextUtil.isBlank((String)o2.getTicketNumber())) {
                    return 0;
                }
                return o1.getTicketNumber().compareTo(o2.getTicketNumber());
            }
        });
        HSSFCellStyle cellStyle = this.createCellStyle(wb);
        for (U6SalesReportTicket ticket : tickets) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)1, (int)(++rowCounter));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)2, (String)ticket.getTicketNumber());
            if (!ticket.isVoidTicket()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)sdf.format(ticket.getIssueDate()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (String)ticket.getFlightNumber());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (String)ticket.getItinerary());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (Double)ticket.getLuggageAmount());
                double pricePerKg = ticket.getLuggageAmount() > 0.0 && ticket.getEquivalentFare() != null ? ticket.getEquivalentFare().doubleValue() / ticket.getLuggageAmount() : 0.0;
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (Double)pricePerKg);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (BigDecimal)ticket.getEquivalentFare());
                if (ticket.getCommission() != null && ticket.getCommission().getEquivalentAmount() != null) {
                    ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (BigDecimal)ticket.getCommission().getEquivalentAmount());
                }
            }
            this.formatRow(sheet, currentRow, cellStyle);
            ++currentRow;
        }
        endRow = currentRow - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (String)String.format("=SUM(H%s:H%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (String)String.format("=SUM(I%s:I%s)", startRow, endRow));
    }

    private void formatRow(HSSFSheet sheet, int currentRow, HSSFCellStyle cellStyle) {
        HSSFRow row = sheet.getRow(currentRow - 1);
        for (int i = 0; i < 9; ++i) {
            HSSFCell cell = row.getCell(i);
            if (cell == null) {
                cell = row.createCell(i);
            }
            cell.setCellStyle(cellStyle);
        }
    }
}

