/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.u6;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.BaseU6ReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.U6SalesReportTicket;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class U6TicketPenaltyRegistryReportWorksheetHandler
extends BaseU6ReportWorksheetHandler {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<U6SalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        if (data.getTickets().isEmpty()) {
            return;
        }
        int startRow = 10;
        int endRow = 18;
        int rowCounter = 0;
        if (data.getTickets().size() > 1) {
            sheet.shiftRows(startRow - 1, endRow - 1, data.getTickets().size() - 1);
        }
        int currentRow = startRow;
        HSSFCellStyle cellStyle = this.createCellStyle(wb);
        HSSFCellStyle dateCellStyle = this.createDateCellStyle(wb);
        HSSFCellStyle numberCellStyle = this.createNumberCellStyle(wb);
        for (U6SalesReportTicket ticket : data.getTickets()) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)1, (int)(++rowCounter));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)2, (String)ticket.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)ticket.getAgentGDSCode());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (Date)ticket.getIssueDate());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (BigDecimal)ticket.getPrice());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (BigDecimal)ticket.getAddFareCommission());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (BigDecimal)BigDecimal.ZERO);
            if (ticket.getCommission() != null && ticket.getCommission().getEquivalentAmount() != null) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (Double)ticket.getCommissionRate());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (BigDecimal)ticket.getCommission().getEquivalentAmount());
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (String)ticket.getRelatedTicketNumber());
            this.formatRow(sheet, currentRow, cellStyle, dateCellStyle, numberCellStyle);
            ++currentRow;
        }
        endRow = currentRow - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (String)String.format("=SUM(E%s:E%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (String)String.format("=SUM(F%s:F%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (String)String.format("=SUM(G%s:G%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (String)String.format("=SUM(I%s:I%s)", startRow, endRow));
    }

    private void formatRow(HSSFSheet sheet, int currentRow, HSSFCellStyle cellStyle, HSSFCellStyle dateCellStyle, HSSFCellStyle numberCellStyle) {
        HSSFRow row = sheet.getRow(currentRow - 1);
        block4: for (int i = 0; i < 10; ++i) {
            HSSFCell cell = row.getCell(i);
            if (cell == null) {
                cell = row.createCell(i);
            }
            switch (i) {
                case 3: {
                    cell.setCellStyle(dateCellStyle);
                    continue block4;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    cell.setCellStyle(numberCellStyle);
                    continue block4;
                }
                default: {
                    cell.setCellStyle(cellStyle);
                }
            }
        }
    }
}

