/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.u6;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.BaseU6ReportWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.U6SalesReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class U6TicketRefundRegistryReportWorksheetHandler
extends BaseU6ReportWorksheetHandler {
    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<U6SalesReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        if (data.getTickets().isEmpty()) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        int startRow = 11;
        int endRow = 19;
        int rowCounter = 0;
        if (data.getTickets().size() > 1) {
            sheet.shiftRows(startRow - 1, endRow - 1, data.getTickets().size() - 1);
        }
        int currentRow = startRow;
        HSSFCellStyle cellStyle = this.createCellStyle(wb);
        HSSFCellStyle dateCellStyle = this.createDateCellStyle(wb);
        HSSFCellStyle numberCellStyle = this.createNumberCellStyle(wb);
        for (U6SalesReportTicket ticket : data.getTickets()) {
            BigDecimal totalTaxes = BigDecimal.ZERO;
            BigDecimal YRTax = BigDecimal.ZERO;
            for (Tax tax : ticket.getTaxes()) {
                if (tax.getCode().equals("YR")) {
                    YRTax = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tax.getEquivalentAmount(), YRTax});
                    continue;
                }
                totalTaxes = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tax.getEquivalentAmount(), totalTaxes});
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)1, (int)(++rowCounter));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)2, (String)ticket.getFullTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)this.df.format(ticket.getSellDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (String)ticket.getItinerary());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (Date)AirProductHelper.getFirstDepartureDate((Product)ticket.getSourceProduct()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)6, (String)sdf.format(ticket.getIssueDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)7, (String)ticket.getTariffCodes());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (BigDecimal)ticket.getEquivalentFare());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (BigDecimal)totalTaxes);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (BigDecimal)MiscUtil.negate((BigDecimal)ticket.getPenalty()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)11, (BigDecimal)YRTax);
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)12, (String)String.format("=SUM(I%1$s:K%1$s) + H%1$s", currentRow));
            if (ticket.getCommission() != null && ticket.getCommission().getEquivalentAmount() != null) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)13, (Double)ticket.getCommissionRate());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)14, (BigDecimal)MiscUtil.negate((BigDecimal)ticket.getCommission().getEquivalentAmount()));
            }
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)15, (String)String.format("=L%1$s + N%1$s", currentRow));
            this.formatRow(sheet, currentRow, cellStyle, dateCellStyle, numberCellStyle);
            ++currentRow;
        }
        endRow = currentRow - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)8, (String)String.format("=SUM(H%s:H%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)9, (String)String.format("=SUM(I%s:I%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)10, (String)String.format("=SUM(J%s:J%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)11, (String)String.format("=SUM(K%s:K%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)12, (String)String.format("=SUM(L%s:L%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)14, (String)String.format("=SUM(N%s:N%s)", startRow, endRow));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)15, (String)String.format("=SUM(O%s:O%s)", startRow, endRow));
    }

    private void formatRow(HSSFSheet sheet, int currentRow, HSSFCellStyle cellStyle, HSSFCellStyle dateCellStyle, HSSFCellStyle numberCellStyle) {
        HSSFRow row = sheet.getRow(currentRow - 1);
        block4: for (int i = 0; i < 15; ++i) {
            HSSFCell cell = row.getCell(i);
            if (cell == null) {
                cell = row.createCell(i);
            }
            switch (i) {
                case 1: 
                case 3: 
                case 6: 
                case 12: {
                    cell.setCellStyle(cellStyle);
                    continue block4;
                }
                case 2: 
                case 4: 
                case 5: {
                    cell.setCellStyle(dateCellStyle);
                    continue block4;
                }
                default: {
                    cell.setCellStyle(numberCellStyle);
                }
            }
        }
    }
}

