/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.un.xls;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UNReportTicket
extends TchTicket {
    private static final long serialVersionUID = 5143359083991349852L;
    private final String transportationTypeStr;
    private final BigDecimal taxCA;
    private BigDecimal penaltyCA = null;
    private final BigDecimal commissionCA;
    private final BigDecimal taxCC;
    private BigDecimal penaltyCC = null;
    private String sortingTicketNumber = null;
    private final double commissionRate;
    private final String route;
    private BigDecimal total = BigDecimal.ZERO;
    private BigDecimal commissionValue = BigDecimal.ZERO;
    private BigDecimal refundCommission = BigDecimal.ZERO;
    private BigDecimal clientCommission = BigDecimal.ZERO;

    public UNReportTicket(Product ticketObj, Map<String, Object> data) throws Exception {
        super(ticketObj, (List<Message>)((List)data.get("key-messages")));
        Double rate;
        Object product;
        this.transportationTypeStr = this.isVatIncluded() ? L10nResourcesManager.createL10nMessage((String)Messages.UNBSPReportTicket_transpTypeMvl, (Object[])new Object[0]).toString() : L10nResourcesManager.createL10nMessage((String)Messages.UNBSPReportTicket_transpTypeVvl, (Object[])new Object[0]).toString();
        this.penaltyCA = this.getFareCash() != null && this.getFareCash().doubleValue() > 0.0 ? this.getPenalty() : null;
        this.penaltyCC = this.getFareCC() != null && this.getFareCC().doubleValue() > 0.0 ? this.getPenalty() : null;
        this.taxCA = this.getTchTaxCash().add(this.getXtTaxCash());
        this.taxCC = this.getTchTaxCC().add(this.getXtTaxCC());
        this.commissionCA = this.getVendorEquivalentCommission();
        this.route = AirProductHelper.getRouteLine((Product)ticketObj);
        BigDecimal fare = this.getEquivalentFare();
        if (fare != null) {
            this.total = this.total.add(fare);
        }
        if (ticketObj.getPenalty() != null) {
            if (ticketObj.getStatus() == ProductStatus.REFUND) {
                this.total = this.total.subtract(ticketObj.getPenalty());
            }
            if (ticketObj.getStatus() == ProductStatus.EXCHANGE && (ticketObj.getNextProduct() == null || ticketObj.getNextProduct().getPenalty() == null || BigDecimal.ZERO.compareTo(ticketObj.getNextProduct().getPenalty()) == 0)) {
                this.total = this.total.subtract(ticketObj.getPenalty());
            }
            if (ticketObj.getStatus() == ProductStatus.SELL && ticketObj.getPreviousProduct() != null && ticketObj.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                this.total = this.total.add(ticketObj.getPenalty());
            }
        }
        this.total = this.total.add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)ticketObj));
        this.sortingTicketNumber = this.getTicketNumber();
        if ((ticketObj.getMcoCategory() == MCOCategory.PENALTY || ticketObj.getMcoCategory() == MCOCategory.INFORMATION) && (product = AirProductHelper.findRelatedAirProduct((Product)ticketObj, null, (boolean)false)) != null) {
            this.sortingTicketNumber = product.getSystemNumber();
            ProductStatus productStatus = this.status = product.getStatus() == ProductStatus.EXCHANGE ? ProductStatus.EXCHANGE : ProductStatus.REFUND;
        }
        if (ticketObj.getStatus() == ProductStatus.VOID || ticketObj.getStatus() == ProductStatus.VOID_BOOKING) {
            this.sortingTicketNumber = "!" + this.sortingTicketNumber;
        }
        for (Product mco : AirProductHelper.getMcoByRelatedProduct((Product)ticketObj)) {
            if (mco.getMcoCategory() != MCOCategory.PENALTY) continue;
            this.penaltyCA = BigDecimal.ZERO;
            this.penaltyCC = BigDecimal.ZERO;
            break;
        }
        if (ticketObj.getStatus() == ProductStatus.EXCHANGE && ticketObj.getNextProduct() != null) {
            this.sortingTicketNumber = ticketObj.getNextProduct().getSystemNumber();
        }
        double d = this.commissionRate = (rate = super.getVendorCommissionRate()) == null ? 0.0 : rate;
        if (ticketObj.getStatus() == ProductStatus.REFUND || ticketObj.getStatus() == ProductStatus.EXCHANGE) {
            this.commissionValue = this.commissionValue.negate();
            this.total = this.total.negate();
        }
        if (ticketObj.getStatus() == ProductStatus.VOID || ticketObj.getStatus() == ProductStatus.VOID_BOOKING) {
            this.commissionValue = BigDecimal.ZERO;
            this.total = BigDecimal.ZERO;
        }
        this.refundCommission = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)ticketObj, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null));
        this.clientCommission = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)ticketObj, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null));
    }

    public double getCommissionRate() {
        return this.commissionRate;
    }

    public String getTransportationTypeStr() {
        return this.transportationTypeStr;
    }

    public BigDecimal getTaxCA() {
        return this.taxCA;
    }

    public BigDecimal getPenaltyCA() {
        return this.penaltyCA == null ? BigDecimal.ZERO : this.penaltyCA;
    }

    public BigDecimal getCommissionCA() {
        return this.commissionCA == null ? BigDecimal.ZERO : this.commissionCA;
    }

    public BigDecimal getTaxCC() {
        return this.taxCC;
    }

    @Override
    public BigDecimal getPenaltyCC() {
        return this.penaltyCC == null ? BigDecimal.ZERO : this.penaltyCC;
    }

    public String getSortingTicketNumber() {
        return this.sortingTicketNumber;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public String getRoute() {
        return this.route;
    }

    public BigDecimal getRefundCommission() {
        return this.refundCommission;
    }

    public BigDecimal getClientCommission() {
        return this.clientCommission;
    }
}

