/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.un.xls;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.BaseUNSummarySheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNRegistrySellSheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNReportTicket;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

class UNVoidSheetHandler
extends BaseUNSummarySheetHandler {
    UNVoidSheetHandler() {
    }

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<UNReportTicket> data, Map<String, Object> globalData) throws Exception {
        super.fill(wb, sheet, data, globalData);
        List<UNReportTicket> tickets = data.getTickets();
        Collections.sort(tickets, UNRegistrySellSheetHandler.ticketCcomparator);
        int startRow = 8;
        for (int i = 1; i < tickets.size(); ++i) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)startRow, (int)startRow);
        }
        for (int n = 0; n < tickets.size(); ++n) {
            UNReportTicket ticket = tickets.get(n);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)1, (int)(n + 1));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)2, (String)ticket.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)3, (String)UNRegistrySellSheetHandler.createDateFormat().format(ticket.getIssueDate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)3, (int)1, (int)(n + startRow - 1), (int)4, (BigDecimal)ticket.getTotal());
        }
        int row = startRow + 1 + (tickets.size() > 0 ? tickets.size() : 1);
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)1, (int)1, (int)row, (int)4, (String)String.format("=SUM(D8:D%s)", Integer.toString(row - 1)));
    }
}

