/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.un.xml;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xml.UNXmlBatchHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xml.UNXmlValidator;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UNXmlReportRender {
    public EntityContainer<ReportDocument> renderReport(Map<String, Object> parameters) throws Exception {
        if (parameters.get("key-batch-data-list") == null) {
            return null;
        }
        ReportFile reportFile = new ReportFile();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(false);
        Document xmlDocument = builderFactory.newDocumentBuilder().newDocument();
        String reportCategory = "PAX";
        xmlDocument.createDocumentFragment();
        ReportParameters repParam = (ReportParameters)parameters.get("key-report-params");
        Date beginDate = repParam.getPeriodBegin();
        Date endDate = repParam.getPeriodEnd();
        String agencyReportCode = (String)parameters.get("AGENCY_IATA_CODE");
        String airlineIataCode = (String)parameters.get("AIRLINE_IATA_CODE");
        String equivalentCurr = SalesReportHelper.getEquivCurrency(null);
        Element root = xmlDocument.createElementNS(this.getNamespaceURI(), "REPORT");
        xmlDocument.appendChild(root);
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.hypersoft.ru/XMLSchema RPT_PAX_se_v_4_1_1.xsd");
        String airlineCode = (String)parameters.get("AIRLINE_IATA_CODE");
        root.appendChild(this.writeElement(xmlDocument, "AIRLINE", airlineCode));
        root.appendChild(this.writeElement(xmlDocument, "AGENCY", agencyReportCode));
        root.appendChild(this.writeElement(xmlDocument, "PERIOD_BEGIN", new SimpleDateFormat("yyyy-MM-dd").format(beginDate)));
        root.appendChild(this.writeElement(xmlDocument, "PERIOD_END", new SimpleDateFormat("yyyy-MM-dd").format(endDate)));
        root.appendChild(this.writeElement(xmlDocument, "CATEGORY", reportCategory));
        root.appendChild(this.writeElement(xmlDocument, "CURRENCY", SalesReportHelper.getEquivCurrency(null)));
        Element xmlSubReport = this.writeElement(xmlDocument, "SUBREPORT", null);
        root.appendChild(xmlSubReport);
        Collection batchDataList = (Collection)parameters.get("key-batch-data-list");
        if (batchDataList != null) {
            for (Object batchData : batchDataList) {
                SuSalesReportBatchData batchDataSuReport;
                UNXmlBatchHandler batchHandler;
                if (!(batchData instanceof SuSalesReportBatchData) || (batchHandler = XmlReportDefinitions.getHandler((batchDataSuReport = (SuSalesReportBatchData)batchData).getBatchId())) == null) continue;
                batchHandler.renderReportBatch(xmlDocument, xmlSubReport, batchDataSuReport);
            }
        }
        StringWriter out = new StringWriter();
        this.getTransformer().transform(new DOMSource(xmlDocument), new StreamResult(out));
        reportFile.setContent(out.toString().getBytes("utf-8"));
        reportFile.setContentType(ContentType.XML);
        String reportFileName = "" + airlineIataCode + "_" + agencyReportCode + (String)parameters.get("KEY_REPORT_FILENAME") + "_" + equivalentCurr;
        reportFile.setTitle(reportFileName);
        reportFile.setName(reportFileName + ".xml");
        EntityContainer reportDocContainer = new EntityContainer(ReportDocument.class);
        ReportDocument reportDoc = (ReportDocument)reportDocContainer.getEntity();
        reportDoc.getFiles().add(reportFile);
        this.validate(xmlDocument, reportDoc);
        return reportDocContainer;
    }

    private void validate(Document doc, ReportDocument reportDoc) {
        try {
            String validate = UNXmlValidator.validate(doc);
            if (!TextUtil.isBlank((String)validate)) {
                reportDoc.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.SuXmlReportRender_errorValidatingXmlReport, (Object[])new Object[]{validate}));
            }
        }
        catch (Exception e) {
            reportDoc.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SuXmlReportRender_failedValidatingXmlReport, (Throwable)e, (Object[])new Object[0]));
        }
    }

    protected Element writeElement(Document doc, String name, Object value) {
        Element result = doc.createElementNS(this.getNamespaceURI(), name);
        if (value != null) {
            result.appendChild(doc.createTextNode(value.toString()));
        }
        return result;
    }

    private String getNamespaceURI() {
        return "http://www.hypersoft.ru/XMLSchema";
    }

    private Transformer getTransformer() throws Exception {
        Transformer result = XUtil.newTransformer();
        result.setOutputProperty("method", "xml");
        result.setOutputProperty("indent", "yes");
        result.setOutputProperty("omit-xml-declaration", "no");
        result.setOutputProperty("standalone", "no");
        result.setOutputProperty("encoding", "utf-8");
        return result;
    }

    public static enum XmlReportDefinitions {
        CANCEL{

            @Override
            public UNXmlBatchHandler getHandler() {
                return new UNXmlBatchHandler(){

                    @Override
                    protected String getTransactionType(SuTicket ticket) {
                        return "CANCEL";
                    }
                };
            }

            @Override
            public Integer getSortOrder() {
                return 1;
            }
        }
        ,
        REFUND{

            @Override
            public UNXmlBatchHandler getHandler() {
                return new UNXmlBatchHandler(){

                    @Override
                    protected String getTransactionType(SuTicket ticket) {
                        if (ProductCategory.MCO == ticket.getProductCategory() && ProductStatus.SELL == ticket.getStatus()) {
                            return "SALE";
                        }
                        return ProductStatus.REFUND.name();
                    }
                };
            }

            @Override
            public Integer getSortOrder() {
                return 2;
            }
        }
        ,
        EXC{

            @Override
            public UNXmlBatchHandler getHandler() {
                return new UNXmlBatchHandler(){

                    @Override
                    protected String getTransactionType(SuTicket ticket) {
                        if (ticket.getStatus() == ProductStatus.EXCHANGE) {
                            return ProductStatus.REFUND.name();
                        }
                        return "SALE";
                    }

                    @Override
                    protected String getExchangeMarker() {
                        return "\u0414\u0410";
                    }
                };
            }

            @Override
            public Integer getSortOrder() {
                return 3;
            }
        }
        ,
        SALE{

            @Override
            public UNXmlBatchHandler getHandler() {
                return new UNXmlBatchHandler(){

                    @Override
                    protected String getTransactionType(SuTicket ticket) {
                        return ticket.isSticker() ? "STICKER" : "SALE";
                    }
                };
            }

            @Override
            public Integer getSortOrder() {
                return 4;
            }
        }
        ,
        MEMO{

            @Override
            public UNXmlBatchHandler getHandler() {
                return new UNXmlBatchHandler(){

                    @Override
                    protected String getTransactionType(SuTicket ticket) {
                        return "SALE";
                    }
                };
            }

            @Override
            public Integer getSortOrder() {
                return 5;
            }
        };


        public int getBatchSize() {
            return 50;
        }

        public String getName() {
            return this.name();
        }

        public abstract UNXmlBatchHandler getHandler();

        public static UNXmlBatchHandler getHandler(String batchId) {
            for (XmlReportDefinitions def : XmlReportDefinitions.values()) {
                if (!def.name().equals(batchId)) continue;
                return def.getHandler();
            }
            return null;
        }

        public abstract Integer getSortOrder();
    }
}

