/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.xf;

import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFTicket;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class XFRegistryRefundListWorksheetHandler
implements PoiWorksheetHandler<XFTicket> {
    private static final int TICKETS_ROW_OFFSET = 5;

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<XFTicket> data, Map<String, Object> globalData) throws Exception {
        BaseReportParameters params = (BaseReportParameters)globalData.get("key-report-params");
        Date startDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy", new Locale("ru", "RU"));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_START", (String)dateFormat.format(startDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_END", (String)dateFormat.format(endDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)((String)globalData.get("AGENCY_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)((String)globalData.get("AGENCY_DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)((String)globalData.get("AGENCY_ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_CHIEF_MUTUAL", (String)((String)globalData.get("AGENCY_CHIEF_MUTUAL")));
        List<XFTicket> tickets = data.getTickets();
        if (tickets.isEmpty()) {
            return;
        }
        int shiftLinesCount = sheet.getLastRowNum() - 5;
        int lineNumber = 5;
        for (int i = 0; i < tickets.size(); ++i) {
            XFTicket ticket = tickets.get(i);
            ++lineNumber;
            if (i < tickets.size() - 1) {
                ExcelUtils.insertRow((HSSFSheet)sheet, (int)lineNumber, (int)15, (int)shiftLinesCount);
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)1, (int)1, (int)1, (int)(i + 1));
            String number = XFReportHelper.getNumberString(ticket.getBlankOwnerCode(), ticket.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)2, (int)1, (int)1, (String)number);
            if (ticket.getProductCategory() == ProductCategory.MCO) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)3, (int)1, (int)1, (Date)ticket.getRelatedSellProductIssueDate());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)5, (int)1, (int)1, (String)"\u0448\u0442\u0440\u0430\u0444");
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)7, (int)1, (int)1, (Date)ticket.getRelatedRefundProductIssueDate());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)9, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue((BigDecimal)null));
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)3, (int)1, (int)1, (Date)ticket.getPreviousProductIssueDate());
                String flightNumbers = XFReportHelper.getFlightNumbersString(ticket.getPreviousProductFlightNumbers());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)4, (int)1, (int)1, (String)flightNumbers);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)5, (int)1, (int)1, (String)ticket.getTicketRouting());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)6, (int)1, (int)1, (Date)ticket.getFirstFlightDepartureDate());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)7, (int)1, (int)1, (Date)ticket.getIssueDate());
                String fareBasises = XFReportHelper.getFareBasisesString(ticket.getFareBasises());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)8, (int)1, (int)1, (String)fareBasises);
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)9, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getEquivalentFare()));
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)10, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getOtherTaxesAmount()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)11, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getYRTaxesAmount()));
            if (ticket.getProductCategory() == ProductCategory.MCO) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)12, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getEquivalentFare()));
            } else {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)12, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getPenalty()));
            }
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)13, (int)1, (int)1, (Double)ReportHelper.getNonNullValue(ticket.getVendorCommissionRate()));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)lineNumber, (int)14, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(ticket.getVendorEquivalentCommission()));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)15, (int)1, (int)1, (String)String.format("=I%s+J%s+K%s-L%s-N%s", lineNumber, lineNumber, lineNumber, lineNumber, lineNumber));
        }
        Integer startRangeIndex = 6;
        Integer endRangeIndex = 6 + tickets.size() - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(++lineNumber), (int)9, (int)1, (int)1, (String)String.format("=SUM(I%s:I%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)10, (int)1, (int)1, (String)String.format("=SUM(J%s:J%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)11, (int)1, (int)1, (String)String.format("=SUM(K%s:K%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)12, (int)1, (int)1, (String)String.format("=SUM(L%s:L%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)14, (int)1, (int)1, (String)String.format("=SUM(N%s:N%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lineNumber, (int)15, (int)1, (int)1, (String)String.format("=SUM(O%s:O%s)", startRangeIndex, endRangeIndex));
    }
}

