/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.xf;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class XFReportHelper {
    public static String getNumberString(String blankOwnerCode, String systemNumber) {
        StringBuilder number = new StringBuilder();
        Airline airline = (Airline)DictionaryCache.get().resolveReference((DictionaryReference)new AirlineReference(blankOwnerCode));
        if (airline != null) {
            number.append(airline.getAirlineNumber());
        }
        if (systemNumber != null) {
            if (number.length() > 0) {
                number.append("   ");
            }
            number.append(systemNumber);
        }
        return number.toString();
    }

    public static String getFlightNumbersString(List<String> flightNumbers) {
        StringBuilder flightNumbersString = new StringBuilder();
        for (String flightNumber : flightNumbers) {
            if (TextUtil.isBlank((String)flightNumber)) continue;
            if (flightNumbersString.length() > 0) {
                flightNumbersString.append(" / ");
            }
            flightNumbersString.append(flightNumber);
        }
        return flightNumbersString.toString();
    }

    public static String getFareBasisesString(List<String> fareBasises) {
        StringBuilder fareBasisesString = new StringBuilder();
        for (String fareBasis : fareBasises) {
            if (TextUtil.isBlank((String)fareBasis)) continue;
            if (fareBasisesString.length() > 0) {
                fareBasisesString.append(" / ");
            }
            fareBasisesString.append(fareBasis);
        }
        return fareBasisesString.toString();
    }

    public static String getMCOSystemNumbersString(List<String> systemNumbers) {
        ArrayList<String> mcoSystemNumbers = new ArrayList<String>(systemNumbers);
        Collections.sort(mcoSystemNumbers, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return TextUtil.compare((String)o1, (String)o2, (boolean)false, (boolean)false);
            }
        });
        StringBuilder mcoSystemNumbersString = new StringBuilder();
        for (String mcoSystemNumber : mcoSystemNumbers) {
            if (TextUtil.isBlank((String)mcoSystemNumber)) continue;
            if (mcoSystemNumbersString.length() > 0) {
                mcoSystemNumbersString.append(" / ");
            }
            mcoSystemNumbersString.append(mcoSystemNumber);
        }
        return mcoSystemNumbersString.toString();
    }
}

