/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.xf;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFTicket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class XFSalesReportBatchData
extends ReportBatchData<XFTicket> {
    private static final long serialVersionUID = -3401007875988481173L;
    private final List<XFTicket> tickets = new ArrayList<XFTicket>();
    private String subagencyCode;
    private String agencyCode;
    private static final Set<String> acceptedBatchNames = new HashSet<String>(Arrays.asList("CANCEL", "REFUND", "EXC", "SALE"));

    public String getSubagencyCode() {
        return this.subagencyCode;
    }

    public void setSubagencyCode(String subagencyCode) {
        this.subagencyCode = subagencyCode;
    }

    public Integer getSortOrder() {
        if ("CANCEL".equals(this.getBatchId())) {
            return 1;
        }
        if ("REFUND".equals(this.getBatchId())) {
            return 2;
        }
        if ("EXC".equals(this.getBatchId())) {
            return 3;
        }
        if ("SALE".equals(this.getBatchId())) {
            return 4;
        }
        return 0;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public void setAgencyCode(String value) {
        this.agencyCode = value;
    }

    @Override
    public List<XFTicket> getTickets() {
        return this.tickets;
    }

    public void sortTickets() {
        Collections.sort(this.tickets, new Comparator<XFTicket>(){

            @Override
            public int compare(XFTicket o1, XFTicket o2) {
                String batchId = XFSalesReportBatchData.this.getBatchId();
                if (batchId == null) {
                    return 0;
                }
                if (batchId.indexOf("EXC") >= 0) {
                    return this.compareExchBatchTickets(o1, o2);
                }
                return this.compareByTariffType(o1, o2);
            }

            private int compareExchBatchTickets(XFTicket o1, XFTicket o2) {
                String number2;
                int value = this.compareByTariffType(o1, o2);
                if (value != 0) {
                    return value;
                }
                String number1 = XFSalesReportBatchData.this.getSortTicketNumber(o1);
                value = number1.compareTo(number2 = XFSalesReportBatchData.this.getSortTicketNumber(o2));
                if (value == 0 && (o1.getProductCategory() == o2.getProductCategory() ? o1.getStatus() != ProductStatus.SELL : o1.getProductCategory() == ProductCategory.MCO)) {
                    return 1;
                }
                return value;
            }

            private int compareByTariffType(XFTicket t1, XFTicket s2) {
                return this.getTariffTypeIndex(t1) - this.getTariffTypeIndex(s2);
            }

            private int getTariffTypeIndex(XFTicket t1) {
                if (t1.getTariffType() == TariffType.REGULAR) {
                    return 0;
                }
                if (t1.getTariffType() == TariffType.BLOCKCHARTER) {
                    return 1;
                }
                if (t1.getTariffType() == TariffType.CHARTER) {
                    return 2;
                }
                return 3;
            }
        });
    }

    public int enumerateTickets(int batch, String batchName) {
        if (!acceptedBatchNames.contains(batchName)) {
            return batch;
        }
        int resultBatchNo = batch;
        for (int i = 0; i < this.getTickets().size(); ++i) {
            XFTicket ticket = this.getTickets().get(i);
            resultBatchNo = batch + i / 50;
            int ticketNo = i % 50 + 1;
            ticket.setBatchNo(resultBatchNo);
            ticket.setBatchType(this.getBatchId());
            ticket.setTransactionNo(ticketNo);
        }
        return resultBatchNo;
    }

    private String getSortTicketNumber(XFTicket ticket) {
        return ticket.getTicketNumber();
    }
}

