/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.xf;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFSettlementLetter;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFSettlementLetterData;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFSettlementLetterItem;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFTicket;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public abstract class XFSettlementLetterListWorksheetHandler
implements PoiWorksheetHandler<XFTicket> {
    private static final int ITEM_COLUMN_OFFSET = 3;

    public abstract String getLetterID();

    @Override
    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<XFTicket> data, Map<String, Object> globalData) throws Exception {
        BaseReportParameters parameters = (BaseReportParameters)globalData.get("key-report-params");
        Date startDate = parameters.getPeriodBegin();
        Date endDate = parameters.getPeriodEnd();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy", new Locale("ru", "RU"));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_START", (String)dateFormat.format(startDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_END", (String)dateFormat.format(endDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)((String)globalData.get("AGENCY_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)((String)globalData.get("AGENCY_DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)((String)globalData.get("AGENCY_ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_CHIEF_MUTUAL", (String)((String)globalData.get("AGENCY_CHIEF_MUTUAL")));
        TreeMap letters = (TreeMap)globalData.get("key-registry-letters-data");
        if (letters == null) {
            return;
        }
        String letterID = this.getLetterID();
        if (letterID == null) {
            return;
        }
        XFSettlementLetter letter = (XFSettlementLetter)letters.get(letterID);
        if (letter == null) {
            return;
        }
        TreeMap<String, XFSettlementLetterItem> letterItems = new TreeMap<String, XFSettlementLetterItem>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return "SETTLEMENT_LETTER_ITEM_SUMMARY".equals(o1) ? -1 : o1.compareTo(o2);
            }
        });
        for (Map.Entry<String, XFSettlementLetterItem> letterItemEntry : letter.getSettlementLetterItems().entrySet()) {
            letterItems.put(letterItemEntry.getKey(), letterItemEntry.getValue());
        }
        int columnIndex = 3;
        int itemCounter = 0;
        for (Map.Entry letterItemEntry : letterItems.entrySet()) {
            String letterItemID = (String)letterItemEntry.getKey();
            XFSettlementLetterItem letterItem = (XFSettlementLetterItem)letterItemEntry.getValue();
            if (itemCounter > 0 && itemCounter < letterItems.entrySet().size() - 1) {
                ExcelUtils.copyColumns((HSSFSheet)sheet, (int)(columnIndex - 1), (int)(columnIndex - 1 + 1), (int)0, (int)48);
            }
            if (itemCounter > 0) {
                ExcelUtils.replace((HSSFSheet)sheet, (String)"BLANK_SERIES", (String)letterItemID, (int)5, (int)5, (int)(columnIndex - 1), (int)(columnIndex - 1));
            }
            Map<String, XFSettlementLetterData> letterDatas = letterItem.getSettlementLetterDatas();
            String columnName = ExcelUtils.indexToLetter((int)columnIndex);
            String startColumnName = ExcelUtils.indexToLetter((int)(columnIndex + 1));
            String endColumnName = ExcelUtils.indexToLetter((int)(columnIndex + 1 + letterDatas.size() - 1));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)9, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s10+%s13+%s14", columnName, columnName, columnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)10, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s10:%s10)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)13, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s13:%s13)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)14, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s14:%s14)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)15, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s16+%s17+%s18", columnName, columnName, columnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)16, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s16:%s16)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)17, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s17:%s17)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)18, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s18:%s18)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)19, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s20+%s21+%s22", columnName, columnName, columnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)20, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s20:%s20)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)21, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s21:%s21)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)22, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s22:%s22)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)23, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s24+%s27-%s28+%s29", columnName, columnName, columnName, columnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)24, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s24:%s24)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)27, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s27:%s27)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)28, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s28:%s28)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)29, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s29:%s29)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)30, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s31+%s32", columnName, columnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)31, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s31:%s31)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)32, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s32:%s32)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)33, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s34+%s35", columnName, columnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)34, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s34:%s34)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)35, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s35:%s35)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)36, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s9+%s15+%s19-%s23+%s30+%s33", columnName, columnName, columnName, columnName, columnName, columnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)37, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s38+%s39+%s40-%s41+%s42+%s43", columnName, columnName, columnName, columnName, columnName, columnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)38, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s38:%s38)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)39, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s39:%s39)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)40, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s40:%s40)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)41, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s41:%s41)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)42, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s42:%s42)", startColumnName, endColumnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)43, (int)columnIndex, (int)1, (int)1, (String)String.format("=SUM(%s43:%s43)", startColumnName, endColumnName));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)44, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)45, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)46, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)47, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)48, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s36-%s37+%s44+%s45+%s46", columnName, columnName, columnName, columnName, columnName));
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)49, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s14-%s29", columnName, columnName));
            ++columnIndex;
            int dataCounter = 0;
            for (Map.Entry<String, XFSettlementLetterData> letterDataEntry : letterDatas.entrySet()) {
                String letterDataID = letterDataEntry.getKey();
                XFSettlementLetterData letterData = letterDataEntry.getValue();
                if (dataCounter < letterDatas.entrySet().size() - 1) {
                    ExcelUtils.copyColumns((HSSFSheet)sheet, (int)(columnIndex - 1), (int)(columnIndex - 1), (int)0, (int)48);
                    ExcelUtils.mergeCells((HSSFSheet)sheet, (int)7, (int)7, (int)columnIndex, (int)(columnIndex + 1));
                }
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)8, (int)columnIndex, (int)1, (int)1, (String)letterDataID);
                columnName = ExcelUtils.indexToLetter((int)columnIndex);
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)9, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s10+%s13+%s14", columnName, columnName, columnName));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)10, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalSellEquivalentFare()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)13, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalSellOtherTaxesAmount()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)14, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalSellYRTaxesAmount()));
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)15, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s16+%s17+%s18", columnName, columnName, columnName));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)16, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalMCOEquivalentFare()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)17, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)18, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalMCOPenaltyAmount()));
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)19, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s20+%s217+%s22", columnName, columnName, columnName));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)20, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalExchangeEquivalentExcessFare()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)21, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)22, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)23, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s24+%s27-%s28+%s29", columnName, columnName, columnName, columnName));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)24, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalRefundEquivalentFare()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)27, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalRefundOtherTaxesAmount()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)28, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalRefundPenaltyAmount()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)29, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalRefundYRTaxesAmount()));
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)30, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s31+%s32", columnName, columnName));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)31, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)32, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)33, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s34+%s35", columnName, columnName));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)34, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)35, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)36, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s9+%s15+%s19-%s23+%s30+%s33", columnName, columnName, columnName, columnName, columnName, columnName));
                ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)37, (int)columnIndex, (int)1, (int)1, (String)String.format("=%s38+%s39+%s40-%s41+%s42+%s43", columnName, columnName, columnName, columnName, columnName, columnName));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)38, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalSellEquivalentVendorCommissionAmount()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)39, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalMCOEquivalentVendorCommissionAmount()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)40, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalExchangeEquivalentExcessVendorCommissionAmount()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)41, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(letterData.getTotalRefundEquivalentVendorCommissionAmount()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)42, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)43, (int)columnIndex, (int)1, (int)1, (BigDecimal)ReportHelper.getNonNullValue(BigDecimal.ZERO));
                if (dataCounter < letterDatas.entrySet().size() - 1) {
                    ++columnIndex;
                }
                ++dataCounter;
            }
            ++columnIndex;
            ++itemCounter;
        }
    }
}

