/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.salesreports.xf;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class XFTicket
extends BaseSalesReportTicket {
    private static final long serialVersionUID = -4106680527034856037L;
    private String batchId;
    private String batchType;
    private int batchNo;
    private int transactionNo;
    private String subagencyCode;
    private String ticketRouting;
    private final List<String> fareBasises = new ArrayList<String>();
    private Date firstFlightDepartureDate;
    private Date firstFlightArriveDate;
    private BigDecimal otherTaxesAmount;
    private BigDecimal yrTaxesAmount;
    private String previousProductSystemNumber;
    private Date previousProductIssueDate;
    private String previousProductRouting;
    private final List<String> previousProductFareBasises = new ArrayList<String>();
    private final List<String> previousProductFlightNumbers = new ArrayList<String>();
    private Date previousProductFirstFlightDepartureDate;
    private BigDecimal previousProductEquivalentFare;
    private BigDecimal previousProductPenaltyAmount;
    private Double previousProductVendorCommissionRate;
    private BigDecimal previousProductEquivalentVendorCommissionAmount;
    private BigDecimal previousProductOtherTaxesAmount;
    private BigDecimal previousProductYRTaxesAmount;
    private String nextProductSystemNumber;
    private Date nextProductIssueDate;
    private String nextProductRouting;
    private final List<String> nextProductFareBasises = new ArrayList<String>();
    private final List<String> nextProductFlightNumbers = new ArrayList<String>();
    private Date nextProductFirstFlightDepartureDate;
    private BigDecimal nextProductEquivalentFare;
    private BigDecimal nextProductPenaltyAmount;
    private Double nextProductVendorCommissionRate;
    private BigDecimal nextProductEquivalentVendorCommissionAmount;
    private BigDecimal nextProductOtherTaxesAmount;
    private BigDecimal nextProductYRTaxesAmount;
    private Date relatedRefundProductIssueDate;
    private Double relatedProductVendorCommissionRate;
    private BigDecimal relatedProductEquivalentVendorCommissionAmount;
    private Date relatedSellProductIssueDate;
    private final List<String> mcoSystemNumbers = new ArrayList<String>();
    private BigDecimal mcoEquivalentFares;
    private BigDecimal exchangeProductEquivalentExcessFare;
    private Double exchangeProductVendorCommissionRate;
    private BigDecimal exchangeProductEquivalentExcessVendorCommissionAmount;

    public XFTicket(Product product, List<Message> messages) throws Exception {
        super(product, messages);
        this.setBatchId(product);
        this.initializeProductData(product, messages);
        this.initializePreviousProductData(product.getPreviousProduct(), messages);
        this.initializeNextProductData(product.getNextProduct(), messages);
        Iterator iterator = product.getRelatedProducts().iterator();
        this.initializeRelatedProductData(iterator.hasNext() ? (Product)iterator.next() : null, messages);
        this.initializeMCOData(product, messages);
        if (this.previousProductEquivalentFare != null && this.nextProductEquivalentFare != null) {
            this.exchangeProductEquivalentExcessFare = this.nextProductEquivalentFare.subtract(this.previousProductEquivalentFare);
        }
        this.exchangeProductVendorCommissionRate = this.previousProductVendorCommissionRate == null ? this.nextProductVendorCommissionRate : (this.nextProductVendorCommissionRate == null ? this.previousProductVendorCommissionRate : Double.valueOf(Math.max(this.previousProductVendorCommissionRate, this.nextProductVendorCommissionRate)));
        if (this.previousProductEquivalentVendorCommissionAmount != null && this.nextProductEquivalentVendorCommissionAmount != null) {
            this.exchangeProductEquivalentExcessVendorCommissionAmount = this.nextProductEquivalentVendorCommissionAmount.subtract(this.previousProductEquivalentVendorCommissionAmount);
        }
    }

    private void setBatchId(Product product) {
        TransportationType transportationType = this.getTransportationType();
        if (transportationType == null || transportationType == TransportationType.NONE) {
            transportationType = TransportationType.DOMESTIC;
        }
        if (product.getStatus() == ProductStatus.SELL) {
            if (transportationType == TransportationType.DOMESTIC) {
                this.batchId = "SELL_VVL";
            } else if (transportationType == TransportationType.INTERNATIONAL) {
                this.batchId = "SELL_MVL";
            }
            if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                if (transportationType == TransportationType.DOMESTIC) {
                    this.batchId = "EXCHANGE_VVL";
                } else if (transportationType == TransportationType.INTERNATIONAL) {
                    this.batchId = "EXCHANGE_MVL";
                }
            }
            if (!(product.getProductCategory() != ProductCategory.MCO || product.getMcoCategory() != MCOCategory.PENALTY && product.getMcoCategory() != MCOCategory.REBOOKING && product.getMcoCategory() != MCOCategory.ADDITIONAL_TARIFF && product.getMcoCategory() != MCOCategory.INFORMATION || product.getRelatedProducts() == null || product.getRelatedProducts().isEmpty())) {
                Product relatedProduct = (Product)product.getRelatedProducts().iterator().next();
                if (relatedProduct.getStatus() == ProductStatus.EXCHANGE) {
                    if (transportationType == TransportationType.DOMESTIC) {
                        this.batchId = "EXCHANGE_VVL";
                    } else if (transportationType == TransportationType.INTERNATIONAL) {
                        this.batchId = "EXCHANGE_MVL";
                    }
                } else if (relatedProduct.getStatus() == ProductStatus.REFUND) {
                    if (transportationType == TransportationType.DOMESTIC) {
                        this.batchId = "REFUND_VVL";
                    } else if (transportationType == TransportationType.INTERNATIONAL) {
                        this.batchId = "REFUND_MVL";
                    }
                }
            }
        } else if (product.getStatus() == ProductStatus.REFUND) {
            if (transportationType == TransportationType.DOMESTIC) {
                this.batchId = "REFUND_VVL";
            } else if (transportationType == TransportationType.INTERNATIONAL) {
                this.batchId = "REFUND_MVL";
            }
        } else if (product.getStatus() == ProductStatus.EXCHANGE) {
            if (transportationType == TransportationType.DOMESTIC) {
                this.batchId = "EXCHANGE_VVL";
            } else if (transportationType == TransportationType.INTERNATIONAL) {
                this.batchId = "EXCHANGE_MVL";
            }
        } else if (product.getStatus() == ProductStatus.VOID) {
            if (transportationType == TransportationType.DOMESTIC) {
                this.batchId = "VOID_VVL";
            } else if (transportationType == TransportationType.INTERNATIONAL) {
                this.batchId = "VOID_MVL";
            }
        }
    }

    private void initializeProductData(Product product, List<Message> messages) throws Exception {
        String string = this.subagencyCode = AirProductHelper.getSubagency((Product)product) != null ? AirProductHelper.getSubagency((Product)product).getCaption() : null;
        if (!TextUtil.isBlank((String)product.getCarrierNumber())) {
            this.ticketSeries = product.getCarrierNumber();
        }
        this.ticketRouting = AirProductHelper.getRouteLine((Product)product);
        Segment firstSegment = null;
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (segment == null) continue;
                if (firstSegment == null) {
                    firstSegment = segment;
                }
                if (segment.getFareBasis() == null) continue;
                this.fareBasises.add(segment.getFareBasis());
            }
        }
        if (firstSegment != null) {
            this.firstFlightDepartureDate = firstSegment.getStartDate();
            this.firstFlightArriveDate = firstSegment.getEndDate();
        }
        for (Tax tax : product.getTaxes()) {
            BigDecimal equivalentAmount = tax.getEquivalentAmount();
            if (equivalentAmount == null) continue;
            if ("YR".equals(tax.getCode())) {
                this.yrTaxesAmount = this.yrTaxesAmount != null ? this.yrTaxesAmount.add(equivalentAmount) : equivalentAmount;
                continue;
            }
            this.otherTaxesAmount = this.otherTaxesAmount != null ? this.otherTaxesAmount.add(equivalentAmount) : equivalentAmount;
        }
    }

    private void initializePreviousProductData(Product product, List<Message> messages) throws Exception {
        if (product == null) {
            return;
        }
        this.previousProductSystemNumber = product.getSystemNumber();
        this.previousProductIssueDate = product.getIssueDate();
        this.previousProductRouting = AirProductHelper.getRouteLine((Product)product);
        Segment firstSegment = null;
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (segment == null) continue;
                if (firstSegment == null) {
                    firstSegment = segment;
                }
                if (segment.getFareBasis() != null) {
                    this.previousProductFareBasises.add(segment.getFareBasis());
                }
                if (segment.getFlightNo() == null) continue;
                this.previousProductFlightNumbers.add(segment.getFlightNo());
            }
        }
        if (firstSegment != null) {
            this.previousProductFirstFlightDepartureDate = firstSegment.getStartDate();
        }
        this.previousProductEquivalentFare = this.status != ProductStatus.VOID ? AirProductHelper.getEquivalentFare((Product)product) : BigDecimal.ZERO;
        this.previousProductPenaltyAmount = this.status != ProductStatus.VOID ? product.getPenalty() : BigDecimal.ZERO;
        for (Commission commission : AirProductHelper.getUnmodifiableCommissions((Product)product, null)) {
            Double commisionRate;
            boolean discount;
            EntityReference commissionPropertiesReference;
            if (commission.getContractType() == null) continue;
            if (commission.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
                commissionPropertiesReference = commission.getCommissionProperties();
                EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(commissionPropertiesReference);
                if (commissionPropertiesContainer != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission() || commissionPropertiesContainer != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus()) continue;
            }
            boolean fee = (commissionPropertiesReference = commission.getCommissionProperties()) != null && (FeeProperties.class.equals((Object)commissionPropertiesReference.getType()) || PaymentFeeProperties.class.equals((Object)commissionPropertiesReference.getType()));
            boolean bl = discount = commissionPropertiesReference != null && DiscountProperties.class.getName().equals(commissionPropertiesReference.getType().getName());
            if (fee || discount || commission.getContractType() != ContractType.VENDOR) continue;
            BigDecimal equivalentCommissionAmount = commission.getEquivalentAmount();
            if (equivalentCommissionAmount != null) {
                BigDecimal bigDecimal = this.previousProductEquivalentVendorCommissionAmount = this.previousProductEquivalentVendorCommissionAmount != null ? this.previousProductEquivalentVendorCommissionAmount.add(equivalentCommissionAmount) : equivalentCommissionAmount;
            }
            if ((commisionRate = commission.getRate()) == null || Math.abs(commisionRate) < 0.001) continue;
            if (this.previousProductVendorCommissionRate == null) {
                this.previousProductVendorCommissionRate = commisionRate;
                continue;
            }
            this.previousProductVendorCommissionRate = Math.abs(this.previousProductVendorCommissionRate) > Math.abs(commisionRate) ? this.previousProductVendorCommissionRate : commisionRate;
        }
        for (Tax tax : product.getTaxes()) {
            BigDecimal equivalentAmount = tax.getEquivalentAmount();
            if (equivalentAmount == null) continue;
            if ("YR".equals(tax.getCode())) {
                this.previousProductYRTaxesAmount = this.previousProductYRTaxesAmount != null ? this.previousProductYRTaxesAmount.add(equivalentAmount) : equivalentAmount;
                continue;
            }
            this.previousProductOtherTaxesAmount = this.previousProductOtherTaxesAmount != null ? this.previousProductOtherTaxesAmount.add(equivalentAmount) : equivalentAmount;
        }
    }

    private void initializeNextProductData(Product product, List<Message> messages) throws Exception {
        if (product == null) {
            return;
        }
        this.nextProductSystemNumber = product.getSystemNumber();
        this.nextProductIssueDate = product.getIssueDate();
        this.nextProductRouting = AirProductHelper.getRouteLine((Product)product);
        Segment firstSegment = null;
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (segment == null) continue;
                if (firstSegment == null) {
                    firstSegment = segment;
                }
                if (segment.getFareBasis() != null) {
                    this.nextProductFareBasises.add(segment.getFareBasis());
                }
                if (segment.getFlightNo() == null) continue;
                this.nextProductFlightNumbers.add(segment.getFlightNo());
            }
        }
        if (firstSegment != null) {
            this.nextProductFirstFlightDepartureDate = firstSegment.getStartDate();
        }
        this.nextProductEquivalentFare = this.status != ProductStatus.VOID ? AirProductHelper.getEquivalentFare((Product)product) : BigDecimal.ZERO;
        this.nextProductPenaltyAmount = this.status != ProductStatus.VOID ? product.getPenalty() : BigDecimal.ZERO;
        for (Commission commission : AirProductHelper.getUnmodifiableCommissions((Product)product, null)) {
            Double commisionRate;
            boolean discount;
            EntityReference commissionPropertiesReference;
            if (commission.getContractType() == null) continue;
            if (commission.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
                commissionPropertiesReference = commission.getCommissionProperties();
                EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(commissionPropertiesReference);
                if (commissionPropertiesContainer != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission() || commissionPropertiesContainer != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus()) continue;
            }
            boolean fee = (commissionPropertiesReference = commission.getCommissionProperties()) != null && (FeeProperties.class.equals((Object)commissionPropertiesReference.getType()) || PaymentFeeProperties.class.equals((Object)commissionPropertiesReference.getType()));
            boolean bl = discount = commissionPropertiesReference != null && DiscountProperties.class.getName().equals(commissionPropertiesReference.getType().getName());
            if (fee || discount || commission.getContractType() != ContractType.VENDOR) continue;
            BigDecimal equivalentCommissionAmount = commission.getEquivalentAmount();
            if (equivalentCommissionAmount != null) {
                BigDecimal bigDecimal = this.nextProductEquivalentVendorCommissionAmount = this.nextProductEquivalentVendorCommissionAmount != null ? this.nextProductEquivalentVendorCommissionAmount.add(equivalentCommissionAmount) : equivalentCommissionAmount;
            }
            if ((commisionRate = commission.getRate()) == null || Math.abs(commisionRate) < 0.001) continue;
            if (this.nextProductVendorCommissionRate == null) {
                this.nextProductVendorCommissionRate = commisionRate;
                continue;
            }
            this.nextProductVendorCommissionRate = Math.abs(this.nextProductVendorCommissionRate) > Math.abs(commisionRate) ? this.nextProductVendorCommissionRate : commisionRate;
        }
        for (Tax tax : product.getTaxes()) {
            BigDecimal equivalentAmount = tax.getEquivalentAmount();
            if (equivalentAmount == null) continue;
            if ("YR".equals(tax.getCode())) {
                this.nextProductYRTaxesAmount = this.nextProductYRTaxesAmount != null ? this.nextProductYRTaxesAmount.add(equivalentAmount) : equivalentAmount;
                continue;
            }
            this.nextProductOtherTaxesAmount = this.nextProductOtherTaxesAmount != null ? this.nextProductOtherTaxesAmount.add(equivalentAmount) : equivalentAmount;
        }
    }

    private void initializeRelatedProductData(Product product, List<Message> messages) throws Exception {
        if (product == null) {
            return;
        }
        if (product.getStatus() == ProductStatus.REFUND) {
            this.relatedRefundProductIssueDate = product.getIssueDate();
            Product sellProduct = product.getPreviousProduct();
            if (sellProduct != null && sellProduct.getStatus() == ProductStatus.SELL) {
                this.relatedSellProductIssueDate = sellProduct.getIssueDate();
            }
        }
        for (Commission commission : AirProductHelper.getUnmodifiableCommissions((Product)product, null)) {
            Double commisionRate;
            boolean discount;
            EntityReference commissionPropertiesReference;
            if (commission.getContractType() == null) continue;
            if (commission.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
                commissionPropertiesReference = commission.getCommissionProperties();
                EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(commissionPropertiesReference);
                if (commissionPropertiesContainer != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission() || commissionPropertiesContainer != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus()) continue;
            }
            boolean fee = (commissionPropertiesReference = commission.getCommissionProperties()) != null && (FeeProperties.class.equals((Object)commissionPropertiesReference.getType()) || PaymentFeeProperties.class.equals((Object)commissionPropertiesReference.getType()));
            boolean bl = discount = commissionPropertiesReference != null && DiscountProperties.class.getName().equals(commissionPropertiesReference.getType().getName());
            if (fee || discount || commission.getContractType() != ContractType.VENDOR) continue;
            BigDecimal equivalentCommissionAmount = commission.getEquivalentAmount();
            if (equivalentCommissionAmount != null) {
                BigDecimal bigDecimal = this.relatedProductEquivalentVendorCommissionAmount = this.relatedProductEquivalentVendorCommissionAmount != null ? this.relatedProductEquivalentVendorCommissionAmount.add(equivalentCommissionAmount) : equivalentCommissionAmount;
            }
            if ((commisionRate = commission.getRate()) == null || Math.abs(commisionRate) < 0.001) continue;
            if (this.relatedProductVendorCommissionRate == null) {
                this.relatedProductVendorCommissionRate = commisionRate;
                continue;
            }
            this.relatedProductVendorCommissionRate = Math.abs(this.relatedProductVendorCommissionRate) > Math.abs(commisionRate) ? this.relatedProductVendorCommissionRate : commisionRate;
        }
    }

    private void initializeMCOData(Product product, List<Message> messages) throws Exception {
        if (product == null) {
            return;
        }
        Collection mcos = AirProductHelper.getMcoByRelatedProduct((Product)product);
        for (Product mco : mcos) {
            if (mco.getSystemNumber() != null) {
                this.mcoSystemNumbers.add(mco.getSystemNumber());
            }
            BigDecimal equivalentFare = mco.getStatus() != ProductStatus.VOID ? AirProductHelper.getEquivalentFare((Product)mco) : BigDecimal.ZERO;
            this.mcoEquivalentFares = this.mcoEquivalentFares != null ? this.mcoEquivalentFares.add(equivalentFare) : equivalentFare;
        }
    }

    public void setBatchId(String value) {
        this.batchId = value;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchType(String value) {
        this.batchType = value;
    }

    public String getBatchType() {
        return this.batchType;
    }

    public void setBatchNo(int value) {
        this.batchNo = value;
    }

    public int getBatchNo() {
        return this.batchNo;
    }

    public void setTransactionNo(int value) {
        this.transactionNo = value;
    }

    public int getTransactionNo() {
        return this.transactionNo;
    }

    public String getSubagencyCode() {
        return this.subagencyCode;
    }

    public String getTicketRouting() {
        return this.ticketRouting;
    }

    public List<String> getFareBasises() {
        return this.fareBasises;
    }

    public Date getFirstFlightDepartureDate() {
        return this.firstFlightDepartureDate;
    }

    public Date getFirstFlightArriveDate() {
        return this.firstFlightArriveDate;
    }

    public BigDecimal getOtherTaxesAmount() {
        return this.otherTaxesAmount;
    }

    public BigDecimal getYRTaxesAmount() {
        return this.yrTaxesAmount;
    }

    public String getPreviousProductSystemNumber() {
        return this.previousProductSystemNumber;
    }

    public Date getPreviousProductIssueDate() {
        return this.previousProductIssueDate;
    }

    public String getPreviousProductRouting() {
        return this.previousProductRouting;
    }

    public List<String> getPreviousProductFareBasises() {
        return this.previousProductFareBasises;
    }

    public List<String> getPreviousProductFlightNumbers() {
        return this.previousProductFlightNumbers;
    }

    public Date getPreviousProductFirstFlightDepartureDate() {
        return this.previousProductFirstFlightDepartureDate;
    }

    public BigDecimal getPreviousProductEquivalentFare() {
        return this.previousProductEquivalentFare;
    }

    public BigDecimal getPreviousProductPenaltyAmount() {
        return this.previousProductPenaltyAmount;
    }

    public Double getPreviousProductVendorCommissionRate() {
        return this.previousProductVendorCommissionRate;
    }

    public BigDecimal getPreviousProductEquivalentVendorCommissionAmount() {
        return this.previousProductEquivalentVendorCommissionAmount;
    }

    public BigDecimal getPreviousProductOtherTaxesAmount() {
        return this.previousProductOtherTaxesAmount;
    }

    public BigDecimal getPreviousProductYRTaxesAmount() {
        return this.previousProductYRTaxesAmount;
    }

    public String getNextProductSystemNumber() {
        return this.nextProductSystemNumber;
    }

    public Date getNextProductIssueDate() {
        return this.nextProductIssueDate;
    }

    public String getNextProductRouting() {
        return this.nextProductRouting;
    }

    public List<String> getNextProductFareBasises() {
        return this.nextProductFareBasises;
    }

    public List<String> getNextProductFlightNumbers() {
        return this.nextProductFlightNumbers;
    }

    public Date getNextProductFirstFlightDepartureDate() {
        return this.nextProductFirstFlightDepartureDate;
    }

    public BigDecimal getNextProductEquivalentFare() {
        return this.nextProductEquivalentFare;
    }

    public BigDecimal getNextProductPenaltyAmount() {
        return this.nextProductPenaltyAmount;
    }

    public Double getNextProductVendorCommissionRate() {
        return this.nextProductVendorCommissionRate;
    }

    public BigDecimal getNextProductEquivalentVendorCommissionAmount() {
        return this.nextProductEquivalentVendorCommissionAmount;
    }

    public BigDecimal getNextProductOtherTaxesAmount() {
        return this.nextProductOtherTaxesAmount;
    }

    public BigDecimal getNextProductYRTaxesAmount() {
        return this.nextProductYRTaxesAmount;
    }

    public Date getRelatedRefundProductIssueDate() {
        return this.relatedRefundProductIssueDate;
    }

    public Double getRelatedProductVendorCommissionRate() {
        return this.relatedProductVendorCommissionRate;
    }

    public BigDecimal getRelatedProductEquivalentVendorCommissionAmount() {
        return this.relatedProductEquivalentVendorCommissionAmount;
    }

    @Override
    public Date getRelatedSellProductIssueDate() {
        return this.relatedSellProductIssueDate;
    }

    public List<String> getMCOSystemNumbers() {
        return this.mcoSystemNumbers;
    }

    public BigDecimal getMCOEquivalentFares() {
        return this.mcoEquivalentFares;
    }

    public BigDecimal getExchangeProductEquivalentExcessFare() {
        return this.exchangeProductEquivalentExcessFare;
    }

    public Double getExchangeProductVendorCommissionRate() {
        return this.exchangeProductVendorCommissionRate;
    }

    public BigDecimal getExchangeProductEquivalentExcessVendorCommissionAmount() {
        return this.exchangeProductEquivalentExcessVendorCommissionAmount;
    }
}

