/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol.na;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BaseStockcontrolOverviewReportRender;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BlankBatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class NaStockControlReportOverviewRenderHandler
extends BaseStockcontrolOverviewReportRender {
    private static String summarySheetName = L10nResourcesManager.createL10nMessage((String)Messages.NaStockControlReportOverviewRenderHandler_summarySheetName, (Object[])new Object[0]).toString();

    @Override
    public String getId() {
        return "na-stock-control-report";
    }

    @Override
    protected Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> createDataMap(Map<String, Object> data) {
        HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> dataLists = new HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList>();
        dataLists.put(ListDefinitions.BLANK_START.name(), new BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.BLANK_START;
            }
        });
        dataLists.put(ListDefinitions.BLANK_IN.name(), new BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.BLANK_IN;
            }
        });
        dataLists.put(ListDefinitions.BLANK_OUT.name(), new BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.BLANK_OUT;
            }
        });
        dataLists.put(ListDefinitions.BLANK_END.name(), new BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.BLANK_END;
            }
        });
        return dataLists;
    }

    @Override
    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) throws Exception {
        Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData = this.createDataMap(data);
        this.initializeDataMap(workbookData, data);
        List messages = (List)data.get("key-messages");
        this.renderSummaryReport(data, messages, workbookData, wb);
    }

    private void renderSummaryReport(Map<String, Object> data, List<Message> messages, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData, HSSFWorkbook wb) throws Exception {
        HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)wb, (String)summarySheetName);
        if (sheet == null) {
            SystemHelper.addMessage(messages, (String)Messages.NaStockcontrolReportOverviewRenderHandler_cantFindWorkbookSheet, (String)summarySheetName, null, (Object[])new Object[]{MessageType.ERROR});
            return;
        }
        this.updateReportHeader(sheet, data);
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListStart = workbookData.get(ListDefinitions.BLANK_START.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListIn = workbookData.get(ListDefinitions.BLANK_IN.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListOut = workbookData.get(ListDefinitions.BLANK_OUT.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListEnd = workbookData.get(ListDefinitions.BLANK_END.name());
        HashSet<String> blankTypes = new HashSet<String>();
        blankTypes.addAll(batchListStart.getBlanks().keySet());
        blankTypes.addAll(batchListIn.getBlanks().keySet());
        blankTypes.addAll(batchListOut.getBlanks().keySet());
        blankTypes.addAll(batchListEnd.getBlanks().keySet());
        int blankTypeCount = blankTypes.size();
        for (String blankType : blankTypes) {
            if (batchListStart.getList(blankType).size() <= 1) continue;
            ++blankTypeCount;
        }
        int startRowListStart = ListDefinitions.BLANK_START.getStartPosition(null)[0];
        int startRowListIn = ListDefinitions.BLANK_IN.getStartPosition(null)[0];
        int startRowListOut = ListDefinitions.BLANK_OUT.getStartPosition(null)[0];
        int startRowListEnd = ListDefinitions.BLANK_END.getStartPosition(null)[0];
        for (int i = 0; i < blankTypeCount - 1; ++i) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)(startRowListStart - 1), (int)(startRowListEnd - 1));
        }
        int firstRow = startRowListStart;
        for (String blankType : blankTypes) {
            startRowListStart = this.addRows(sheet, firstRow, startRowListStart, blankType, batchListStart.getList(blankType));
            startRowListIn = this.addRows(sheet, firstRow, startRowListIn, blankType, batchListIn.getList(blankType));
            startRowListOut = this.addRows(sheet, firstRow, startRowListOut, blankType, batchListOut.getList(blankType));
            startRowListEnd = this.addRows(sheet, firstRow, startRowListEnd, blankType, batchListEnd.getList(blankType));
            firstRow += 4;
        }
    }

    private int addRows(HSSFSheet sheet, int firstRow, int currentRow, String blankType, List<BlankBatch> batches) throws Exception {
        if (batches.isEmpty()) {
            return currentRow;
        }
        for (BlankBatch batch : batches) {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)firstRow, (int)2, (String)blankType);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)3, (String)batch.getFirstBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)4, (String)batch.getLastBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)currentRow, (int)5, (int)batch.getBlanksCount());
            currentRow += 4;
        }
        return currentRow;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.NaStockControlReportOverviewRenderHandler_reportTitle, (Object[])new Object[]{data.get("AGENCY_NAME"), data.get("KEY_REPORT_FILENAME")}).toString();
    }

    @Override
    protected String getTemplateFileName() {
        return "NordaviaStockOverview.xls";
    }

    @Override
    protected String getReportFileName(Map<String, Object> data) {
        return this.getReportTitle(data) + ".xls";
    }

    private void updateReportHeader(HSSFSheet sheet, Map<String, Object> data) {
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_NO", (String)((String)data.get("CONTRACT_NO")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CONTRACT_ISSUE_DATE", (String)((String)data.get("CONTRACT_ISSUE_DATE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"VENDOR_NAME", (String)((String)data.get("VENDOR_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AIRLINE_IATA_ALPHABETICAL_CODE", (String)((String)data.get("AIRLINE_IATA_ALPHABETICAL_CODE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)((String)data.get("AGENCY_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_IATA_CODE", (String)((String)data.get("AGENCY_IATA_CODE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_CITY", (String)((String)data.get("AGENCY_CITY")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENT_LOCATION", (String)((String)data.get("AGENT_LOCATION")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_PHONE", (String)((String)data.get("AGENCY_PHONE")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"REPORT_PERIOD", (String)((String)data.get("REPORT_PERIOD")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CURRENT_DATE", (String)((String)data.get("CURRENT_DATE")));
    }

    protected static enum ListDefinitions implements BaseStockcontrolOverviewReportRender.StockOverviewDefinition
    {
        BLANK_START{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{21};
            }
        }
        ,
        BLANK_IN{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{22};
            }
        }
        ,
        BLANK_OUT{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{23};
            }
        }
        ,
        BLANK_END{

            @Override
            public int[] getStartPosition(String blankTypeCode) {
                return new int[]{24};
            }
        };

    }
}

