/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol.print;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.stockcontrol.OrderItem;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BasePoiStockcontrolReportRender;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.slf4j.LoggerFactory;

public class PrintOrderRender
extends BasePoiStockcontrolReportRender {
    public static final String KEY_ORDER = "order";

    @Override
    public String getId() {
        return "stock-order-print-form";
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return L10nResourcesManager.createL10nMessage((String)Messages.PrintOrderRender_reportTitle, (Object[])new Object[]{this.getStockOrderSuffix(data)}).toString();
    }

    @Override
    protected String getReportFileName(Map<String, Object> data) {
        return "stock_order" + this.getStockOrderSuffix(data) + ".xls";
    }

    private String getStockOrderSuffix(Map<String, Object> data) {
        EntityContainer orderCtr = (EntityContainer)data.get(KEY_ORDER);
        if (orderCtr == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StockOrder order = (StockOrder)orderCtr.getEntity();
        result.append('_');
        result.append(TextUtil.buildFullNumber((CompositeNumber)order));
        result.append('(').append(order.getCreated() != null ? LocaleManager.get().getCurrentLocaleData().getDateFormat().format(order.getCreated()) : "-").append(')');
        return result.toString();
    }

    @Override
    protected String getTemplateFileName() {
        return "OrderPrintForm.xls";
    }

    @Override
    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) throws Exception {
        int lineNumber;
        if (data.get("key-messages") == null) {
            data.put("key-messages", new ArrayList());
        }
        final List messages = (List)data.get("key-messages");
        EntityContainer orderCtr = (EntityContainer)data.get(KEY_ORDER);
        if (orderCtr == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.PrintOrderRender_noOrder, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        HSSFSheet sheet = wb.getSheetAt(0);
        if (sheet == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.PrintOrderRender_unableOpenPage, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        StockOrder order = (StockOrder)orderCtr.getEntity();
        ExcelUtils.replace((HSSFSheet)sheet, (String)"ORDER_NUMBER", (String)TextUtil.buildFullNumber((CompositeNumber)order));
        Date created = order.getCreated();
        if (created == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.PrintOrderRender_bookingCreationDateNotDefined, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CREATE_DATE", (String)(created != null ? ((LocaleManager)Environment.getPublished(LocaleManager.class)).getCurrentLocaleData().getDateFormat().format(created) : "-"));
        EntityReference senderRef = order.getSender();
        if (senderRef == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.PrintOrderRender_noSender, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        EntityContainer senderCont = EntityStorage.get().resolve(senderRef);
        if (senderCont == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.PrintOrderRender_failedToFindSender, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{senderRef});
            return;
        }
        int shift = 0;
        BaseProfile sender = (BaseProfile)senderCont.getEntity();
        if (Organization.class.getName().equals(sender.getClass().getName())) {
            ExcelUtils.replace((HSSFSheet)sheet, (String)"FROM_LABEL", (String)L10nResourcesManager.createL10nMessage((String)Messages.PrintOrderRender_fromOrganization, (Object[])new Object[0]).toString());
            ExcelUtils.replace((HSSFSheet)sheet, (String)"FROM_PROFILE", (String)ProfileHelper.getFullName((Organization)((Organization)sender), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        } else {
            ++shift;
            Organization agency = null;
            boolean isAgent = false;
            if (SalesPoint.class.getName().equals(sender.getClass().getName())) {
                EntityContainer agCont = EntityStorage.get().resolve(((SalesPoint)sender).getAgency());
                agency = agCont != null ? (Organization)agCont.getEntity() : null;
            } else if (this.isAgent(sender)) {
                List agencys = ((Person)sender).getEmployments();
                for (Object empl : agencys) {
                    EntityContainer ctr;
                    if (empl.getOrganization() == null || !Organization.class.equals((Object)empl.getOrganization().getType()) || (ctr = EntityStorage.get().resolve(empl.getOrganization())) == null) continue;
                    agency = (Organization)ctr.getEntity();
                    break;
                }
                isAgent = true;
            } else {
                SystemHelper.addMessage((Collection)messages, (String)Messages.PrintOrderRender_invalidSenderType, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{senderRef});
                return;
            }
            if (agency == null) {
                SystemHelper.addMessage((Collection)messages, (String)Messages.PrintOrderRender_failedToFindAgencyForProfile, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{senderRef});
                return;
            }
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)4, (int)4);
            ExcelUtils.replace((HSSFSheet)sheet, (String)"FROM_LABEL", (String)L10nResourcesManager.createL10nMessage((String)Messages.PrintOrderRender_fromOrganization, (Object[])new Object[0]).toString(), (int)4, (int)4, (int)0, (int)0);
            ExcelUtils.replace((HSSFSheet)sheet, (String)"FROM_PROFILE", (String)ProfileHelper.getFullName((Organization)agency, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false), (int)4, (int)4, (int)0, (int)0);
            ExcelUtils.replace((HSSFSheet)sheet, (String)"FROM_LABEL", (String)L10nResourcesManager.createL10nMessage((String)Messages.PrintOrderRender_fromCashier, (Object[])new Object[0]).toString(), (int)5, (int)5, (int)0, (int)0);
            ExcelUtils.replace((HSSFSheet)sheet, (String)"FROM_PROFILE", (String)(isAgent ? PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)((Person)sender), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false) : order.getSenderResponsible()), (int)5, (int)5, (int)0, (int)0);
        }
        EntityReference recieverRef = order.getReceiver();
        if (recieverRef == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.PrintOrderRender_noReceiver, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        EntityContainer recieverCont = EntityStorage.get().resolve(recieverRef);
        if (recieverCont == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.PrintOrderRender_failedToFindReceiver, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{recieverRef});
            return;
        }
        BaseProfile reciever = (BaseProfile)recieverCont.getEntity();
        if (Organization.class.getName().equals(reciever.getClass().getName()) && Organization.class.getName().equals(sender.getClass().getName())) {
            lineNumber = 6 + shift;
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)lineNumber, (int)lineNumber);
            ExcelUtils.replace((HSSFSheet)sheet, (String)"TO_LABEL", (String)L10nResourcesManager.createL10nMessage((String)Messages.PrintOrderRender_forOrganization, (Object[])new Object[0]).toString(), (int)lineNumber, (int)lineNumber, (int)0, (int)0);
            ExcelUtils.replace((HSSFSheet)sheet, (String)"TO_PROFILE", (String)ProfileHelper.getFullName((Organization)((Organization)reciever), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false), (int)lineNumber, (int)lineNumber, (int)0, (int)0);
            ExcelUtils.replace((HSSFSheet)sheet, (String)"TO_LABEL", (String)L10nResourcesManager.createL10nMessage((String)Messages.PrintOrderRender_representer, (Object[])new Object[0]).toString(), (int)(++lineNumber), (int)lineNumber, (int)0, (int)0);
            ExcelUtils.replace((HSSFSheet)sheet, (String)"TO_PROFILE", (String)order.getRecieverResponsible(), (int)lineNumber, (int)lineNumber, (int)0, (int)0);
            ++shift;
        } else {
            lineNumber = 6 + shift;
            ExcelUtils.replace((HSSFSheet)sheet, (String)"TO_LABEL", (String)L10nResourcesManager.createL10nMessage((String)Messages.PrintOrderRender_forCashier, (Object[])new Object[0]).toString(), (int)lineNumber, (int)lineNumber, (int)0, (int)0);
            ExcelUtils.replace((HSSFSheet)sheet, (String)"TO_PROFILE", (String)order.getRecieverResponsible(), (int)lineNumber, (int)lineNumber, (int)0, (int)0);
        }
        HashMap<EntityReference, ArrayList<OrderItem>> orderItems = new HashMap<EntityReference, ArrayList<OrderItem>>();
        for (OrderItem item : order.getItems()) {
            if (item.getOwner() == null) {
                SystemHelper.addMessage((Collection)messages, (String)Messages.PrintOrderRender_blankOwnerNotSet, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{recieverRef});
                return;
            }
            ArrayList<OrderItem> items = (ArrayList<OrderItem>)orderItems.get(item.getOwner());
            if (items == null) {
                items = new ArrayList<OrderItem>();
                orderItems.put(item.getOwner(), items);
            }
            items.add(item);
        }
        ArrayList owners = new ArrayList(orderItems.keySet());
        final HashMap<EntityReference<Organization>, String> vendorNames = new HashMap<EntityReference<Organization>, String>();
        Collections.sort(owners, new Comparator<EntityReference<Organization>>(){

            @Override
            public int compare(EntityReference<Organization> o1, EntityReference<Organization> o2) {
                return TextUtil.compare((String)PrintOrderRender.this.getVendorName(o1, vendorNames, messages), (String)PrintOrderRender.this.getVendorName(o2, vendorNames, messages), (boolean)false, (boolean)false);
            }
        });
        int lineNumber2 = 10 + shift;
        for (int n = 1; n < orderItems.keySet().size(); ++n) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)lineNumber2, (int)(lineNumber2 + 1));
        }
        lineNumber2 = 10 + shift;
        int index = 0;
        StringBuilder totalFormula = new StringBuilder("=0");
        for (EntityReference owner : owners) {
            List items = (List)orderItems.get(owner);
            int firstRow = lineNumber2;
            int lastRow = firstRow + items.size() - 1;
            for (int n = 1; n < items.size(); ++n) {
                ExcelUtils.copyRows((HSSFSheet)sheet, (int)lineNumber2, (int)lineNumber2);
            }
            CellRangeAddress range = new CellRangeAddress(firstRow, lastRow, 1, 2);
            sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)range);
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)lastRow, (int)1, (int)3, (int)7, (String)String.format("=SUM(G%s:G%s)", Integer.toString(firstRow + 1), Integer.toString(lastRow + 1)));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(lineNumber2 + 1), (int)1, (int)1, (int)2, (String)this.getVendorName((EntityReference<Organization>)owner, vendorNames, messages));
            for (OrderItem item : items) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(lineNumber2 + 1), (int)1, (int)1, (int)1, (int)(index + 1));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(lineNumber2 + 1), (int)1, (int)1, (int)4, (String)this.getSeries((DictionaryReference<BlankType>)item.getBlankType()));
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(lineNumber2 + 1), (int)1, (int)1, (int)5, (String)item.getFirstBlankNumber());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(lineNumber2 + 1), (int)1, (int)1, (int)6, (String)item.getLastBlankNumber());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(lineNumber2 + 1), (int)1, (int)1, (int)7, (BigDecimal)new BigDecimal(item.getBlanksCount()));
                totalFormula.append("+G").append(lineNumber2 + 1);
                ++lineNumber2;
                ++index;
            }
            ++lineNumber2;
        }
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(lineNumber2 + 1), (int)1, (int)1, (int)7, (String)totalFormula.toString());
    }

    private boolean isAgent(BaseProfile sender) {
        if (!(sender instanceof Person)) {
            return false;
        }
        return ((Person)sender).getTypes().contains(PersonType.AGENT);
    }

    private String getSeries(DictionaryReference<BlankType> blankTypeRef) {
        DictionaryCache dc = DictionaryCache.get();
        BlankType blankType = (BlankType)dc.resolveReference(blankTypeRef);
        if (blankType == null) {
            return null;
        }
        EntityContainer blankOwner = null;
        try {
            blankOwner = EntityStorage.get().resolve(blankType.getBlankOwner());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("unable to resolve reference", (Throwable)e);
        }
        if (blankOwner == null) {
            return null;
        }
        Airline airline = (Airline)dc.resolveReference(((Organization)blankOwner.getEntity()).getAirline());
        if (airline == null) {
            return null;
        }
        return "\u04281".equalsIgnoreCase(airline.getCode()) ? blankType.getName() : airline.getAirlineNumber();
    }

    String getVendorName(EntityReference<Organization> vendorRef, Map<EntityReference<Organization>, String> vendorNames, List<Message> messages) {
        String result = vendorNames.get(vendorRef);
        if (!TextUtil.isBlank((String)result)) {
            return result;
        }
        try {
            String fullName = ProfileHelper.getFullName((Organization)((Organization)EntityStorage.get().resolve(vendorRef).getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            vendorNames.put(vendorRef, fullName);
            return fullName;
        }
        catch (Exception e) {
            SystemHelper.addMessage(messages, (String)Messages.PrintOrderRender_failedToLoadProfile, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return null;
        }
    }
}

