/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol.universal;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BaseStockcontrolOverviewReportRender;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BlankBatch;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class UniversalStockControlReportRenderHandler
extends BaseStockcontrolOverviewReportRender {
    private HSSFWorkbook wb;
    private static final int START_POS = 2;
    private static final int IN_POS = 5;
    private static final int OUT_POS = 8;
    private static final int END_POS = 11;
    private static final int FIRST_SECTION_POS = 12;
    int[] cols = new int[]{2, 5, 8, 11};
    private final Map<String, Integer> totals = new HashMap<String, Integer>();
    private int sumTotalPos = 16;

    @Override
    protected Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> createDataMap(Map<String, Object> data) {
        HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> dataLists = new HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList>();
        dataLists.put(ListDefinitions.START.name(), new BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.START;
            }
        });
        dataLists.put(ListDefinitions.IN.name(), new BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.IN;
            }
        });
        dataLists.put(ListDefinitions.OUT.name(), new BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.OUT;
            }
        });
        dataLists.put(ListDefinitions.END.name(), new BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList(){

            @Override
            public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
                return ListDefinitions.END;
            }
        });
        return dataLists;
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        String title = "";
        if (data.get("AIRLINE_IATA_CODE") != null) {
            title = title + (String)data.get("AIRLINE_IATA_CODE") + "_";
        }
        if (data.get("AGENCY_IATA_CODE") != null) {
            title = title + (String)data.get("AGENCY_IATA_CODE") + "_";
        }
        title = title + "\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435 \u0411\u0421\u041e";
        if (data.get("KEY_REPORT_FILENAME") != null) {
            title = title + (String)data.get("KEY_REPORT_FILENAME");
        }
        title = title + ".xls";
        return title;
    }

    @Override
    protected String getTemplateFileName() {
        return "UniversalStockOverview.xls";
    }

    @Override
    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) throws Exception {
        this.wb = wb;
        Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> batchListData = this.createDataMap(data);
        this.initializeDataMap(batchListData, data);
        List messages = (List)data.get("key-messages");
        HSSFSheet sheet = wb.getSheetAt(0);
        if (sheet == null) {
            SystemHelper.addMessage((Collection)messages, (String)"Unable to find sheet ", null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            return;
        }
        int sections = this.blankTypeCodes.size();
        ArrayList codes = new ArrayList(this.blankTypeCodes);
        Collections.sort(codes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                if (o1.length() == o2.length()) {
                    return o2.compareTo(o1);
                }
                return o2.length() - o1.length();
            }
        });
        this.totals.clear();
        for (String btCode : codes) {
            this.addBatchRows(btCode, sheet, batchListData, --sections > 0);
        }
        sheet.setForceFormulaRecalculation(true);
        this.setupTotalFormulas(sheet);
        try {
            this.updateReportHeader(sheet, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (wb.getNumberOfSheets() > 0) {
            wb.getSheetAt(0).setActive(true);
        }
    }

    private void addBatchRows(String blankType, HSSFSheet sheet, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData, boolean addSection) throws Exception {
        if (blankType == null) {
            return;
        }
        int y = 13;
        if (addSection) {
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)12, (int)15);
            y = 17;
        }
        ExcelUtils.setCellValue((HSSFSheet)sheet, (int)(y + 1), (int)1, (int)1, (int)1, (String)blankType);
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListStart = workbookData.get(ListDefinitions.START.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListIn = workbookData.get(ListDefinitions.IN.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListOut = workbookData.get(ListDefinitions.OUT.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListEnd = workbookData.get(ListDefinitions.END.name());
        List<BlankBatch> bbStart = batchListStart.getList(blankType);
        List<BlankBatch> bbIn = batchListIn.getList(blankType);
        List<BlankBatch> bbOut = batchListOut.getList(blankType);
        List<BlankBatch> bbEnd = batchListEnd.getList(blankType);
        int maxSize = bbStart.size();
        if (bbIn.size() > maxSize) {
            maxSize = bbIn.size();
        }
        if (bbOut.size() > maxSize) {
            maxSize = bbOut.size();
        }
        if (bbEnd.size() > maxSize) {
            maxSize = bbEnd.size();
        }
        if (maxSize == 0) {
            return;
        }
        int sectionTotalRow = y + Math.max(2, maxSize) + 1;
        if (maxSize > 2) {
            for (int i = 2; i <= maxSize - 1; ++i) {
                this.addRow(sheet, y + i);
            }
            ExcelUtils.mergeCells((HSSFSheet)sheet, (int)(y + 1), (int)(y + maxSize + 1), (int)1, (int)1);
        }
        if (addSection || maxSize > 2) {
            this.sumTotalPos = 0;
            for (String total : this.totals.keySet()) {
                Integer t = this.totals.get(total);
                if (t == null) continue;
                if ((t = Integer.valueOf(t + (addSection ? Math.max(2, maxSize) + 2 : maxSize - 2))) > this.sumTotalPos) {
                    this.sumTotalPos = t;
                }
                this.totals.put(total, t);
            }
        }
        this.totals.put(blankType, sectionTotalRow);
        for (int col : this.cols) {
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)sectionTotalRow, (int)1, (int)1, (int)(col + 2), (String)SalesReportHelper.getColumnSumFormula(String.valueOf((char)(65 + col + 1)), y + 1, y + Math.max(2, maxSize)));
        }
        for (int cnt = 0; cnt < maxSize; ++cnt) {
            if (bbStart.size() > cnt) {
                this.addBatchRow(sheet, bbStart.get(cnt), 2, y + cnt + 1);
            }
            if (bbIn.size() > cnt) {
                this.addBatchRow(sheet, bbIn.get(cnt), 5, y + cnt + 1);
            }
            if (bbOut.size() > cnt) {
                this.addBatchRow(sheet, bbOut.get(cnt), 8, y + cnt + 1);
            }
            if (bbEnd.size() <= cnt) continue;
            this.addBatchRow(sheet, bbEnd.get(cnt), 11, y + cnt + 1);
        }
    }

    private void addBatchRow(HSSFSheet sheet, BlankBatch blankBatch, int x, int y) {
        try {
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)1, (int)1, (int)x, (String)blankBatch.getFirstBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)1, (int)1, (int)(x + 1), (String)blankBatch.getLastBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)y, (int)1, (int)1, (int)(x + 2), (int)blankBatch.getBlanksCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getId() {
        return "univarsal-stock-control";
    }

    private void updateReportHeader(HSSFSheet sheet, Map<String, Object> data) throws Exception {
        String[] keys;
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        Date startDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy", new Locale("ru", "RU"));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_START", (String)df.format(startDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_END", (String)df.format(endDate));
        for (String key : keys = new String[]{"AGENCY_NAME", "AGENCY_IATA_CODE", "AGENT_LOCATION", "DIRECTOR", "AGENCY_ACCOUNTANT", "AGENT_NAME", "AIRLINE_NAME", "AIRLINE_IATA_CODE", "AGENCY_EMAIL", "AGENCY_PHONE"}) {
            ExcelUtils.replace((HSSFSheet)sheet, (String)key, (String)((String)data.get(key)));
        }
        ExcelUtils.replace((HSSFSheet)sheet, (String)"CURRENT_DATE", (String)df.format(new Date()));
    }

    private void addRow(HSSFSheet sheet, int rowIndex) throws Exception {
        ExcelUtils.copyRows((HSSFSheet)sheet, (int)(rowIndex - 1), (int)(rowIndex - 1));
        for (int col = 2; col < 14; ++col) {
            HSSFCellStyle style = ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)rowIndex, (int)col);
            HSSFCellStyle clone = this.wb.createCellStyle();
            if (style != null) {
                clone.cloneStyleFrom(style);
            }
            clone.setBorderBottom((short)1);
            ExcelUtils.setCellStyle((HSSFSheet)sheet, (int)rowIndex, (int)col, (HSSFCellStyle)clone);
        }
    }

    @Override
    protected String getReportFileName(Map<String, Object> data) {
        return this.getReportTitle(data);
    }

    private void setupTotalFormulas(HSSFSheet sheet) throws Exception {
        for (int col : this.cols) {
            int rowcnt = 0;
            StringBuilder formula = new StringBuilder("SUM(");
            for (Integer row : this.totals.values()) {
                formula.append(String.format("%1$s%2$d", String.valueOf((char)(65 + col + 1)), row));
                if (rowcnt++ >= this.totals.size() - 1) continue;
                formula.append(",");
            }
            formula.append(")");
            ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)(this.sumTotalPos + 1), (int)1, (int)1, (int)(col + 2), (String)formula.toString());
        }
    }

    protected static enum ListDefinitions implements BaseStockcontrolOverviewReportRender.StockOverviewDefinition
    {
        START,
        IN,
        OUT,
        END;


        @Override
        public int[] getStartPosition(String blankType) {
            return null;
        }
    }
}

