/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.stockcontrol.xf;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BaseStockcontrolOverviewReportRender;
import com.gridnine.xtrip.common.reports.render.stockcontrol.BlankBatch;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class XFStockControlReportRenderHandler
extends BaseStockcontrolOverviewReportRender {
    private static final int BLANKS_ROW_OFFSET = 8;
    int lineNumber;
    int totalRowsCount;

    @Override
    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) throws Exception {
        List messages = (List)data.get("key-messages");
        XFStartStockOverviewBatchList startStockOverviewBatchList = new XFStartStockOverviewBatchList();
        XFInStockOverviewBatchList inStockOverviewBatchList = new XFInStockOverviewBatchList();
        XFOutStockOverviewBatchList outStockOverviewBatchList = new XFOutStockOverviewBatchList();
        XFEndStockOverviewBatchList endStockOverviewBatchList = new XFEndStockOverviewBatchList();
        HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> batchListsMap = new HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList>();
        batchListsMap.put(ListDefinitions.START.name(), startStockOverviewBatchList);
        batchListsMap.put(ListDefinitions.IN.name(), inStockOverviewBatchList);
        batchListsMap.put(ListDefinitions.OUT.name(), outStockOverviewBatchList);
        batchListsMap.put(ListDefinitions.END.name(), endStockOverviewBatchList);
        this.initializeDataMap(batchListsMap, data);
        TreeSet<String> blankCodes = new TreeSet<String>();
        blankCodes.addAll(startStockOverviewBatchList.getBlanks().keySet());
        blankCodes.addAll(inStockOverviewBatchList.getBlanks().keySet());
        blankCodes.addAll(outStockOverviewBatchList.getBlanks().keySet());
        blankCodes.addAll(endStockOverviewBatchList.getBlanks().keySet());
        HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)wb, (String)L10nResourcesManager.createL10nMessage((String)Messages.XFStockControlReportRenderHandler_bso, (Object[])new Object[0]).toString());
        if (sheet == null) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.XFStockControlReport_failedToFindSheet, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            return;
        }
        ReportParameters parameters = (ReportParameters)data.get("key-report-params");
        Date startDate = parameters.getPeriodBegin();
        Date endDate = parameters.getPeriodEnd();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy", new Locale("ru", "RU"));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_NAME", (String)((String)data.get("AGENCY_NAME")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_CITY", (String)((String)data.get("AGENCY_CITY")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_START", (String)dateFormat.format(startDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"DATE_END", (String)dateFormat.format(endDate));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_DIRECTOR", (String)((String)data.get("DIRECTOR")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_ACCOUNTANT", (String)((String)data.get("AGENCY_ACCOUNTANT")));
        ExcelUtils.replace((HSSFSheet)sheet, (String)"AGENCY_CHIEF_MUTUAL", (String)((String)data.get("AGENCY_CHIEF_MUTUAL")));
        this.lineNumber = 8;
        this.totalRowsCount = 0;
        for (String blankCode : blankCodes) {
            this.addBatchRows(wb, sheet, blankCode, batchListsMap);
        }
        ++this.lineNumber;
        Integer startRangeIndex = 9;
        Integer endRangeIndex = 9 + this.totalRowsCount - 1;
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)this.lineNumber, (int)3, (int)1, (int)1, (String)String.format("=SUM(C%s:C%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)this.lineNumber, (int)6, (int)1, (int)1, (String)String.format("=SUM(F%s:F%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)this.lineNumber, (int)9, (int)1, (int)1, (String)String.format("=SUM(I%s:I%s)", startRangeIndex, endRangeIndex));
        ExcelUtils.setCellFormula((HSSFSheet)sheet, (int)this.lineNumber, (int)12, (int)1, (int)1, (String)String.format("=SUM(L%s:L%s)", startRangeIndex, endRangeIndex));
        sheet.setActive(true);
    }

    @Override
    protected String getTemplateFileName() {
        return "VladivistokAviaStockReport.xls";
    }

    @Override
    protected Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> createDataMap(Map<String, Object> data) {
        HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> dataLists = new HashMap<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList>();
        return dataLists;
    }

    private void addBatchRows(HSSFWorkbook wb, HSSFSheet sheet, String blankType, Map<String, BaseStockcontrolOverviewReportRender.StockOverviewBatchList> workbookData) throws Exception {
        if (blankType == null) {
            return;
        }
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListStart = workbookData.get(ListDefinitions.START.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListIn = workbookData.get(ListDefinitions.IN.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListOut = workbookData.get(ListDefinitions.OUT.name());
        BaseStockcontrolOverviewReportRender.StockOverviewBatchList batchListEnd = workbookData.get(ListDefinitions.END.name());
        List<BlankBatch> blankBatchStart = batchListStart.getList(blankType);
        List<BlankBatch> blankBatchIn = batchListIn.getList(blankType);
        List<BlankBatch> blankBatchOut = batchListOut.getList(blankType);
        List<BlankBatch> blankBatchEnd = batchListEnd.getList(blankType);
        int maxSize = blankBatchStart.size();
        if (blankBatchIn.size() > maxSize) {
            maxSize = blankBatchIn.size();
        }
        if (blankBatchOut.size() > maxSize) {
            maxSize = blankBatchOut.size();
        }
        if (blankBatchEnd.size() > maxSize) {
            maxSize = blankBatchEnd.size();
        }
        if (maxSize == 0) {
            return;
        }
        this.totalRowsCount += maxSize;
        int shiftLinesCount = sheet.getLastRowNum() - 8;
        for (int i = 0; i < maxSize; ++i) {
            ++this.lineNumber;
            if (i < maxSize - 1) {
                ExcelUtils.insertRow((HSSFSheet)sheet, (int)this.lineNumber, (int)12, (int)shiftLinesCount);
            }
            if (i < blankBatchStart.size()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)1, (int)1, (int)1, (String)blankBatchStart.get(i).getFirstBlankNumber());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)2, (int)1, (int)1, (String)blankBatchStart.get(i).getLastBlankNumber());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)3, (int)1, (int)1, (int)blankBatchStart.get(i).getBlanksCount());
            }
            if (i < blankBatchIn.size()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)4, (int)1, (int)1, (String)blankBatchIn.get(i).getFirstBlankNumber());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)5, (int)1, (int)1, (String)blankBatchIn.get(i).getLastBlankNumber());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)6, (int)1, (int)1, (int)blankBatchIn.get(i).getBlanksCount());
            }
            if (i < blankBatchOut.size()) {
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)7, (int)1, (int)1, (String)blankBatchOut.get(i).getFirstBlankNumber());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)8, (int)1, (int)1, (String)blankBatchOut.get(i).getLastBlankNumber());
                ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)9, (int)1, (int)1, (int)blankBatchOut.get(i).getBlanksCount());
            }
            if (i >= blankBatchEnd.size()) continue;
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)10, (int)1, (int)1, (String)blankBatchEnd.get(i).getFirstBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)11, (int)1, (int)1, (String)blankBatchEnd.get(i).getLastBlankNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)this.lineNumber, (int)12, (int)1, (int)1, (int)blankBatchEnd.get(i).getBlanksCount());
        }
    }

    @Override
    public String getId() {
        return "xf-stock-control-report";
    }

    @Override
    protected String getReportFileName(Map<String, Object> data) {
        return this.getReportTitle(data) + ".xls";
    }

    @Override
    protected String getReportTitle(Map<String, Object> data) {
        return (String)data.get("AIRLINE_IATA_CODE") + "_" + (String)data.get("AGENCY_IATA_CODE") + "_" + L10nResourcesManager.createL10nMessage((String)Messages.XFStockControlReportRenderHandler_bsoMoving, (Object[])new Object[0]).toString() + (String)data.get("KEY_REPORT_FILENAME");
    }

    class XFEndStockOverviewBatchList
    extends BaseStockcontrolOverviewReportRender.BaseEndStockOverviewBatchList {
        XFEndStockOverviewBatchList() {
        }

        @Override
        public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
            return ListDefinitions.END;
        }
    }

    class XFOutStockOverviewBatchList
    extends BaseStockcontrolOverviewReportRender.BaseOutStockOverviewBatchList {
        XFOutStockOverviewBatchList() {
        }

        @Override
        public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
            return ListDefinitions.OUT;
        }
    }

    class XFInStockOverviewBatchList
    extends BaseStockcontrolOverviewReportRender.BaseInStockOverviewBatchList {
        XFInStockOverviewBatchList() {
        }

        @Override
        public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
            return ListDefinitions.IN;
        }
    }

    class XFStartStockOverviewBatchList
    extends BaseStockcontrolOverviewReportRender.BaseStartStockOverviewBatchList {
        XFStartStockOverviewBatchList() {
        }

        @Override
        public BaseStockcontrolOverviewReportRender.StockOverviewDefinition getDefinition() {
            return ListDefinitions.START;
        }
    }

    protected static enum ListDefinitions implements BaseStockcontrolOverviewReportRender.StockOverviewDefinition
    {
        START,
        IN,
        OUT,
        END;


        @Override
        public int[] getStartPosition(String blankTypeCode) {
            return null;
        }
    }
}

