/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render.template.common;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import groovy.util.BuilderSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryBuilder
extends BuilderSupport {
    private final SearchQuery query = new SearchQuery();
    private final Map<String, QueryItem<?, ?>> queryItems = new HashMap();

    public QueryBuilder() {
        this.queryItems.put("fields", new FieldsItem());
        this.queryItems.put("orderBy", new OrderItem());
        this.queryItems.put("eq", new EqItem());
        this.queryItems.put("ne", new NeItem());
        this.queryItems.put("gt", new GtItem());
        this.queryItems.put("ge", new GeItem());
        this.queryItems.put("le", new LeItem());
        this.queryItems.put("lt", new LtItem());
        this.queryItems.put("like", new LikeItem());
        this.queryItems.put("ilike", new ILikeItem());
        this.queryItems.put("contains", new ContainsItem());
        this.queryItems.put("icontains", new ContainsItem());
        this.queryItems.put("between", new BetweenItem());
        this.queryItems.put("notbetween", new NotBetweenItem());
        this.queryItems.put("IN", new InItem());
        this.queryItems.put("or", new OrItem());
        this.queryItems.put("and", new AndItem());
        this.queryItems.put("not", new NotItem());
    }

    protected void setParent(Object parent, Object child) {
        if (!(child instanceof QueryItemHolder)) {
            return;
        }
        QueryItemHolder parentItem = null;
        if (parent instanceof QueryItemHolder) {
            parentItem = (QueryItemHolder)parent;
        }
        QueryItemHolder childItem = (QueryItemHolder)child;
        childItem.parentContext = parentItem == null ? this.query : parentItem.context;
    }

    protected Object createNode(Object name) {
        return this.createNode(name, new HashMap());
    }

    protected Object createNode(Object name, Object value) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (value instanceof String) {
            attributes.put((String)value, null);
        }
        if (value instanceof List) {
            for (Object obj : (List)value) {
                attributes.put((String)obj, null);
            }
        }
        return this.createNode(name, attributes);
    }

    protected Object createNode(Object name, Map attributes) {
        if (!(name instanceof String)) {
            return null;
        }
        QueryItem<?, ?> item = this.queryItems.get(name);
        if (item == null) {
            return null;
        }
        QueryItemHolder holder = new QueryItemHolder();
        holder.item = item;
        holder.values = attributes;
        holder.parentContext = this.query;
        holder.context = holder.item.createNewContext();
        return holder;
    }

    protected void nodeCompleted(Object parent, Object node) {
        if (!(node instanceof QueryItemHolder)) {
            return;
        }
        QueryItemHolder itemHolder = (QueryItemHolder)node;
        itemHolder.item.updateQuery(itemHolder.values, itemHolder.parentContext, itemHolder.context);
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        return this.createNode(name, attributes);
    }

    public SearchQuery getQuery() {
        return this.query;
    }

    static class QueryItemHolder {
        QueryItem<Object, Object> item;
        Object context;
        Object parentContext;
        Map<String, Object> values;

        QueryItemHolder() {
        }
    }

    static class NotItem
    implements QueryItem<SearchQuery, SearchQuery> {
        NotItem() {
        }

        @Override
        public SearchQuery createNewContext() {
            return new SearchQuery();
        }

        @Override
        public void updateQuery(Map<String, Object> value, SearchQuery parentContext, SearchQuery currentContext) {
            List crits = currentContext.getCriteria().getCriterions();
            parentContext.getCriteria().getCriterions().add(SearchCriterion.not((SearchCriterion)(crits.size() > 1 ? SearchCriterion.and((SearchCriterion[])crits.toArray(new SearchCriterion[crits.size()])) : (SearchCriterion)crits.get(0))));
        }
    }

    static class AndItem
    extends BaseJunctionItem {
        AndItem() {
        }

        @Override
        protected SearchCriterion createCriterion(SearchCriterion[] criterions) {
            return SearchCriterion.and((SearchCriterion[])criterions);
        }
    }

    static class OrItem
    extends BaseJunctionItem {
        OrItem() {
        }

        @Override
        protected SearchCriterion createCriterion(SearchCriterion[] criterions) {
            return SearchCriterion.or((SearchCriterion[])criterions);
        }
    }

    static abstract class BaseJunctionItem
    implements QueryItem<SearchQuery, SearchQuery> {
        BaseJunctionItem() {
        }

        @Override
        public SearchQuery createNewContext() {
            return new SearchQuery();
        }

        @Override
        public void updateQuery(Map<String, Object> value, SearchQuery parentContext, SearchQuery currentContext) {
            parentContext.getCriteria().getCriterions().add(this.createCriterion(currentContext.getCriteria().getCriterions().toArray(new SearchCriterion[currentContext.getCriteria().getCriterions().size()])));
        }

        protected abstract SearchCriterion createCriterion(SearchCriterion[] var1);
    }

    static abstract class BaseBetweenItem
    implements QueryItem<Void, SearchQuery> {
        BaseBetweenItem() {
        }

        @Override
        public Void createNewContext() {
            return null;
        }

        @Override
        public void updateQuery(Map<String, Object> value, SearchQuery parentContext, Void currentContext) {
            Map.Entry<String, Object> entry = value.entrySet().iterator().next();
            List lst = (List)entry.getValue();
            parentContext.getCriteria().getCriterions().add(this.createCriterion(entry.getKey(), lst.get(0), lst.get(1)));
        }

        protected abstract SearchCriterion createCriterion(String var1, Object var2, Object var3);
    }

    static abstract class BaseCheckItem
    implements QueryItem<Void, SearchQuery> {
        BaseCheckItem() {
        }

        @Override
        public Void createNewContext() {
            return null;
        }

        @Override
        public void updateQuery(Map<String, Object> value, SearchQuery parentContext, Void currentContext) {
            Map.Entry<String, Object> entry = value.entrySet().iterator().next();
            parentContext.getCriteria().getCriterions().add(this.createCriterion(entry.getKey()));
        }

        protected abstract SearchCriterion createCriterion(String var1);
    }

    static class IsNotEmptyItem
    extends BaseCheckItem {
        IsNotEmptyItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String propertyName) {
            return SearchCriterion.isNotEmpty((String)propertyName);
        }
    }

    static class IsEmptyItem
    extends BaseCheckItem {
        IsEmptyItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String propertyName) {
            return SearchCriterion.isEmpty((String)propertyName);
        }
    }

    static class IsNotNullItem
    extends BaseCheckItem {
        IsNotNullItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String propertyName) {
            return SearchCriterion.ne((String)propertyName, null);
        }
    }

    static class IsNullItem
    extends BaseCheckItem {
        IsNullItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String propertyName) {
            return SearchCriterion.eq((String)propertyName, null);
        }
    }

    static class InItem
    implements QueryItem<Void, SearchQuery> {
        InItem() {
        }

        @Override
        public Void createNewContext() {
            return null;
        }

        @Override
        public void updateQuery(Map<String, Object> value, SearchQuery parentContext, Void currentContext) {
            Map.Entry<String, Object> entry = value.entrySet().iterator().next();
            List lst = (List)entry.getValue();
            parentContext.getCriteria().getCriterions().add(SearchCriterion.in((String)entry.getKey(), (Object[])lst.toArray()));
        }
    }

    static class NotBetweenItem
    extends BaseBetweenItem {
        NotBetweenItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String propertyName, Object lo, Object hi) {
            return SearchCriterion.notbetween((String)propertyName, (Object)lo, (Object)hi);
        }
    }

    static class BetweenItem
    extends BaseBetweenItem {
        BetweenItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String propertyName, Object lo, Object hi) {
            return SearchCriterion.between((String)propertyName, (Object)lo, (Object)hi);
        }
    }

    static class LeItem
    extends BaseSimpleCriterionItem {
        LeItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String key, Object value) {
            return SearchCriterion.le((String)key, (Object)value);
        }
    }

    static class LtItem
    extends BaseSimpleCriterionItem {
        LtItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String key, Object value) {
            return SearchCriterion.lt((String)key, (Object)value);
        }
    }

    static class GeItem
    extends BaseSimpleCriterionItem {
        GeItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String key, Object value) {
            return SearchCriterion.ge((String)key, (Object)value);
        }
    }

    static class GtItem
    extends BaseSimpleCriterionItem {
        GtItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String key, Object value) {
            return SearchCriterion.gt((String)key, (Object)value);
        }
    }

    static class IContainsItem
    extends BaseSimpleCriterionItem {
        IContainsItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String key, Object value) {
            return SearchCriterion.icontains((String)key, (String)((String)value));
        }
    }

    static class ContainsItem
    extends BaseSimpleCriterionItem {
        ContainsItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String key, Object value) {
            if (value instanceof Enum) {
                return SearchCriterion.contains((String)key, (Object)value);
            }
            if (value instanceof EntityReference) {
                return SearchCriterion.contains((String)key, (Object)value);
            }
            return SearchCriterion.contains((String)key, (Object)value);
        }
    }

    static class ILikeItem
    extends BaseSimpleCriterionItem {
        ILikeItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String key, Object value) {
            return SearchCriterion.ilike((String)key, (String)((String)value));
        }
    }

    static class LikeItem
    extends BaseSimpleCriterionItem {
        LikeItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String key, Object value) {
            return SearchCriterion.like((String)key, (String)((String)value));
        }
    }

    static class NeItem
    extends BaseSimpleCriterionItem {
        NeItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String key, Object value) {
            return SearchCriterion.ne((String)key, (Object)value);
        }
    }

    static class EqItem
    extends BaseSimpleCriterionItem {
        EqItem() {
        }

        @Override
        protected SearchCriterion createCriterion(String key, Object value) {
            return SearchCriterion.eq((String)key, (Object)value);
        }
    }

    static abstract class BaseSimpleCriterionItem
    implements QueryItem<Void, SearchQuery> {
        BaseSimpleCriterionItem() {
        }

        @Override
        public Void createNewContext() {
            return null;
        }

        @Override
        public void updateQuery(Map<String, Object> value, SearchQuery parentContext, Void currentContext) {
            Map.Entry<String, Object> entry = value.entrySet().iterator().next();
            parentContext.getCriteria().getCriterions().add(this.createCriterion(entry.getKey(), entry.getValue()));
        }

        protected abstract SearchCriterion createCriterion(String var1, Object var2);
    }

    static class OrderItem
    implements QueryItem<Void, SearchQuery> {
        OrderItem() {
        }

        @Override
        public Void createNewContext() {
            return null;
        }

        @Override
        public void updateQuery(Map<String, Object> value, SearchQuery parentContext, Void currentContext) {
            Map.Entry<String, Object> entry = value.entrySet().iterator().next();
            parentContext.getCriteria().getOrders().put(entry.getKey(), SortOrder.valueOf((String)((String)entry.getValue())));
        }
    }

    static class FieldsItem
    implements QueryItem<Void, SearchQuery> {
        FieldsItem() {
        }

        @Override
        public Void createNewContext() {
            return null;
        }

        @Override
        public void updateQuery(Map<String, Object> value, SearchQuery parentContext, Void currentContext) {
            parentContext.getPreferredProperties().addAll(value.keySet());
        }
    }

    static interface QueryItem<T, M> {
        public T createNewContext();

        public void updateQuery(Map<String, Object> var1, M var2, T var3);
    }
}

