/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.restriction.helper;

import com.gridnine.xtrip.common.model.system.BaseRequestedParameter;
import com.gridnine.xtrip.common.model.system.RequestedParameterControlType;
import com.gridnine.xtrip.common.model.system.RequestedParameterCustomType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.render.template.common.CommonTemplateReportGlobalParameter;
import com.gridnine.xtrip.common.restriction.helper.RestrictionRulesHelper;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionQueryable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyCondition;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyDynamicValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyCategory;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RestrictionsHelper {
    private RestrictionsHelper() {
    }

    public static List<RestrictionResourcePropertyDynamicValueHandler> createDynamicValueHandlers(List<? extends BaseRequestedParameter> parameters, final BaseTemplateReportParameters values) {
        ArrayList<RestrictionResourcePropertyDynamicValueHandler> handlers = new ArrayList<RestrictionResourcePropertyDynamicValueHandler>();
        handlers.add(new RestrictionResourcePropertyDynamicValueHandler(){

            public String getId() {
                return CommonTemplateReportGlobalParameter.REPORT_PERIOD_BEGIN.name();
            }

            public String getName() {
                return Messages.periodBegin;
            }

            public String getDescription() {
                return this.getName();
            }

            public String getCategoryId() {
                return StandardRestrictionResourcePropertyCategory.DATE.name();
            }

            public Set<String> getConditionIds(RestrictionResourceProperty property) {
                if (property.isCollection()) {
                    Collections.emptyList();
                }
                return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
            }

            public boolean hasParameters() {
                return false;
            }

            public String getRendererId(RestrictionResourceProperty property, String conditionId) {
                return null;
            }

            public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
                Object propertyValue = ((RestrictionMatchable)property).getValue(proxy);
                if (propertyValue != null) {
                    Date parameterValue;
                    Date date = parameterValue = values != null ? values.getPeriodBegin() : null;
                    if (parameterValue != null) {
                        Date date2 = (Date)propertyValue;
                        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime((Date)parameterValue, (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)parameterValue, (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true));
                        if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                        }
                        if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                        }
                        if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER);
                        }
                        if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                        }
                        if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER);
                        }
                        if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                        }
                    }
                }
                return true;
            }

            public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
                String column = ((RestrictionQueryable)property).getColumn();
                if (column != null) {
                    Date parameterValue;
                    Date date = parameterValue = values != null ? values.getPeriodBegin() : null;
                    if (parameterValue != null) {
                        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime((Date)parameterValue, (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)parameterValue, (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true));
                        if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                        }
                        if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                        }
                        if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER);
                        }
                        if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                        }
                        if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER);
                        }
                        if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                        }
                    }
                }
                return null;
            }

            public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
                return String.format("%s %s %s", property.getName(), condition.getName(), this.getName());
            }
        });
        handlers.add(new RestrictionResourcePropertyDynamicValueHandler(){

            public String getId() {
                return CommonTemplateReportGlobalParameter.REPORT_PERIOD_END.name();
            }

            public String getName() {
                return Messages.periodEnd;
            }

            public String getDescription() {
                return this.getName();
            }

            public String getCategoryId() {
                return StandardRestrictionResourcePropertyCategory.DATE.name();
            }

            public Set<String> getConditionIds(RestrictionResourceProperty property) {
                if (property.isCollection()) {
                    Collections.emptyList();
                }
                return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
            }

            public boolean hasParameters() {
                return false;
            }

            public String getRendererId(RestrictionResourceProperty property, String conditionId) {
                return null;
            }

            public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
                Object propertyValue = ((RestrictionMatchable)property).getValue(proxy);
                if (propertyValue != null) {
                    Date parameterValue;
                    Date date = parameterValue = values != null ? values.getPeriodEnd() : null;
                    if (parameterValue != null) {
                        Date date2 = (Date)propertyValue;
                        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime((Date)parameterValue, (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)parameterValue, (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true));
                        if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                        }
                        if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                        }
                        if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER);
                        }
                        if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                        }
                        if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER);
                        }
                        if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.isDateInterval((Date)date2, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                        }
                    }
                }
                return true;
            }

            public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
                String column = ((RestrictionQueryable)property).getColumn();
                if (column != null) {
                    Date parameterValue;
                    Date date = parameterValue = values != null ? values.getPeriodEnd() : null;
                    if (parameterValue != null) {
                        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime((Date)parameterValue, (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)parameterValue, (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true));
                        if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                        }
                        if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                        }
                        if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER);
                        }
                        if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                        }
                        if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER);
                        }
                        if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                            return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)dateInterval, (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                        }
                    }
                }
                return null;
            }

            public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
                return String.format("%s %s %s", property.getName(), condition.getName(), this.getName());
            }
        });
        for (final BaseRequestedParameter baseRequestedParameter : parameters) {
            handlers.add(new RestrictionResourcePropertyDynamicValueHandler(){

                public String getId() {
                    return baseRequestedParameter.getKey();
                }

                public String getName() {
                    return baseRequestedParameter.getName();
                }

                public String getDescription() {
                    return this.getName();
                }

                public String getCategoryId() {
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.BOOLEAN) {
                        return StandardRestrictionResourcePropertyCategory.BOOLEAN.name();
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.STRING) {
                        return StandardRestrictionResourcePropertyCategory.STRING.name();
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.NUMBER) {
                        return StandardRestrictionResourcePropertyCategory.NUMBER.name();
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.AGENCY || baseRequestedParameter.getType() == RequestedParameterCustomType.AGENT || baseRequestedParameter.getType() == RequestedParameterCustomType.CLIENT || baseRequestedParameter.getType() == RequestedParameterCustomType.SUPPLIER || baseRequestedParameter.getType() == RequestedParameterCustomType.BLANK_OWNER || baseRequestedParameter.getType() == RequestedParameterCustomType.ENTITY || baseRequestedParameter.getType() == RequestedParameterCustomType.SALES_POINT || baseRequestedParameter.getType() == RequestedParameterCustomType.CASH || baseRequestedParameter.getType() == RequestedParameterCustomType.CASH_REGISTER || baseRequestedParameter.getType() == RequestedParameterCustomType.CASH_REGISTER_WORKPLACE || baseRequestedParameter.getType() == RequestedParameterCustomType.WORKLOG || baseRequestedParameter.getType() == RequestedParameterCustomType.LOCATION) {
                        return StandardRestrictionResourcePropertyCategory.ENTITY.name();
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.DICTIONARY) {
                        return StandardRestrictionResourcePropertyCategory.DICTIONARY.name();
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.ENUM) {
                        return StandardRestrictionResourcePropertyCategory.ENUM.name();
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.DATE || baseRequestedParameter.getType() == RequestedParameterCustomType.DATETIME) {
                        return StandardRestrictionResourcePropertyCategory.DATE.name();
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.FILE) {
                        return StandardRestrictionResourcePropertyCategory.NULL.name();
                    }
                    return StandardRestrictionResourcePropertyCategory.NULL.name();
                }

                public Set<String> getConditionIds(RestrictionResourceProperty property) {
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.BOOLEAN) {
                        if (property.isCollection()) {
                            return Collections.emptySet();
                        }
                        return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId()));
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.STRING) {
                        if (property.isCollection()) {
                            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId()));
                        }
                        return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId()));
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.NUMBER) {
                        if (property.isCollection()) {
                            Collections.emptyList();
                        }
                        return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.ENUM) {
                        if (property.isCollection()) {
                            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId()));
                        }
                        return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId()));
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.DICTIONARY) {
                        if (property.isCollection()) {
                            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId()));
                        }
                        return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId()));
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.AGENCY || baseRequestedParameter.getType() == RequestedParameterCustomType.AGENT || baseRequestedParameter.getType() == RequestedParameterCustomType.CLIENT || baseRequestedParameter.getType() == RequestedParameterCustomType.SUPPLIER || baseRequestedParameter.getType() == RequestedParameterCustomType.BLANK_OWNER || baseRequestedParameter.getType() == RequestedParameterCustomType.ENTITY || baseRequestedParameter.getType() == RequestedParameterCustomType.SALES_POINT || baseRequestedParameter.getType() == RequestedParameterCustomType.CASH || baseRequestedParameter.getType() == RequestedParameterCustomType.CASH_REGISTER || baseRequestedParameter.getType() == RequestedParameterCustomType.CASH_REGISTER_WORKPLACE || baseRequestedParameter.getType() == RequestedParameterCustomType.WORKLOG || baseRequestedParameter.getType() == RequestedParameterCustomType.LOCATION) {
                        if (property.isCollection()) {
                            return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId(), StandardRestrictionResourcePropertyConditions.BEGINS.getId(), StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId(), StandardRestrictionResourcePropertyConditions.ENDS.getId(), StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId()));
                        }
                        return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId()));
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.DATE || baseRequestedParameter.getType() == RequestedParameterCustomType.DATETIME) {
                        if (property.isCollection()) {
                            Collections.emptyList();
                        }
                        return new HashSet<String>(Arrays.asList(StandardRestrictionResourcePropertyConditions.EQUALS.getId(), StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.GREATER.getId(), StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId(), StandardRestrictionResourcePropertyConditions.LOWER.getId(), StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId()));
                    }
                    if (baseRequestedParameter.getType() == RequestedParameterCustomType.FILE) {
                        return Collections.emptySet();
                    }
                    return Collections.emptySet();
                }

                public boolean hasParameters() {
                    return false;
                }

                public String getRendererId(RestrictionResourceProperty property, String conditionId) {
                    return null;
                }

                public boolean match(RestrictionResourceProperty property, RestrictionResourceProxy proxy, RestrictionResourcePropertyCondition condition, Object value, String userId) {
                    Object propertyValue = ((RestrictionMatchable)property).getValue(proxy);
                    if (propertyValue != null) {
                        List<Object> parameterValue;
                        List<Object> list = parameterValue = values != null ? values.getRequestedParameters().stream().filter(item -> item.getKey() != null && item.getKey().equals(baseRequestedParameter.getKey())).map(item -> item.getValue()).findFirst().orElse(null) : null;
                        if (parameterValue != null) {
                            if (!(baseRequestedParameter.getControlType() == RequestedParameterControlType.COLLECTION || Boolean.class.isAssignableFrom(property.getType()) || Number.class.isAssignableFrom(property.getType()) || Date.class.isAssignableFrom(property.getType()))) {
                                parameterValue = Collections.singletonList(parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                                if (Boolean.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isBoolean((Boolean)((Boolean)propertyValue), (Boolean)((Boolean)((Object)parameterValue)), (RestrictionRulesHelper.BooleanCondition)RestrictionRulesHelper.BooleanCondition.EQUALS);
                                }
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isNumber((Number)((Number)propertyValue), (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.EQUALS);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isDateInterval((Date)((Date)propertyValue), (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                                }
                                return RestrictionRulesHelper.isEquals((Object)propertyValue, (Collection)parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                                if (Boolean.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isBoolean((Boolean)((Boolean)propertyValue), (Boolean)((Boolean)((Object)parameterValue)), (RestrictionRulesHelper.BooleanCondition)RestrictionRulesHelper.BooleanCondition.NOT_EQUALS);
                                }
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isNumber((Number)((Number)propertyValue), (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.NOT_EQUALS);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isDateInterval((Date)((Date)propertyValue), (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                                }
                                return !RestrictionRulesHelper.isEquals((Object)propertyValue, (Collection)parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.CONTAINS.getId().equals(condition.getId())) {
                                return property.isCollection() ? RestrictionRulesHelper.isContainsCollection((Collection)((Collection)propertyValue), (Collection)parameterValue) : RestrictionRulesHelper.isContains((String)((String)propertyValue), (Collection)parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId().equals(condition.getId())) {
                                return property.isCollection() ? !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)propertyValue), (Collection)parameterValue) : !RestrictionRulesHelper.isContains((String)((String)propertyValue), (Collection)parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.BEGINS.getId().equals(condition.getId())) {
                                return property.isCollection() ? RestrictionRulesHelper.isBeginsCollection((Collection)((Collection)propertyValue), (Collection)parameterValue) : RestrictionRulesHelper.isBegins((String)((String)propertyValue), (Collection)parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId().equals(condition.getId())) {
                                return property.isCollection() ? !RestrictionRulesHelper.isBeginsCollection((Collection)((Collection)propertyValue), (Collection)parameterValue) : !RestrictionRulesHelper.isBegins((String)((String)propertyValue), (Collection)parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.ENDS.getId().equals(condition.getId())) {
                                return property.isCollection() ? RestrictionRulesHelper.isEndsCollection((Collection)((Collection)propertyValue), (Collection)parameterValue) : RestrictionRulesHelper.isEnds((String)((String)propertyValue), (Collection)parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId().equals(condition.getId())) {
                                return property.isCollection() ? !RestrictionRulesHelper.isEndsCollection((Collection)((Collection)propertyValue), (Collection)parameterValue) : !RestrictionRulesHelper.isEnds((String)((String)propertyValue), (Collection)parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isNumber((Number)((Number)propertyValue), (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.GREATER);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isDateInterval((Date)((Date)propertyValue), (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER);
                                }
                                return true;
                            }
                            if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isNumber((Number)((Number)propertyValue), (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.GREATER_OR_EQUALS);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isDateInterval((Date)((Date)propertyValue), (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                                }
                                return true;
                            }
                            if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isNumber((Number)((Number)propertyValue), (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.LOWER);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isDateInterval((Date)((Date)propertyValue), (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER);
                                }
                                return true;
                            }
                            if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isNumber((Number)((Number)propertyValue), (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.LOWER_OR_EQUALS);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.isDateInterval((Date)((Date)propertyValue), (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                                }
                                return true;
                            }
                        }
                    }
                    return true;
                }

                public SearchCriterion getQuery(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value, String userId) {
                    String column = ((RestrictionQueryable)property).getColumn();
                    if (column != null) {
                        List<Object> parameterValue;
                        List<Object> list = parameterValue = values != null ? values.getRequestedParameters().stream().filter(item -> item.getKey() != null && item.getKey().equals(baseRequestedParameter.getKey())).map(item -> item.getValue()).findFirst().orElse(null) : null;
                        if (parameterValue != null) {
                            if (!(baseRequestedParameter.getControlType() == RequestedParameterControlType.COLLECTION || Boolean.class.isAssignableFrom(property.getType()) || Number.class.isAssignableFrom(property.getType()) || Date.class.isAssignableFrom(property.getType()))) {
                                parameterValue = Collections.singletonList(parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                                if (Boolean.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createBooleanCriterion((String)column, (Boolean)((Boolean)((Object)parameterValue)), (RestrictionRulesHelper.BooleanCondition)RestrictionRulesHelper.BooleanCondition.EQUALS);
                                }
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createNumberCriterion((String)column, (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.EQUALS);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.WITHIN);
                                }
                                return RestrictionRulesHelper.createEqualsCriterion((String)column, (Collection)parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                                if (Boolean.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createBooleanCriterion((String)column, (Boolean)((Boolean)((Object)parameterValue)), (RestrictionRulesHelper.BooleanCondition)RestrictionRulesHelper.BooleanCondition.NOT_EQUALS);
                                }
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createNumberCriterion((String)column, (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.NOT_EQUALS);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.BEYOND);
                                }
                                return RestrictionRulesHelper.createNotEqualsCriterion((String)column, (Collection)parameterValue);
                            }
                            if (StandardRestrictionResourcePropertyConditions.CONTAINS.getId().equals(condition.getId())) {
                                return RestrictionRulesHelper.createContainsCriterion((String)column, (Collection)parameterValue, (boolean)property.isCollection());
                            }
                            if (StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId().equals(condition.getId())) {
                                return RestrictionRulesHelper.createNotContainsCriterion((String)column, (Collection)parameterValue, (boolean)property.isCollection());
                            }
                            if (StandardRestrictionResourcePropertyConditions.BEGINS.getId().equals(condition.getId())) {
                                return RestrictionRulesHelper.createBeginsCriterion((String)column, (Collection)parameterValue, (boolean)property.isCollection());
                            }
                            if (StandardRestrictionResourcePropertyConditions.NOT_BEGINS.getId().equals(condition.getId())) {
                                return RestrictionRulesHelper.createNotBeginsCriterion((String)column, (Collection)parameterValue, (boolean)property.isCollection());
                            }
                            if (StandardRestrictionResourcePropertyConditions.ENDS.getId().equals(condition.getId())) {
                                return RestrictionRulesHelper.createEndsCriterion((String)column, (Collection)parameterValue, (boolean)property.isCollection());
                            }
                            if (StandardRestrictionResourcePropertyConditions.NOT_ENDS.getId().equals(condition.getId())) {
                                return RestrictionRulesHelper.createNotEndsCriterion((String)column, (Collection)parameterValue, (boolean)property.isCollection());
                            }
                            if (StandardRestrictionResourcePropertyConditions.GREATER.getId().equals(condition.getId())) {
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createNumberCriterion((String)column, (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.GREATER);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER);
                                }
                                return null;
                            }
                            if (StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId().equals(condition.getId())) {
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createNumberCriterion((String)column, (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.GREATER_OR_EQUALS);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.GREATER_OR_EQUALS);
                                }
                                return null;
                            }
                            if (StandardRestrictionResourcePropertyConditions.LOWER.getId().equals(condition.getId())) {
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createNumberCriterion((String)column, (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.LOWER);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER);
                                }
                                return null;
                            }
                            if (StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId().equals(condition.getId())) {
                                if (Number.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createNumberCriterion((String)column, (Number)((Number)((Object)parameterValue)), (RestrictionRulesHelper.NumberCondition)RestrictionRulesHelper.NumberCondition.LOWER_OR_EQUALS);
                                }
                                if (Date.class.isAssignableFrom(property.getType())) {
                                    return RestrictionRulesHelper.createDateIntervalCriterion((String)column, (DateInterval)new DateInterval(MiscUtil.clearTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true), MiscUtil.setDayEndTime((Date)((Date)((Object)parameterValue)), (!property.isTimeIncluded() ? 1 : 0) != 0, (!property.isTimeIncluded() ? 1 : 0) != 0, (boolean)true, (boolean)true)), (RestrictionRulesHelper.DateIntervalCondition)RestrictionRulesHelper.DateIntervalCondition.LOWER_OR_EQUALS);
                                }
                                return null;
                            }
                        }
                    }
                    return null;
                }

                public String getInfo(RestrictionResourceProperty property, RestrictionResourcePropertyCondition condition, Object value) {
                    return String.format("%s %s %s", property.getName(), condition.getName(), this.getName());
                }
            });
        }
        return handlers;
    }
}

