/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.security.acl.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.security.acl.helper.AclModelRulesHelper;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.security.acl.resource.ReportsAclEntityResources;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import com.gridnine.xtrip.common.security.acl.resource.AclMatchable;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxy;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum ReportsAclAgentReportDocumentResourceProperties implements AclResourceProperty,
AclMatchable
{
    BLANK_OWNER{

        @Override
        public String getIdSuffix() {
            return "blankOwner";
        }

        public String getName() {
            return L10nResourcesManager.createL10nMessage((String)Messages.ReportsAcl_blankOwner, (Object[])new Object[0]).toString();
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            ArrayList blankOwners = new ArrayList();
            AgentReportDocument agentReportDocument = (AgentReportDocument)object;
            if (agentReportDocument.getParameters() != null) {
                blankOwners.addAll(agentReportDocument.getParameters().getVendors());
            }
            proxy.getProperties().put(this.getId(), blankOwners);
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                List blankOwners = (List)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Collection)blankOwners, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Collection)blankOwners, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Collection)blankOwners, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Collection)blankOwners, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                    return AclRulesHelper.isNull((Collection)blankOwners);
                }
                if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isNull((Collection)blankOwners);
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((Collection)blankOwners, (String)userId);
                }
            }
            return true;
        }
    }
    ,
    AGENCY{

        @Override
        public String getIdSuffix() {
            return "agency";
        }

        public String getName() {
            return L10nResourcesManager.createL10nMessage((String)Messages.ReportsAcl_agency, (Object[])new Object[0]).toString();
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            AgentReportDocument agentReportDocument = (AgentReportDocument)object;
            proxy.getProperties().put(this.getId(), agentReportDocument.getParameters() != null ? agentReportDocument.getParameters().getAgency() : null);
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference agency = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)agency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)agency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)agency, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)agency, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                    return AclRulesHelper.isNull((Object)agency);
                }
                if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isNull((Object)agency);
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference)agency, (String)userId);
                }
            }
            return true;
        }
    }
    ,
    AGENT{

        @Override
        public String getIdSuffix() {
            return "agent";
        }

        public String getName() {
            return L10nResourcesManager.createL10nMessage((String)Messages.ReportsAcl_agent, (Object[])new Object[0]).toString();
        }

        public Class<?> getType() {
            return Person.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId(), ModelAclResourcePropertyConditions.MY_PERSONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            AgentReportDocument agentReportDocument = (AgentReportDocument)object;
            proxy.getProperties().put(this.getId(), agentReportDocument.getParameters() != null ? agentReportDocument.getParameters().getAgent() : null);
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference agent = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)agent, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)agent, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)agent, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)agent, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                    return AclRulesHelper.isNull((Object)agent);
                }
                if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isNull((Object)agent);
                }
                if (ModelAclResourcePropertyConditions.MY_PERSONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyPersons((EntityReference)agent, (String)userId);
                }
            }
            return true;
        }
    };


    public abstract String getIdSuffix();

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    public String getResourceId() {
        return ReportsAclEntityResources.ENTITY_AGENT_REPORT_DOCUMENT.getId();
    }

    public String getInfo(AclResourcePropertyCondition condition, Object value) {
        AclResourcesEnvironment environment = (AclResourcesEnvironment)Environment.getPublished(AclResourcesEnvironment.class);
        String propertyName = this.getName();
        String resourceName = environment.getResource(this.getResourceId()).getName();
        return AclRulesHelper.getInfo((String)String.format("%s (%s)", propertyName, resourceName), (AclResourcePropertyCondition)condition, (Object)value);
    }
}

