/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.ex;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.UniqueIdentity;
import org.java.plugin.util.IoUtil;

public class IndexPluginClassLoader
extends PluginClassLoader {
    static Log log = LogFactory.getLog(IndexPluginClassLoader.class);
    private final Map<String, List<CodeInfo>> codeIndex = new HashMap<String, List<CodeInfo>>();
    private final Map<String, List<URL>> resourcesPathIndex = new HashMap<String, List<URL>>();
    private final Map<String, List<URL>> resourcesParentIndex = new HashMap<String, List<URL>>();
    private final Map<String, List<URL>> resourceURLCache = new HashMap<String, List<URL>>();
    private final URL[] urls;
    private final List<Closeable> closeable = new CopyOnWriteArrayList<Closeable>();
    private static File libCacheFolder;
    private static boolean libCacheFolderInitialized;
    private final Map<String, File> libraryCache = new HashMap<String, File>();

    public IndexPluginClassLoader(PluginManager aManager, ClassLoader parent) {
        super(aManager, null, new URL[0], parent);
        this.urls = IndexPluginClassLoader.getUrls(aManager);
        this.loadIndex(aManager);
    }

    public void close() throws IOException {
        super.close();
        for (Closeable c : this.closeable) {
            c.close();
        }
        this.closeable.clear();
        for (File file : this.libraryCache.values()) {
            file.delete();
        }
        this.libraryCache.clear();
    }

    protected void dispose() {
    }

    public URL[] getURLs() {
        return this.urls;
    }

    private void loadIndex(PluginManager manager) {
        PluginRegistry registry = manager.getRegistry();
        PathResolver pathResolver = manager.getPathResolver();
        for (PluginDescriptor pd : registry.getPluginDescriptors()) {
            this.loadIndex((UniqueIdentity)pd, pathResolver);
        }
        for (PluginDescriptor pd : registry.getPluginFragments()) {
            this.loadIndex((UniqueIdentity)pd, pathResolver);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadIndex(UniqueIdentity pd, PathResolver pathResolver) {
        URL pi = pathResolver.resolvePath((Identity)pd, "plugin.index");
        if (null == pi || !IoUtil.isResourceExists((URL)pi)) {
            this.index((Identity)pd, pathResolver);
            return;
        }
        try {
            log.info((Object)("load index, plugin " + (pd instanceof PluginFragment ? "fragment " : "") + pd.getUniqueId()));
            try (BufferedReader in = new BufferedReader(new InputStreamReader(IoUtil.getResourceInputStream((URL)pi)));){
                String line;
                if (!pd.getId().equals(in.readLine())) {
                    log.warn((Object)("invalid index file, plugin " + (pd instanceof PluginFragment ? "fragment " : "") + pd.getUniqueId()));
                    this.index((Identity)pd, pathResolver);
                    return;
                }
                in.readLine();
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("code=")) {
                        String libraryName = line.substring(6);
                        URL resolvedURL = pathResolver.resolvePath((Identity)pd, libraryName);
                        URL libraryOriginalURL = this.getOriginalUrl(resolvedURL);
                        URL libraryURL = this.maybeJarUrl(resolvedURL);
                        String libraryURLPath = libraryURL.getPath();
                        if (!libraryURLPath.endsWith("/")) {
                            libraryURL = IndexPluginClassLoader.setURLPath(libraryURL, libraryURLPath + "/");
                        }
                        boolean rootIsEmpty = '-' == line.charAt(5);
                        this.putCode("", libraryURL, libraryOriginalURL, rootIsEmpty);
                        while ((line = in.readLine()) != null && !"".equals(line)) {
                            String path = line.substring(1);
                            boolean empty = '-' == line.charAt(0);
                            this.putCode(path, libraryURL, libraryOriginalURL, empty);
                        }
                        if (null == line) {
                            return;
                        }
                    }
                    if (!line.startsWith("resources=")) continue;
                    String resourceName = line.substring(11);
                    URL resourceURL = this.maybeJarUrl(pathResolver.resolvePath((Identity)pd, resourceName));
                    String resourceURLPath = resourceURL.getPath();
                    if (!resourceURLPath.endsWith("/")) {
                        resourceURL = IndexPluginClassLoader.setURLPath(resourceURL, resourceURLPath + "/");
                    }
                    boolean rootIsEmpty = '-' == line.charAt(5);
                    this.putResources("", resourceURL, rootIsEmpty);
                    while ((line = in.readLine()) != null && !"".equals(line)) {
                        String path = line.substring(1);
                        boolean empty = '-' == line.charAt(0);
                        this.putResources(path, resourceURL, empty);
                    }
                    if (null == line) return;
                }
                return;
            }
        }
        catch (IOException e) {
            log.error((Object)("an error has occurred while process index file, plugin " + (pd instanceof PluginFragment ? "fragment " : "") + pd.getUniqueId()), (Throwable)e);
            this.index((Identity)pd, pathResolver);
        }
    }

    private static URL setURLPath(URL url, String newPath) throws MalformedURLException {
        String ref;
        String newFile = newPath;
        String query = url.getQuery();
        if (query != null) {
            newFile = newFile + "?" + query;
        }
        if ((ref = url.getRef()) != null) {
            newFile = newFile + "#" + ref;
        }
        return new URL(url.getProtocol(), url.getHost(), url.getPort(), newFile);
    }

    private void index(Identity pd, PathResolver pathResolver) {
        if (pd instanceof PluginDescriptor) {
            this.index((PluginDescriptor)pd, pathResolver);
        }
    }

    private void index(PluginDescriptor pd, PathResolver pathResolver) {
        log.info((Object)("index plugin " + pd.getUniqueId()));
        for (Library library : pd.getLibraries()) {
            try {
                URL path;
                File file;
                PluginFragment declaringDescriptor = library.getDeclaringPluginFragment();
                if (null == declaringDescriptor) {
                    declaringDescriptor = library.getDeclaringPluginDescriptor();
                }
                if (null == (file = IoUtil.url2file((URL)(path = pathResolver.resolvePath((Identity)declaringDescriptor, library.getPath()))))) {
                    log.error((Object)("external resource found, library " + library + ", resource " + library.getPath()));
                    continue;
                }
                if (file.exists()) {
                    final HashSet<String> a = new HashSet<String>();
                    final HashSet<String> b = new HashSet<String>();
                    if (file.isDirectory()) {
                        final Path root = file.toPath();
                        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                if (!dir.equals(root)) {
                                    b.add(root.relativize(dir).toString().replace(File.separator, "/"));
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Path parent = root.relativize(file).getParent();
                                a.add(parent != null ? parent.toString().replace(File.separator, "/") : "");
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        try (ZipFile jar = new ZipFile(file);){
                            Enumeration<? extends ZipEntry> iter = jar.entries();
                            while (iter.hasMoreElements()) {
                                String name;
                                ZipEntry entry = iter.nextElement();
                                if (entry.isDirectory()) {
                                    name = entry.getName();
                                    if (name.endsWith("/")) {
                                        name = name.substring(0, name.length() - 1);
                                    }
                                    b.add(name);
                                    continue;
                                }
                                name = entry.getName();
                                int p = name.lastIndexOf("/");
                                String parent = p != -1 ? name.substring(0, p) : "";
                                a.add(parent);
                            }
                        }
                        block13: for (String item : a) {
                            if (item.length() == 0) continue;
                            String toAdd = item;
                            while (true) {
                                b.add(toAdd);
                                int p = toAdd.lastIndexOf("/");
                                if (p < 1) continue block13;
                                toAdd = toAdd.substring(0, p);
                            }
                        }
                    }
                    URL libraryOriginalURL = this.getOriginalUrl(path);
                    URL libraryURL = this.maybeJarUrl(path);
                    String libraryURLPath = libraryURL.getPath();
                    if (!libraryURLPath.endsWith("/")) {
                        libraryURL = IndexPluginClassLoader.setURLPath(libraryURL, libraryURLPath + "/");
                    }
                    boolean rootIsEmpty = !a.contains("");
                    boolean isCodeLibrary = library.isCodeLibrary();
                    if (isCodeLibrary) {
                        this.putCode("", libraryURL, libraryOriginalURL, rootIsEmpty);
                    } else {
                        this.putResources("", libraryURL, rootIsEmpty);
                    }
                    for (String it : b) {
                        boolean empty;
                        boolean bl = empty = !a.contains(it);
                        if (isCodeLibrary) {
                            this.putCode(it, libraryURL, libraryOriginalURL, empty);
                            continue;
                        }
                        this.putResources(it, libraryURL, empty);
                    }
                    continue;
                }
                log.warn((Object)("unable to find library " + library + ", path " + library.getPath()));
            }
            catch (Exception e) {
                log.error((Object)("an unexpected error has occurred while index library " + library), (Throwable)e);
            }
        }
    }

    private URL maybeJarUrl(URL url) throws MalformedURLException {
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            return url;
        }
        File file = IoUtil.url2file((URL)url);
        if (file == null || !file.isFile()) {
            return url;
        }
        String fileName = file.getName().toLowerCase(Locale.getDefault());
        if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
            return new URL("jar:" + IoUtil.file2url((File)file).toExternalForm() + "!/");
        }
        return url;
    }

    private URL getOriginalUrl(URL url) throws MalformedURLException {
        if (!"jar".equalsIgnoreCase(url.getProtocol())) {
            return url;
        }
        String plain = url.toExternalForm();
        int p = plain.indexOf("!/");
        plain = plain.substring(4, p);
        return new URL(plain);
    }

    private void putCode(String path, URL rootURL, URL libraryOriginalURL, boolean empty) throws MalformedURLException {
        String newPath = rootURL.getPath() + path;
        if (!newPath.endsWith("/")) {
            newPath = newPath + "/";
        }
        URL url = IndexPluginClassLoader.setURLPath(rootURL, newPath);
        if (!empty) {
            IndexPluginClassLoader.putToMap(this.codeIndex, path, new CodeInfo(path, rootURL, libraryOriginalURL));
            IndexPluginClassLoader.putToMap(this.resourcesParentIndex, path, url);
        }
        if (!"".equals(path) || !"jar".equalsIgnoreCase(url.getProtocol())) {
            IndexPluginClassLoader.putToMap(this.resourcesPathIndex, path, url);
        }
    }

    private void putResources(String path, URL rootURL, boolean empty) throws MalformedURLException {
        String newPath = rootURL.getPath() + path;
        if (!newPath.endsWith("/")) {
            newPath = newPath + "/";
        }
        URL url = IndexPluginClassLoader.setURLPath(rootURL, newPath);
        if (!empty) {
            IndexPluginClassLoader.putToMap(this.resourcesParentIndex, path, url);
        }
        if (!"".equals(path) || !"jar".equalsIgnoreCase(url.getProtocol())) {
            IndexPluginClassLoader.putToMap(this.resourcesPathIndex, path, url);
        }
    }

    private static <T> void putToMap(Map<String, List<T>> map, String key, T value) {
        List<T> list = map.get(key);
        if (null == list) {
            list = new ArrayList<T>();
            map.put(key, list);
        }
        list.add(value);
    }

    private static URL[] getUrls(PluginManager manager) {
        PluginRegistry registry = manager.getRegistry();
        LinkedList<URL> urls = new LinkedList<URL>();
        for (PluginDescriptor descr : registry.getPluginDescriptors()) {
            URL[] pluginURLs;
            for (URL url : pluginURLs = IndexPluginClassLoader.getUrls(manager, descr)) {
                urls.add(url);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static URL[] getUrls(PluginManager manager, PluginDescriptor descr) {
        LinkedList<URL> result = new LinkedList<URL>();
        for (Library lib : descr.getLibraries()) {
            result.add(manager.getPathResolver().resolvePath((Identity)lib, lib.getPath()));
        }
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Code URL's populated for plug-in " + descr + ":\r\n");
            for (Object e : result) {
                buf.append("\t");
                buf.append(e);
                buf.append("\r\n");
            }
            log.debug((Object)buf.toString());
        }
        return result.toArray(new URL[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getLibCacheFolder() {
        if (libCacheFolder != null) {
            return libCacheFolderInitialized ? libCacheFolder : null;
        }
        Class<IndexPluginClassLoader> clazz = IndexPluginClassLoader.class;
        synchronized (IndexPluginClassLoader.class) {
            libCacheFolder = new File(System.getProperty("java.io.tmpdir"), System.currentTimeMillis() + ".jpf-lib-cache");
            log.debug((Object)("libraries cache folder is " + libCacheFolder));
            File lockFile = new File(libCacheFolder, "lock");
            if (lockFile.exists()) {
                log.error((Object)("can't initialize libraries cache folder " + libCacheFolder + " as lock file indicates that it" + " is owned by another JPF instance"));
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            if (libCacheFolder.exists()) {
                IoUtil.emptyFolder((File)libCacheFolder);
            } else {
                libCacheFolder.mkdirs();
            }
            try {
                if (!lockFile.createNewFile()) {
                    log.error((Object)("can't create lock file in JPF libraries cache folder " + libCacheFolder));
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return null;
                }
            }
            catch (IOException ioe) {
                log.error((Object)("can't create lock file in JPF libraries cache folder " + libCacheFolder), (Throwable)ioe);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            lockFile.deleteOnExit();
            libCacheFolder.deleteOnExit();
            libCacheFolderInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return libCacheFolder;
        }
    }

    protected void pluginsSetChanged() {
    }

    protected String findLibrary(String name) {
        if (name == null || "".equals(name.trim())) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findLibrary(String): name=" + name + ", this=" + (Object)((Object)this)));
        }
        String libname = System.mapLibraryName(name);
        String result = null;
        PathResolver pathResolver = this.getPluginManager().getPathResolver();
        PluginRegistry registry = this.getPluginManager().getRegistry();
        block0: for (PluginDescriptor descr : registry.getPluginDescriptors()) {
            for (Library lib : descr.getLibraries()) {
                File libFile;
                if (lib.isCodeLibrary()) continue;
                URL libUrl = pathResolver.resolvePath((Identity)lib, lib.getPath() + libname);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findLibrary(String): trying URL " + libUrl));
                }
                if ((libFile = IoUtil.url2file((URL)libUrl)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("findLibrary(String): URL " + libUrl + " resolved as local file " + libFile));
                    }
                    if (!libFile.isFile()) continue;
                    result = libFile.getAbsolutePath();
                    continue block0;
                }
                String libraryCacheKey = libUrl.toExternalForm();
                libFile = this.libraryCache.get(libraryCacheKey);
                if (libFile != null) {
                    if (libFile.isFile()) {
                        result = libFile.getAbsolutePath();
                        continue block0;
                    }
                    this.libraryCache.remove(libraryCacheKey);
                }
                if (this.libraryCache.containsKey(libraryCacheKey)) continue block0;
                libFile = this.cacheLibrary(libUrl, libname, descr);
                if (libFile == null) continue;
                result = libFile.getAbsolutePath();
                continue block0;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findLibrary(String): name=" + name + ", libname=" + libname + ", result=" + result + ", this=" + (Object)((Object)this)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File cacheLibrary(URL libUrl, String libname, PluginDescriptor descr) {
        String libraryCacheKey = libUrl.toExternalForm();
        File result = this.libraryCache.get(libraryCacheKey);
        if (result != null) {
            return result;
        }
        try {
            File cacheFolder = IndexPluginClassLoader.getLibCacheFolder();
            if (cacheFolder == null) {
                throw new IOException("can't initialize libraries cache folder");
            }
            File libCachePluginFolder = new File(cacheFolder, descr.getUniqueId());
            if (!libCachePluginFolder.exists() && !libCachePluginFolder.mkdirs()) {
                throw new IOException("can't create cache folder " + libCachePluginFolder);
            }
            result = new File(libCachePluginFolder, libname);
            try (InputStream in = IoUtil.getResourceInputStream((URL)libUrl);
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(result));){
                IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)512);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("library " + libname + " successfully cached from URL " + libUrl + " and saved to local file " + result));
            }
        }
        catch (IOException ioe) {
            log.error((Object)("can't cache library " + libname + " from URL " + libUrl), (Throwable)ioe);
            result = null;
        }
        this.libraryCache.put(libraryCacheKey, result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        try (Loader loader = this.findIndexCode(path);){
            if (null == loader) {
                throw new ClassNotFoundException(name);
            }
            Class<?> clazz = this.defineClass(name, loader);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private Loader findIndexCode(String name) {
        int i;
        String parent;
        List<CodeInfo> parentList;
        String nameToLoad = name;
        if (".".equals(nameToLoad) || nameToLoad.endsWith("/.")) {
            nameToLoad = nameToLoad.substring(0, nameToLoad.length() - 1);
        }
        if (nameToLoad.endsWith("/")) {
            nameToLoad = nameToLoad.substring(0, nameToLoad.length() - 1);
        }
        if (null == (parentList = this.codeIndex.get(parent = (i = nameToLoad.lastIndexOf(47)) != -1 ? nameToLoad.substring(0, i) : ""))) {
            return null;
        }
        for (CodeInfo parentCodeInfo : parentList) {
            try {
                Loader loader = parentCodeInfo.getLoader(nameToLoad);
                try {
                    if (!loader.exists()) continue;
                    return loader;
                }
                catch (Throwable t) {
                    loader.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private Class<?> defineClass(String name, Loader loader) throws IOException {
        int i = name.lastIndexOf(46);
        URL codeSourceURL = loader.getCodeSourceURL();
        if (i != -1) {
            String pkgname = name.substring(0, i);
            this.definePackageInternal(pkgname, loader.getManifest(), codeSourceURL);
        }
        byte[] b = loader.getBytes();
        CodeSigner[] signers = loader.getCodeSigners();
        CodeSource cs = new CodeSource(codeSourceURL, signers);
        return this.defineClass(name, b, 0, b.length, cs);
    }

    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url != null) {
            return url;
        }
        return this.findResource2(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[]{super.getResources(name), this.findResources2(name)};
        return new CompoundEnumeration<URL>(tmp);
    }

    public URL findResource(String name) {
        return null;
    }

    public Enumeration<URL> findResources(String name) {
        return Collections.emptyEnumeration();
    }

    private URL findResource2(String name) {
        List<URL> list = this.findIndexResources(name, true);
        return !list.isEmpty() ? list.get(0) : null;
    }

    private Enumeration<URL> findResources2(String name) {
        return Collections.enumeration(this.findIndexResources(name, false));
    }

    private List<URL> findIndexResources(String name, boolean first) {
        List<URL> list;
        boolean cached;
        String nameToLoad = name;
        if (".".equals(nameToLoad) || nameToLoad.endsWith("/.")) {
            nameToLoad = nameToLoad.substring(0, nameToLoad.length() - 1);
        }
        if (nameToLoad.endsWith("/")) {
            nameToLoad = nameToLoad.substring(0, nameToLoad.length() - 1);
        }
        if ((cached = nameToLoad.startsWith("META-INF/")) && (list = this.resourceURLCache.get(nameToLoad)) != null) {
            return list;
        }
        list = this.resourcesPathIndex.get(nameToLoad);
        if (list != null) {
            return list;
        }
        int i = nameToLoad.lastIndexOf(47);
        String parent = i != -1 ? nameToLoad.substring(0, i) : "";
        List<URL> parentList = this.resourcesParentIndex.get(parent);
        if (parentList != null) {
            String nameToFind = nameToLoad.substring(i + 1);
            list = new ArrayList<URL>();
            for (URL parentURL : parentList) {
                try {
                    URL url = IndexPluginClassLoader.setURLPath(parentURL, parentURL.getPath() + nameToFind);
                    if (!this.checkURLExists(url)) continue;
                    list.add(url);
                    if (!first || cached) continue;
                    break;
                }
                catch (MalformedURLException malformedURLException) {
                }
            }
        }
        if (null == list || list.isEmpty()) {
            list = Collections.emptyList();
        }
        if (cached) {
            this.resourceURLCache.put(nameToLoad, list);
        }
        return list;
    }

    private boolean checkURLExists(URL url) {
        File file = IoUtil.url2file((URL)url);
        if (file != null) {
            return file.exists();
        }
        try {
            InputStream in = url.openConnection().getInputStream();
            in.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void definePackageInternal(String pkgname, Manifest man, URL url) {
        block5: {
            if (this.getAndVerifyPackage(pkgname, man, url) == null) {
                try {
                    if (man != null) {
                        this.definePackage(pkgname, man, url);
                    } else {
                        this.definePackage(pkgname, null, null, null, null, null, null, null);
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (this.getAndVerifyPackage(pkgname, man, url) != null) break block5;
                    throw new AssertionError((Object)("Cannot find package " + pkgname));
                }
            }
        }
    }

    private Package getAndVerifyPackage(String pkgname, Manifest man, URL url) {
        Package pkg = this.getPackage(pkgname);
        if (pkg != null) {
            if (pkg.isSealed()) {
                if (!pkg.isSealed(url)) {
                    throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                }
            } else if (man != null && this.isSealed(pkgname, man)) {
                throw new SecurityException("sealing violation: can't seal package " + pkgname + ": already loaded");
            }
        }
        return pkg;
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    static {
        ClassLoader.registerAsParallelCapable();
        libCacheFolderInitialized = false;
    }

    private static class CompoundEnumeration<E>
    implements Enumeration<E> {
        private Enumeration[] enums;
        private int index = 0;

        public CompoundEnumeration(Enumeration[] enums) {
            this.enums = enums;
        }

        private boolean next() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index] != null && this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public E nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }

    private static class JarLoader
    extends Loader {
        private final JarFile jar;
        private final JarEntry entry;

        public JarLoader(URL codeSourceURL, JarHolder jarHolder, String localURL) throws Exception {
            super(codeSourceURL);
            this.jar = jarHolder.getJar();
            this.entry = this.jar != null ? this.jar.getJarEntry(localURL) : null;
        }

        @Override
        public boolean exists() {
            return this.entry != null;
        }

        @Override
        public Manifest getManifest() throws IOException {
            return this.jar.getManifest();
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            return this.entry.getCodeSigners();
        }

        @Override
        public byte[] getBytes() throws IOException {
            try (InputStream in = this.jar.getInputStream(this.entry);){
                byte[] byArray = this.getBytes(in, (int)this.entry.getSize());
                return byArray;
            }
        }
    }

    private static class URLLoader
    extends Loader {
        private final URLConnection connection;
        private final InputStream in;

        public URLLoader(URL url, URL codeSourceURL) throws IOException {
            super(codeSourceURL);
            this.connection = url.openConnection();
            InputStream is = null;
            try {
                is = this.connection.getInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.in = is;
        }

        @Override
        public boolean exists() {
            return this.in != null;
        }

        @Override
        public byte[] getBytes() throws IOException {
            this.getBytes(this.in, this.connection.getContentLength());
            return null;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    private static class FileLoader
    extends Loader {
        private final Path file;

        public FileLoader(URL url, URL codeSourceURL) throws URISyntaxException {
            super(codeSourceURL);
            this.file = Paths.get(url.toURI());
        }

        @Override
        public boolean exists() {
            return Files.exists(this.file, new LinkOption[0]);
        }

        @Override
        public byte[] getBytes() throws IOException {
            return Files.readAllBytes(this.file);
        }
    }

    private static abstract class Loader
    implements Closeable {
        private final URL codeSourceURL;

        public Loader(URL codeSourceURL) {
            this.codeSourceURL = codeSourceURL;
        }

        @Override
        public void close() throws IOException {
        }

        public abstract boolean exists();

        public URL getCodeSourceURL() {
            return this.codeSourceURL;
        }

        public Manifest getManifest() throws IOException {
            return null;
        }

        public CodeSigner[] getCodeSigners() {
            return null;
        }

        public abstract byte[] getBytes() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] getBytes(InputStream in, int len) throws IOException {
            byte[] b;
            block20: {
                boolean isInterrupted = Thread.interrupted();
                try {
                    byte[] tmp;
                    if (len != -1) {
                        b = new byte[len];
                        while (len > 0) {
                            int n = 0;
                            try {
                                n = in.read(b, b.length - len, len);
                            }
                            catch (InterruptedIOException iioe) {
                                Thread.interrupted();
                                isInterrupted = true;
                            }
                            if (n == -1) {
                                throw new IOException("unexpected EOF");
                            }
                            len -= n;
                        }
                        break block20;
                    }
                    b = new byte[1024];
                    int total = 0;
                    while (true) {
                        len = 0;
                        try {
                            len = in.read(b, total, b.length - total);
                            if (len == -1) {
                                break;
                            }
                        }
                        catch (InterruptedIOException iioe) {
                            Thread.interrupted();
                            isInterrupted = true;
                        }
                        if ((total += len) < b.length) continue;
                        tmp = new byte[total * 2];
                        System.arraycopy(b, 0, tmp, 0, total);
                        b = tmp;
                    }
                    if (total != b.length) {
                        tmp = new byte[total];
                        System.arraycopy(b, 0, tmp, 0, total);
                        b = tmp;
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (InterruptedIOException iioe) {
                        isInterrupted = true;
                    }
                    catch (IOException iOException) {}
                    if (isInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return b;
        }
    }

    private static class JarHolder
    implements Closeable {
        private final URL codeSourceURL;
        public JarFile jar;
        public volatile boolean inited;

        public JarHolder(URL codeSourceURL) {
            this.codeSourceURL = codeSourceURL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JarFile getJar() throws URISyntaxException, IOException {
            if (this.inited) {
                return this.jar;
            }
            JarHolder jarHolder = this;
            synchronized (jarHolder) {
                if (this.inited) {
                    return this.jar;
                }
                Path path = Paths.get(this.codeSourceURL.toURI());
                this.jar = Files.exists(path, new LinkOption[0]) ? new JarFile(path.toString()) : null;
                this.inited = true;
                return this.jar;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.jar != null) {
                this.jar.close();
            }
        }
    }

    private static interface LoaderMaker {
        public Loader createLoader(String var1) throws IOException, Exception;
    }

    private class CodeInfo {
        private final LoaderMaker loaderMaker;

        public CodeInfo(String path, URL rootURL, URL codeSourceURL) {
            this.loaderMaker = this.createLoaderMaker(rootURL, codeSourceURL);
        }

        private LoaderMaker createLoaderMaker(final URL rootURL, final URL codeSourceURL) {
            String protocol = rootURL.getProtocol();
            if ("jar".equalsIgnoreCase(protocol)) {
                final JarHolder jarHolder = new JarHolder(codeSourceURL);
                IndexPluginClassLoader.this.closeable.add(jarHolder);
                return new LoaderMaker(){

                    @Override
                    public Loader createLoader(String localURL) throws Exception {
                        return new JarLoader(codeSourceURL, jarHolder, localURL);
                    }
                };
            }
            if ("file".equalsIgnoreCase(protocol)) {
                return new LoaderMaker(){

                    @Override
                    public Loader createLoader(String localPath) throws Exception {
                        URL url = IndexPluginClassLoader.setURLPath(rootURL, rootURL.getPath() + localPath);
                        return new FileLoader(url, codeSourceURL);
                    }
                };
            }
            return new LoaderMaker(){

                @Override
                public Loader createLoader(String localPath) throws IOException {
                    URL url = IndexPluginClassLoader.setURLPath(rootURL, rootURL.getPath() + localPath);
                    return new URLLoader(url, codeSourceURL);
                }
            };
        }

        public Loader getLoader(String localPath) throws Exception {
            return this.loaderMaker.createLoader(localPath);
        }
    }
}

