/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.bus.entity.handlers;

import com.gridnine.xtrip.client.fx.bus.entity.handlers.BusProductFXHelper;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusPanel;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusPanelController;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusPanelVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusParametersOwner;
import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileContractPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCommissionsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductValidationMessagesVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileVendorFinanceDocumentsDataPanelVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.bus.model.uidata.BusProductUIData;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusProductIndex;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class BusProductFXHandler
implements ProductFXHandler<BusProduct, BusProductIndex, BusProductUIData, Void> {
    public Class<BusProduct> getProductClass() {
        return BusProduct.class;
    }

    public Class<BusProductIndex> getProductIndexClass() {
        return BusProductIndex.class;
    }

    public String getDisplayName() {
        return ProductType.BUS.toString();
    }

    public BusProductUIData createUiData() {
        return new BusProductUIData();
    }

    public BusProduct createProduct() {
        return new BusProduct();
    }

    public BaseProductVM createVM(BusProduct product) {
        return new BookingFileProductBusPanelVM();
    }

    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductBusPanelVM)vm).getReservationUid();
    }

    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductBusPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        Reservation reservation;
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        BookingFileProductBusPanelVM productVM = new BookingFileProductBusPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.BUS.toString());
        MiscUtil.Pair<BusProduct, BusProductUIData> prototypeData = BusProductFXHelper.getPrototypeData();
        BusProduct product = (BusProduct)prototypeData.getFirst();
        BusProductUIData productSupplementData = (BusProductUIData)prototypeData.getSecond();
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        Reservation reservation2 = reservation = bookingFile.getReservations().size() > 0 ? (Reservation)bookingFile.getReservations().get(0) : new Reservation(reservationUid);
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, null);
            BookingFileProductBusPanel node = new BookingFileProductBusPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            BusProductFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductBusPanelController controller = new BookingFileProductBusPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductBusPanel bookingFileProductBusPanel = node;
            return bookingFileProductBusPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductBusPanel node = new BookingFileProductBusPanel(false);
        BusProductFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    public BusProduct getPreviousProduct(BusProduct product) {
        return product.getPreviousProduct();
    }

    public BusProduct getNextProduct(BusProduct product) {
        return product.getNextProduct();
    }

    public ProductStatus getProductStatus(BusProduct product) {
        return product.getStatus();
    }

    public void remove(BusProduct product) {
        BusProduct nextProduct;
        product.getReservation().getProducts().remove(product);
        BusProduct previousProduct = product.getPreviousProduct();
        if (previousProduct != null) {
            previousProduct.setNextProduct(null);
        }
        if ((nextProduct = product.getNextProduct()) != null) {
            nextProduct.setPreviousProduct(null);
        }
    }

    public StatisticalData getStatisticalData(BusProduct product) {
        return product.getStatisticalData();
    }

    public void newStatisticalData(BusProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    public Collection<Traveller> getTravellers(BusProduct product) {
        return product.getTravellers();
    }

    public void setAgent(BusProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    public ProductType getProductType(BusProduct product) {
        return ProductType.BUS;
    }

    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductBusParametersOwner paramsPane = ((BookingFileProductBusPanel)node).getGeneralNode().getOwnerParametersNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference)paramsPane.getAgencyNode().getValue(), (EntityReference)paramsPane.getSubagencyNode().getValue());
    }

    public void validate(String uid, Node node, List<Message> errors) {
        if (node instanceof BookingFileProductBusPanel) {
            BookingFileProductBusPanel panel = (BookingFileProductBusPanel)node;
            String systemNumber = panel.getGeneralNode().getBaseInformationNode().getSystemNumberNode().getValue();
            boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
            if (emptyPaymentType) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
            }
        }
    }

    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileProductBusPanel) {
            BookingFileProductBusPanel panel = (BookingFileProductBusPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData((BookingFileSpace)space, (String)uid, (Collection)statisticUdidsVMS, errors);
        }
    }

    public boolean isMultiTraveller() {
        return true;
    }

    public void toVM(BusProduct product, BusProductUIData uiData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodes = Arrays.asList(ReasonCodeType.REASON_CODE_DECLINED, ReasonCodeType.REASON_CODE_NO_HOTEL);
        BookingFileProductBusPanelVM parentVM = (BookingFileProductBusPanelVM)vm;
        parentVM.setReservationUid(product.getReservation().getUid());
        BusProductFXHelper.toVMParentParameters(product, parentVM);
        BusProductFXHelper.toVMParameters(product, uiData, parentVM.getGeneral(), parentVM.getStatuses());
        BusProductFXHelper.toVMSegments(product, parentVM.getSegments());
        BusProductFXHelper.toVMCost(product, parentVM.getCost());
        BusProductFXHelper.toVMAdditional(product, parentVM.getOtherParameters().getAdditional());
        GeneralProductFXHelper.toVMProductStatistic((StatisticalData)product.getStatisticalData(), (BaseProductUIData)uiData, reasonCodes, BusProduct.class, (BookingFileProductStatisticVM)parentVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)uiData, (BookingFileProductFopVM)parentVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)uiData, (BookingFileContractPanelVM)parentVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)uiData, (List)parentVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)uiData, (BookingFileVendorFinanceDocumentsDataPanelVM)parentVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)uiData, (BookingFileProductCommissionsVM)parentVM.getCommissions());
        GeneralProductFXHelper.toVMValidationMessages((List)product.getValidationMessages(), (String)product.getUid(), (BookingFileProductValidationMessagesVM)parentVM.getOtherParameters().getValidation());
    }

    public void fromVM(BaseProductVM vm, BusProduct product, BusProductUIData uiData) {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
        BookingFileProductBusPanelVM productVM = (BookingFileProductBusPanelVM)vm;
        BusProductFXHelper.fromVMParameters(productVM.getGeneral(), product, uiData, productVM.getStatuses());
        BusProductFXHelper.fromVMSegments(productVM.getSegments(), product);
        BusProductFXHelper.fromVMCost(productVM.getCost(), product);
        BusProductFXHelper.fromVMAdditional(productVM.getOtherParameters().getAdditional(), product);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, (BookingFileProductCommissionsVM)productVM.getCommissions(), (BaseProductUIData)uiData);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, (BookingFileProductFopVM)productVM.getFops(), (BaseProductUIData)uiData);
        GeneralProductFXHelper.fromVMProductContract((BookingFileContractPanelVM)productVM.getFops().getContract(), (BaseProductUIData)uiData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData((BookingFileVendorFinanceDocumentsDataPanelVM)productVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)uiData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic((BookingFile)product.getReservation().getBookingFile(), (BookingFileProductStatisticVM)productVM.getOtherParameters().getStatistic(), (StatisticalData)data, (BaseProductUIData)uiData);
    }
}

