/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.bus.entity.handlers;

import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusAdditionalParametersPanelVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusCostSumVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusCostVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusGeneralPanelVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusPanel;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusPanelVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusParametersBaseInformationVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusParametersOwnerVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusSegmentsAdditionalContainerVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusSegmentsTableVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusSegmentsVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusStatusesPaneVM;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.CustomVatContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.bus.model.uidata.BusProductUIData;
import com.gridnine.xtrip.common.fx.bus.rpc.BusProductPrototypeService;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.booking.bus.BusTax;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BusProductFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    private BusProductFXHelper() {
    }

    static void toVMParentParameters(BusProduct product, BookingFileProductBusPanelVM model) {
        model.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        model.setUid(product.getUid());
    }

    static void toVMParameters(BusProduct product, BusProductUIData uiData, BookingFileProductBusGeneralPanelVM model, BookingFileProductBusStatusesPaneVM statuses) {
        BusProductFXHelper.toVMInformationParameters(model.getBaseInformation(), product);
        BusProductFXHelper.toVMOwnerParameters(model.getOwnerParameters(), product, uiData);
        BusProductFXHelper.toVMControlStatusParameters(statuses, product, uiData);
    }

    private static void toVMInformationParameters(BookingFileProductBusParametersBaseInformationVM model, BusProduct product) {
        model.setProduct(ProductType.BUS.toString());
        model.setSystemNumber(product.getSystemNumber());
        model.setStatus(product.getStatus().toString());
        model.setOperationDate(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
    }

    private static void toVMOwnerParameters(BookingFileProductBusParametersOwnerVM model, BusProduct product, BusProductUIData productData) {
        model.setBlankOwner(product.getBlankOwner());
        model.setSupplier(productData.getSupplier());
        model.setAgency(productData.getAgency());
        model.setSubagency(productData.getSubagency());
        model.setSalesPoint(product.getSalesPoint());
        model.setAgent(product.getAgent());
        model.setTicketType(product.getTicketType());
        model.setPassengerType(product.getPassengerType());
        model.getTravellers().addAll(product.getTravellers());
        model.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        model.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
    }

    private static void toVMControlStatusParameters(BookingFileProductBusStatusesPaneVM model, BusProduct product, BusProductUIData productData) {
        model.setChecked(product.isChecked());
        model.setFinished(product.isCompleted());
        model.setHasErrors(productData.isHasErrors());
        model.setHasWarnings(productData.isHasWarnings());
        model.setRulesApplied(product.isContractRulesApplied());
    }

    static void toVMSegments(BusProduct product, BookingFileProductBusSegmentsVM model) {
        VMHelper.transfer((Collection)product.getSegments(), (Collection)model.getSegments(), res -> new BookingFileProductBusSegmentsTableVM(), (segment, result) -> {
            result.setSegmentModel(segment);
            result.setSegment(segment.getNumber());
            result.setDeparture(segment.getDeparture());
            result.setDepartureDate(DateUtils.asLocalDateTime((Date)segment.getDepartureDate()));
            result.setArrival(segment.getArrival());
            result.setArrivalDate(DateUtils.asLocalDateTime((Date)segment.getArrivalDate()));
            BookingFileProductBusSegmentsAdditionalContainerVM additionalVM = result.getSuperColumn().getContent().getAdditionalData();
            additionalVM.setPlaces(segment.getPlaces().stream().collect(Collectors.joining(", ")));
            additionalVM.setBrand(segment.getBrand());
            additionalVM.getServices().addAll(segment.getServices());
            additionalVM.setArrivalAddress(segment.getArrivalAddress());
            additionalVM.setDepartureAddress(segment.getDepartureAddress());
            additionalVM.setRouteLengthKm(segment.getRouteLengthKm());
            additionalVM.setWayTimeMinutes(segment.getWayTimeMinutes());
            additionalVM.setCarrier(segment.getCarrier());
            additionalVM.setAddInfo(segment.getAddInfo());
        });
    }

    static void toVMCost(BusProduct product, BookingFileProductBusCostVM model) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductBusCostSumVM sumVM = model.getSumCell();
        String currency = (String)MiscUtil.guarded((Object)product.getGdsCurrency(), (Object)Prefetched.getData().getEquivalentCurrency());
        if (product.getFare() != null) {
            sumVM.setTariffSum(BusProductFXHelper.getValue(product.getFare().getValue(), negate));
            sumVM.setTariffCurrency(product.getFare().getCurrency());
        }
        if (product.getEquivalentFare() != null) {
            sumVM.setEqTariffSum(BusProductFXHelper.getValue(product.getEquivalentFare(), negate));
            sumVM.setEqTariffCurrency(currency);
        }
        BigDecimal ndsValue = null;
        BigDecimal taxSum = null;
        BigDecimal taxVatSum = null;
        List taxes = product.getTaxes().stream().filter(item -> item.getEquivalentAmount() != null).collect(Collectors.toList());
        if (!taxes.isEmpty()) {
            taxSum = taxes.stream().map(BusTax::getEquivalentAmount).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
            sumVM.setTaxSum(BusProductFXHelper.getValue(taxSum, negate));
            sumVM.setTaxSumCurrency(currency);
            taxVatSum = taxes.stream().map(BusTax::getEquivalentVatValue).filter(Objects::nonNull).map(VatValue::getAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
            Double taxVatRate = taxes.stream().map(BusTax::getEquivalentVatValue).filter(Objects::nonNull).map(VatValue::getRate).filter(Objects::nonNull).findFirst().orElse(null);
            sumVM.getVatIncludedTaxSum().setVatAmount(BusProductFXHelper.getValue(taxVatSum, negate));
            sumVM.getVatIncludedTaxSum().setVatRate(taxVatRate);
        }
        if (product.getEquivalentFareVatValue() != null) {
            VatValue vatValue = product.getEquivalentFareVatValue();
            ndsValue = vatValue.getAmount();
            sumVM.getVatIncludedEqTariff().setVatAmount(BusProductFXHelper.getValue(vatValue.getAmount(), negate));
            sumVM.getVatIncludedEqTariff().setVatRate(vatValue.getRate());
        }
        sumVM.setPenaltySum(product.getPenalty());
        sumVM.setPenaltyCurrency(currency);
        BigDecimal fare = MiscUtil.guarded((BigDecimal)product.getEquivalentFare());
        if (negate) {
            if (product.getPenalty() == null) {
                product.setPenalty(BigDecimal.ZERO);
            }
            sumVM.setTotalSum(MiscUtil.sub((BigDecimal)fare, (BigDecimal[])new BigDecimal[]{product.getPenalty()}).negate());
        } else {
            sumVM.setTotalSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fare, taxSum}));
        }
        ndsValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{ndsValue, taxVatSum});
        sumVM.setVatIncludedTotal(BusProductFXHelper.getValue(ndsValue, negate));
        sumVM.setTotalCurrency(currency);
    }

    static void toVMAdditional(BusProduct product, BookingFileProductBusAdditionalParametersPanelVM model) {
        model.setComments(product.getComments());
    }

    static void fromVMParameters(BookingFileProductBusGeneralPanelVM model, BusProduct product, BusProductUIData uiData, BookingFileProductBusStatusesPaneVM statuses) {
        BusProductFXHelper.fromVMTicketInformationVM(model.getBaseInformation(), product, uiData);
        BusProductFXHelper.fromVMOwnerParameters(model.getOwnerParameters(), product, uiData);
        BusProductFXHelper.fromVMStatuses(statuses, product);
    }

    private static void fromVMTicketInformationVM(BookingFileProductBusParametersBaseInformationVM model, BusProduct product, BusProductUIData uiData) {
        product.setSystemNumber(model.getSystemNumber());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)model.getOperationDate()));
    }

    private static void fromVMOwnerParameters(BookingFileProductBusParametersOwnerVM model, BusProduct product, BusProductUIData productData) {
        product.setBlankOwner(model.getBlankOwner());
        productData.setSupplier(model.getSupplier());
        productData.setAgency(model.getAgency());
        productData.setSubagency(model.getSubagency());
        product.setSalesPoint(model.getSalesPoint());
        product.setAgent(model.getAgent());
        product.setTicketType(model.getTicketType());
        product.setPassengerType(model.getPassengerType());
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)model.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)model.getShipmentsDateSubagentValue()));
        List passengers = product.getTravellers();
        passengers.clear();
        model.getTravellers().forEach(tr -> {
            Traveller traveller;
            if (tr != null && (traveller = GeneralProductFXHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)tr.getUid())) != null) {
                passengers.add(traveller);
            }
        });
    }

    private static void fromVMStatuses(BookingFileProductBusStatusesPaneVM model, BusProduct product) {
        product.setChecked(model.isChecked());
        product.setCompleted(model.isFinished());
        product.setContractRulesApplied(model.isRulesApplied());
    }

    static void fromVMSegments(BookingFileProductBusSegmentsVM model, BusProduct product) {
        VMHelper.transfer((Collection)model.getSegments(), (Collection)product.getSegments(), res -> new BusSegment(), (segmentVM, segment) -> {
            segment.setNumber(segmentVM.getSegment());
            segment.setDeparture(segmentVM.getDeparture());
            segment.setDepartureDate(DateUtils.asDate((LocalDateTime)segmentVM.getDepartureDate()));
            segment.setArrival(segmentVM.getArrival());
            segment.setArrivalDate(DateUtils.asDate((LocalDateTime)segmentVM.getArrivalDate()));
            BookingFileProductBusSegmentsAdditionalContainerVM additionalVM = segmentVM.getSuperColumn().getContent().getAdditionalData();
            String places = additionalVM.getPlaces();
            if (places != null) {
                segment.getPlaces().clear();
                segment.getPlaces().addAll(Arrays.asList(places.split(", ")));
            }
            segment.setBrand(additionalVM.getBrand());
            segment.getServices().clear();
            segment.getServices().addAll(additionalVM.getServices());
            segment.setDepartureAddress(additionalVM.getDepartureAddress());
            segment.setArrivalAddress(additionalVM.getArrivalAddress());
            segment.setRouteLengthKm(additionalVM.getRouteLengthKm());
            segment.setWayTimeMinutes(additionalVM.getWayTimeMinutes());
            segment.setCarrier(additionalVM.getCarrier());
            segment.setAddInfo(additionalVM.getAddInfo());
        });
    }

    static void fromVMCost(BookingFileProductBusCostVM model, BusProduct product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductBusCostSumVM sumVM = model.getSumCell();
        if (product.getFare() == null) {
            product.setFare(new Money());
        }
        product.getFare().setValue((BigDecimal)MiscUtil.guarded((Object)BusProductFXHelper.getValue(sumVM.getTariffSum(), negate), (Object)BigDecimal.ZERO));
        product.getFare().setCurrency((String)MiscUtil.guarded((Object)sumVM.getTariffCurrency(), (Object)Prefetched.getData().getEquivalentCurrency()));
        product.setEquivalentFare((BigDecimal)MiscUtil.guarded((Object)BusProductFXHelper.getValue(sumVM.getEqTariffSum(), negate), (Object)product.getFare().getValue(), (Object[])new BigDecimal[]{BigDecimal.ZERO}));
        product.setGdsCurrency((String)MiscUtil.guarded((Object)sumVM.getEqTariffCurrency(), (Object)product.getFare().getCurrency(), (Object[])new String[]{Prefetched.getData().getEquivalentCurrency()}));
        if (product.getEquivalentFareVatValue() == null) {
            product.setEquivalentFareVatValue(new VatValue());
        }
        CustomVatContainerVM vatEq = sumVM.getVatIncludedEqTariff();
        product.getEquivalentFareVatValue().setRate(vatEq.getVatRate());
        product.getEquivalentFareVatValue().setAmount(BusProductFXHelper.getValue(vatEq.getVatAmount(), negate));
        product.setPenalty(sumVM.getPenaltySum());
        product.getTaxes().clear();
        if (sumVM.getTaxSum() != null) {
            BusTax tax = new BusTax();
            tax.setEquivalentAmount(sumVM.getTaxSum());
            if (sumVM.getVatIncludedTaxSum() != null) {
                tax.setEquivalentVatValue(new VatValue());
                tax.getEquivalentVatValue().setAmount(sumVM.getVatIncludedTaxSum().getVatAmount());
                tax.getEquivalentVatValue().setRate(sumVM.getVatIncludedTaxSum().getVatRate());
            }
            product.getTaxes().add(tax);
        }
    }

    static void fromVMAdditional(BookingFileProductBusAdditionalParametersPanelVM model, BusProduct product) {
        product.setComments(model.getComments());
    }

    public static MiscUtil.Pair<BusProduct, BusProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        BusProduct product = new BusProduct();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((BusProductPrototypeService)RpcServiceManager.get().getService(BusProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new BusProduct(), (Object)new BusProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductBusPanel node, BookingFileSpaceVM bookingFileVM) {
    }
}

