/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.bus.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusPanel;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy.CopyTask;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CommonRefundProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CopyProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MoveNextProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MovePrevProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RecalculateFOPProductAction;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;

public class BusProductActionsProvider
implements ProductActionsProvider {
    private List<TileAction<Node, BookingFileProductsFullPanel>> actions;

    public String getId() {
        return "bus-product-actions-provider";
    }

    public boolean isApplicableTo(Node productView) {
        return productView instanceof BookingFileProductBusPanel;
    }

    public List<TileAction<Node, BookingFileProductsFullPanel>> getAvailableActions() {
        if (this.actions != null) {
            return this.actions;
        }
        this.actions = Arrays.asList(new MovePrevProductAction<BusProduct>(){

            protected BaseProduct getPreviousProduct(BusProduct product) {
                return product.getPreviousProduct();
            }
        }, new MoveNextProductAction<BusProduct>(){

            protected BaseProduct getNextProduct(BusProduct product) {
                return product.getNextProduct();
            }
        }, new CommonRefundProductAction(), new RecalculateFOPProductAction(), new CopyProductAction<BusProduct>(){

            protected boolean isEnabled(BusProduct product) {
                if (product != null) {
                    ProductHandler productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
                    ProductStatus status = productHandler.getStatus((BaseProduct)product);
                    return status == ProductStatus.SELL || status == ProductStatus.BOOKING || status == ProductStatus.VOID_BOOKING || status == ProductStatus.VOID;
                }
                return false;
            }

            protected void execute(ProductActionContext<BusProduct> ctx) {
                CopyTask.showCopyDialog((EntityReference)ctx.getRootPane().getData().getContainer().toReference(), (String)((BusProduct)ctx.getSelectedProduct()).getUid(), (Node)ctx.getRootPane(), (ObservableMutex)ctx.getRootPane().getMutex());
            }
        });
        return this.actions;
    }
}

