/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.bus.entity.handlers.bookingfile.controllerInterceptors;

import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusCostSum;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusPanel;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusPanelController;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusPanelVM;
import com.gridnine.xtrip.client.fx.bus.model.booking.BookingFileProductBusParametersOwner;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.model.booking.CustomVatContainer;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BindingUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Set;

public class BookingFileBusProductPanelControllerInterceptor
extends ControllerInterceptor<BookingFileProductBusPanelVM, BookingFileProductBusPanelController> {
    protected Class<BookingFileProductBusPanelController> getControllerClass() {
        return BookingFileProductBusPanelController.class;
    }

    protected void beforeWriteData(BookingFileProductBusPanelController controller, BookingFileProductBusPanelVM model) {
        model.setProductType(BusProduct.class);
    }

    protected void onCreate(BookingFileProductBusPanelController controller) {
        BookingFileProductBusPanel view = controller.getView();
        BindingUtil.addYearValidationListener((DateTimeValueWidget)view.getGeneralNode().getBaseInformationNode().getOperationDateNode());
        GeneralProductFXHelper.configureStatusWidget((HyperlinkWidget)view.getGeneralNode().getBaseInformationNode().getStatusNode(), () -> ((BookingFileProductBusPanelController)controller).getData());
        view.getStatusesNode().getCheckedNode().setConverter(Converters.boolConverter((String)Messages.Checked, (String)Messages.Unchecked));
        view.getStatusesNode().getFinishedNode().setConverter(Converters.boolConverter((String)Messages.Finished, (String)Messages.Not_finished));
        view.getStatusesNode().getHasErrorsNode().setConverter(Converters.boolConverter((String)Messages.Has_errors, (String)Messages.Has_not_errors));
        view.getStatusesNode().getHasWarningsNode().setConverter(Converters.boolConverter((String)Messages.Has_warnings, (String)Messages.Has_not_warnings));
        view.getStatusesNode().getRulesAppliedNode().setConverter(Converters.boolConverter((String)Messages.Rules_applied, (String)Messages.Rules_not_applied));
        BookingFileProductBusParametersOwner ownerNode = view.getGeneralNode().getOwnerParametersNode();
        ownerNode.getAgencyNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ownerNode.getSubagencyNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ownerNode.getAgentNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgents);
        ownerNode.getSupplierNode().setListParametersSupplier(ControllerInterceptorsHelper.getAgenciesAndBlankOwnersMulti());
        BookingFileProductBusCostSum sumNode = view.getCostNode().getSumCellNode();
        CustomVatContainer vatContainer = sumNode.getVatIncludedEqTariffNode();
        ControllerInterceptorVatHelper.configureVatContainer((CustomVatContainer)vatContainer, (PriceValueWidget)sumNode.getEqTariffSumNode());
        vatContainer.getVatRateNode().setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
        CustomVatContainer vatPenaltyContainer = sumNode.getVatIncludedPenaltyNode();
        ControllerInterceptorVatHelper.configureVatContainer((CustomVatContainer)vatPenaltyContainer, (PriceValueWidget)sumNode.getPenaltySumNode());
        vatPenaltyContainer.getVatRateNode().setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
        sumNode.getTariffSumNode().valueProperty().addListener((observable, oldValue, newValue) -> {
            if (MiscUtil.equals((Object)sumNode.getEqTariffCurrencyNode().getValue(), (Object)sumNode.getTariffCurrencyNode().getValue(), (boolean)false)) {
                sumNode.getEqTariffSumNode().setValue((Number)newValue);
            }
        });
        CustomVatContainer vatTaxContainer = sumNode.getVatIncludedTaxSumNode();
        ControllerInterceptorVatHelper.configureVatContainer((CustomVatContainer)vatTaxContainer, (PriceValueWidget)sumNode.getTaxSumNode());
        vatTaxContainer.getVatRateNode().setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
    }

    protected void afterReadData(BookingFileProductBusPanelController controller, BookingFileProductBusPanelVM model) {
        String productStatus = model.getGeneral().getBaseInformation().getStatus();
        CustomVatContainer vatNode = controller.getView().getCostNode().getSumCellNode().getVatIncludedPenaltyNode();
        if (productStatus.equals(ProductStatus.SELL.toString())) {
            vatNode.getVatRateNode().getViewState().setNotEditable(true);
            vatNode.getVatAmountNode().getViewState().setNotEditable(true);
        } else {
            vatNode.getVatRateNode().getViewState().setNotEditable(false);
            vatNode.getVatAmountNode().getViewState().setNotEditable(false);
        }
        controller.getData().getBookingFile().getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> TextUtil.isSame((String)product.getUid(), (String)controller.getData().getUid())).findFirst().ifPresent(baseProduct -> {
            BusProduct product = (BusProduct)baseProduct;
            boolean isHiddenFineCell = (product.getPreviousProduct() == null || !product.getPreviousProduct().getStatus().equals((Object)ProductStatus.EXCHANGE) || !product.getStatus().equals((Object)ProductStatus.SELL)) && !product.getStatus().equals((Object)ProductStatus.REFUND);
            BookingFileProductBusCostSum costSum = controller.getView().getCostNode().getSumCellNode();
            costSum.getPenaltySumCell().setHidden(isHiddenFineCell);
            costSum.getPenaltyCaptionCell().setHidden(isHiddenFineCell);
            costSum.getPenaltyCurrencyCell().setHidden(isHiddenFineCell);
            costSum.getVatIncludedPenaltyCell().setHidden(isHiddenFineCell);
        });
    }

    protected void enforceDataAcl(BookingFileProductBusPanelController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        String uid = controller.getView().getProperties().get((Object)"model-uid").toString();
        String productClientShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId());
        boolean productClientShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productClientShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getShipmentsDateValueNode().getViewState().setAclNotEditable(!productClientShipmentsDateEditGranted);
        String productSubagentShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId());
        boolean productSubagentShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagentShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getShipmentsDateSubagentValueNode().getViewState().setAclNotEditable(!productSubagentShipmentsDateEditGranted);
    }
}

