/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.transfers.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripTicketInfoPane;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.transfer.BookingFileProductTransferXtripPanelControllerInterceptor;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;

public class BookingFileProductTransferPanelControllerInterceptor
extends BookingFileProductTransferXtripPanelControllerInterceptor {
    protected void onCreate(BookingFileProductTransferXtripPanelController controller) {
        super.onCreate(controller);
        this.configureVat(controller.getView());
    }

    protected void afterReadData(BookingFileProductTransferXtripPanelController controller, BookingFileProductTransferXtripPanelVM model) {
        super.afterReadData(controller, model);
        TransferType transferTypeValue = controller.getGeneral().getTicketInfo().getTransferTypeValue();
        this.switchTransferFieldsHidden(controller.getView(), TransferType.RENT == transferTypeValue);
    }

    private void configureVat(BookingFileProductTransferXtripPanel view) {
        TableWidget tableTransferAdditional = view.getAdditionalServicesNode();
        tableTransferAdditional.addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            ComboBoxWidget vatRateWidget = (ComboBoxWidget)tableTransferAdditional.getColumn("vatRate").getWidget(ind.intValue());
            PriceValueWidget vatAmountWidget = (PriceValueWidget)tableTransferAdditional.getColumn("vat").getWidget(ind.intValue());
            PriceValueWidget sourcePriceWidget = (PriceValueWidget)tableTransferAdditional.getColumn("amount").getWidget(ind.intValue());
            vatRateWidget.setItemsSupplier(ControllerInterceptorVatHelper.getVatHotelsSupplier());
            ControllerInterceptorVatHelper.configureVatWidgets((ComboBoxWidget)vatRateWidget, (PriceValueWidget)vatAmountWidget, (PriceValueWidget)sourcePriceWidget);
        });
    }

    private void switchTransferFieldsHidden(BookingFileProductTransferXtripPanel view, boolean hidden) {
        BookingFileProductTransferXtripTicketInfoPane ticketInfoNode = view.getGeneralNode().getTicketInfoNode();
        ticketInfoNode.getEndAddressValueCell().setHidden(hidden);
        ticketInfoNode.getEndAddressCaptionCell().setHidden(hidden);
        ticketInfoNode.getEndCityCaptionCell().setHidden(hidden);
        ticketInfoNode.getEndCityValueCell().setHidden(hidden);
        ticketInfoNode.getEndCountryCaptionCell().setHidden(hidden);
        ticketInfoNode.getEndCountryValueCell().setHidden(hidden);
        ticketInfoNode.getEndTypeCaptionCell().setHidden(hidden);
        ticketInfoNode.getEndTypeValueCell().setHidden(hidden);
        ticketInfoNode.getSubAddressesCaptionCell().setHidden(hidden);
        ticketInfoNode.getSubAddressesValueCell().setHidden(hidden);
        view.getAdditionalServicesNode().setVisible(!hidden);
    }
}

