/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.helper;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import java.util.Iterator;
import java.util.List;

public class FlightSegmentIterator
implements Iterator<FlightSegment> {
    private final Iterator<FlightSegmentTariff> fstItr;
    private Iterator<FlightSegment> fsItr;
    private FlightSegment nextSegment;

    public FlightSegmentIterator(Flight flight) {
        this(flight.getSegmentTariffs());
    }

    public FlightSegmentIterator(List<FlightSegmentTariff> fstList) {
        this.fstItr = fstList.iterator();
        if (!this.fstItr.hasNext()) {
            throw new IllegalArgumentException("No flight segments");
        }
        this.fsItr = this.fstItr.next().getSegments().iterator();
        this.nextSegment = this.getNextFlightSegment();
    }

    @Override
    public boolean hasNext() {
        return this.nextSegment != null;
    }

    private FlightSegment getNextFlightSegment() {
        if (this.fsItr.hasNext()) {
            return this.fsItr.next();
        }
        while (this.fstItr.hasNext()) {
            this.fsItr = this.fstItr.next().getSegments().iterator();
            if (!this.fsItr.hasNext()) continue;
            return this.fsItr.next();
        }
        return null;
    }

    @Override
    public FlightSegment next() {
        FlightSegment result = this.nextSegment;
        this.nextSegment = this.getNextFlightSegment();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Flight segment removal is not supported");
    }
}

