/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.rules;

import com.gridnine.xtrip.common.gds.model.BaseAirGdsAccount;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.TravelDocType;
import com.gridnine.xtrip.common.gds.rules.FlightActionsProvider;
import com.gridnine.xtrip.common.gds.rules.GDSParametersActionsProvider;
import com.gridnine.xtrip.common.gds.rules.GdsAviaTripartiteContractActionsProvider;
import com.gridnine.xtrip.common.gds.rules.InitGdsParametersActionsProvider;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.gds.rules.TickettingParametersActionsProvider;
import com.gridnine.xtrip.common.gds.rules.ValueTypes;
import com.gridnine.xtrip.common.gds.rules.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.TripartiteDiscountDocument;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.CommissionActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.ExcludeFromResultFlagProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public enum Actions implements RuleAction
{
    APPLICABLE_GDS{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            GdsName[] gds = (GdsName[])value;
            if (gds.length == 0) {
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_ApplicableGDS_info, (Object[])new Object[]{CollectionUtil.collectionToString(Arrays.asList(gds), (String)", ", (boolean)false)}));
        }

        public String getDisplayName() {
            return L10n.get((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_ApplicableGDS);
        }

        public String getRendererId() {
            return ValueTypes.GDS_LIST.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"applicable-GDS\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            if (!(proxy.getActionSet() instanceof InitGdsParametersActionsProvider)) {
                return;
            }
            InitGdsParametersActionsProvider as = (InitGdsParametersActionsProvider)proxy.getActionSet();
            for (GdsName gds : (GdsName[])value) {
                as.addApplicableGDS(gds.name());
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    APPLICABLE_GDS_ACCOUNTS{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            Collection accounts = (Collection)value;
            if (accounts.size() == 0) {
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_ApplicableGDSAccounts_info, (Object[])new Object[]{CollectionUtil.collectionToString((Iterable)accounts, (String)", ", (boolean)false)}));
        }

        public String getDisplayName() {
            return L10n.get((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_ApplicableGDSAccounts);
        }

        public String getRendererId() {
            return ValueTypes.GDS_ACCOUNT_LIST.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"applicable-GDS-accounts\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            for (EntityReference gdsAcc : (Collection)value) {
                as.addApplicableGDSAccount((EntityReference<BaseAirGdsAccount>)gdsAcc);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    USE_GDS_ACCOUNT{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            EntityReference account = (EntityReference)value;
            buf.append(L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_GDSAccount_info, (Object[])new Object[]{account.toString()}));
        }

        public String getDisplayName() {
            return L10n.get((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_GDSAccount);
        }

        public String getRendererId() {
            return BaseGdsAccount.class.getName();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"use-GDS-account\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            as.setUsedGdsAccount((EntityReference<BaseAirGdsAccount>)((EntityReference)value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    CHARTER_GDS_ACCOUNT{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            EntityReference account = (EntityReference)value;
            buf.append(L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_CharterGDSAccount_info, (Object[])new Object[]{account.toString()}));
        }

        public String getDisplayName() {
            return L10n.get((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_CharterGDSAccount);
        }

        public String getRendererId() {
            return BaseGdsAccount.class.getName();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"set-charter-GDS-account\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            as.setCharterGdsAccount((EntityReference<BaseAirGdsAccount>)((EntityReference)value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    GDS_ACCOUNT{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432 {0}", (Object[])new Object[]{value}));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"gds-account\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            if (!(proxy.getActionSet() instanceof InitGdsParametersActionsProvider)) {
                return;
            }
            InitGdsParametersActionsProvider as = (InitGdsParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setGdsAccount((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    SABRE_EMULATOR_GDS_ACCOUNT{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            EntityReference account = (EntityReference)value;
            buf.append(L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_SabreEmulatorGDSAccount_info, (Object[])new Object[]{account.toString()}));
        }

        public String getDisplayName() {
            return L10n.get((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_SabreEmulatorGDSAccount);
        }

        public String getRendererId() {
            return BaseGdsAccount.class.getName();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"set-sabre-emulator-GDS-account\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            as.setSabreEmulatorGdsAccount((EntityReference<BaseAirGdsAccount>)((EntityReference)value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    GDS_PASSWORD{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432 *****");
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"gds-password\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            if (!(proxy.getActionSet() instanceof InitGdsParametersActionsProvider)) {
                return;
            }
            InitGdsParametersActionsProvider as = (InitGdsParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setGdsPassword((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    BOOKING_PCC{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432 {0}", (Object[])new Object[]{value}));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"booking-PCC\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setBookingPCC((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    BOOKING_PCC_REF{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f";
        }

        public String getRendererId() {
            return ValueTypes.PCC_REF.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432 {0}", (Object[])new Object[]{value}));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "booking-pcc-ref";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            as.setBookingPCCRef((NestedEntityReference<SalesPoint, Pcc>)((NestedEntityReference)value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    SSR{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_Ssr_displayName);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)L10n.get((String)Messages.RuleAction_Ssr_info), (Object[])new Object[]{RulesHelper.toString((Object)value)}));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.PRODUCT_COMMISSION.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "ssr-" + value;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            if (!(proxy.getActionSet() instanceof FlightActionsProvider)) {
                return;
            }
            FlightActionsProvider as = (FlightActionsProvider)proxy.getActionSet();
            as.addSSR((String)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    SSR_3D{

        public String getDisplayName() {
            return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c SSR_3D";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c SSR_3D {0}", (Object[])new Object[]{RulesHelper.toString((Object)value)}));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.PRODUCT_COMMISSION.getId(), com.gridnine.xtrip.common.model.rules.standard.Targets.AVIA_SUBSIDIZED.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name() + value;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            if (proxy.getActionSet() instanceof GdsAviaTripartiteContractActionsProvider) {
                GdsAviaTripartiteContractActionsProvider as = (GdsAviaTripartiteContractActionsProvider)proxy.getActionSet();
                as.addSSR((String)value);
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    TRIPARTITE_DISCOUNT_DOCUMENT{

        public String getDisplayName() {
            return "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0430 \u043b\u044c\u0433\u043e\u0442\u0443";
        }

        public String getRendererId() {
            return ValueTypes.TRIPARTITE_DISCOUNT_DOCUMENT.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            TripartiteDiscountDocument doc = (TripartiteDiscountDocument)value;
            buf.append(L10n.replace((String)"\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0430 \u043b\u044c\u0433\u043e\u0442\u0443 {0} {1}", (Object[])new Object[]{doc.getCode(), doc.getNumber()}));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.PRODUCT_COMMISSION.getId(), com.gridnine.xtrip.common.model.rules.standard.Targets.AVIA_SUBSIDIZED.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            if (proxy.getActionSet() instanceof GdsAviaTripartiteContractActionsProvider) {
                GdsAviaTripartiteContractActionsProvider as = (GdsAviaTripartiteContractActionsProvider)proxy.getActionSet();
                as.setTripartiteDiscountDocument((TripartiteDiscountDocument)value);
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }
    }
    ,
    PREFERRED_AIRLINES{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0430/\u043a";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0430/\u043a \u0432 {0}", (Object[])new Object[]{RulesHelper.toString((Object)value)}));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"preferred-airlines\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            for (String code : RulesHelper.toStringCollection((Object)value)) {
                if (TextUtil.isBlank((String)code)) continue;
                as.addPreferredAirline(code.trim());
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCLUDE_FROM_RESULT{

        public String getDisplayName() {
            return "\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u043f\u043e\u0438\u0441\u043a\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            if (((Boolean)value).booleanValue()) {
                buf.append("\u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u043f\u043e\u0438\u0441\u043a\u0430");
            } else {
                buf.append("\u041d\u0415 \u0438\u0441\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u043f\u043e\u0438\u0441\u043a\u0430");
            }
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"exclude-from-result\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            ExcludeFromResultFlagProvider as = (ExcludeFromResultFlagProvider)proxy.getActionSet();
            as.setExcludeFromResult(!Boolean.FALSE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    AUTO_TICKETING{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            if (((Boolean)value).booleanValue()) {
                buf.append("\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0430 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430");
            } else {
                buf.append("\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0430 \u041d\u0415 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430");
            }
        }

        public String getDisplayName() {
            return "\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"auto-ticketing\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            TickettingParametersActionsProvider as = (TickettingParametersActionsProvider)proxy.getActionSet();
            as.setAutoTicketingEnabled(!Boolean.FALSE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    SUBSIDIZED_TARIFF{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            if (((Boolean)value).booleanValue()) {
                buf.append("\u0442\u0430\u0440\u0438\u0444 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439");
            } else {
                buf.append("\u0442\u0430\u0440\u0438\u0444 \u041d\u0415 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439");
            }
        }

        public String getDisplayName() {
            return "\u0422\u0430\u0440\u0438\u0444 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.getId();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            TickettingParametersActionsProvider as = (TickettingParametersActionsProvider)proxy.getActionSet();
            as.setSubsidizedTariff(!Boolean.FALSE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    VALIDATING_CARRIER{

        public void buildInfo(StringBuilder buf, Object value) {
            if (TextUtil.isBlank((String)((String)value))) {
                return;
            }
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430 \u0432 {0}", (Object[])new Object[]{value}));
        }

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"validating-carrier\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            TickettingParametersActionsProvider as = (TickettingParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setValidatingCarrier((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    BLANK_OWNER{

        public void buildInfo(StringBuilder buf, Object value) {
            if (TextUtil.isBlank((String)((String)value))) {
                return;
            }
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u043e\u0432 \u0432 {0}", (Object[])new Object[]{value}));
        }

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u043e\u0432";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"blank-owner\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TickettingParametersActionsProvider as = (TickettingParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setBlankOwner((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    SABRE_PRINTER_TYPE{

        public void buildInfo(StringBuilder buf, Object value) {
            if (TextUtil.isBlank((String)((String)value))) {
                return;
            }
            buf.append(L10n.replace((String)L10n.get((String)Messages.RuleAction_SabrePrinterType_info), (Object[])new Object[]{value}));
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_SabrePrinterType_displayName);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"sabre-printer-type\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TickettingParametersActionsProvider as = (TickettingParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setSabrePrinterType((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    TICKETING_PCC{

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u0432 {0}", (Object[])new Object[]{value}));
        }

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0438";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"ticketing-pcc\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            TickettingParametersActionsProvider as = (TickettingParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setTicketingPCC((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    TICKETING_PCC_REF{

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u0432 {0}", (Object[])new Object[]{value}));
        }

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0438";
        }

        public String getRendererId() {
            return ValueTypes.PCC_REF.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "ticketing-pcc-ref";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            as.setTicketingPCCRef((NestedEntityReference<SalesPoint, Pcc>)((NestedEntityReference)value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    SEARCH_PCC{

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0432 {0}", (Object[])new Object[]{value}));
        }

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"search-pcc\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setSearchPCC((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    SEARCH_PCC_REF{

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0432 {0}", (Object[])new Object[]{value}));
        }

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PCC \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430";
        }

        public String getRendererId() {
            return ValueTypes.PCC_REF.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "search-pcc-ref";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            as.setSearchPCCRef((NestedEntityReference<SalesPoint, Pcc>)((NestedEntityReference)value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    FOP_CODE{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043e\u0434 \u0444\u043e\u0440\u043c\u044b \u043e\u043f\u043b\u0430\u0442\u044b {0}", (Object[])new Object[]{value}));
        }

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043e\u0434 \u0444\u043e\u0440\u043c\u044b \u043e\u043f\u043b\u0430\u0442\u044b";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"fop-replacement-code\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            TickettingParametersActionsProvider as = (TickettingParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setFopReplacementCode((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    ENDORSEMENT{

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c ED {0}", (Object[])new Object[]{value}));
        }

        public String getDisplayName() {
            return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c ED";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"endorsement\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            TickettingParametersActionsProvider as = (TickettingParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setEndorsement((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    ISSUING_URGENT{

        public String getDisplayName() {
            return "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u0441\u0440\u043e\u0447\u043d\u0430\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            if (((Boolean)value).booleanValue()) {
                buf.append("\u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u0441\u0440\u043e\u0447\u043d\u0430\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0430");
            } else {
                buf.append("\u0441\u0440\u043e\u0447\u043d\u0430\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "issuing-urgent";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TickettingParametersActionsProvider as = (TickettingParametersActionsProvider)proxy.getActionSet();
            as.setIssuingUrgent(!Boolean.FALSE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }
    }
    ,
    GDS_ADDRESS{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0430\u0434\u0440\u0435\u0441 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            String str = (String)value;
            buf.append("\u0410\u0434\u0440\u0435\u0441 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432 " + str);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"gds-address\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            if (!(proxy.getActionSet() instanceof InitGdsParametersActionsProvider)) {
                return;
            }
            InitGdsParametersActionsProvider as = (InitGdsParametersActionsProvider)proxy.getActionSet();
            String str = (String)value;
            boolean hasScheme = str.contains("://");
            if (!hasScheme) {
                str = "http://" + str;
            }
            URL url = new URL(str);
            as.setGdsAddress(url);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }
    }
    ,
    DEAFULT_NAMESPACE{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c Namespace";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            String str = (String)value;
            buf.append("Namespace \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432 " + str);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"default-namespace\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            if (!(proxy.getActionSet() instanceof InitGdsParametersActionsProvider)) {
                return;
            }
            InitGdsParametersActionsProvider as = (InitGdsParametersActionsProvider)proxy.getActionSet();
            as.setDefaultNamespace((String)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }
    }
    ,
    TEST_MODE{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            if (((Boolean)value).booleanValue()) {
                buf.append("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f");
            } else {
                buf.append("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0431\u043e\u0435\u0432\u043e\u0439 \u0434\u043e\u0441\u0442\u0443\u043f");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"test-mode\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            if (!(proxy.getActionSet() instanceof InitGdsParametersActionsProvider)) {
                return;
            }
            InitGdsParametersActionsProvider as = (InitGdsParametersActionsProvider)proxy.getActionSet();
            as.setTestMode(Boolean.TRUE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }
    }
    ,
    TRAVEL_DOC_TYPE{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0438\u043f \u041c\u041a";
        }

        public String getRendererId() {
            return ValueTypes.TRAVEL_DOC_TYPE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            buf.append("\u0422\u0438\u043f \u041c\u041a \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432 " + value.toString());
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"mk-type\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            as.setTravelDocType((TravelDocType)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }
    }
    ,
    AUTO_GET_COUPON_STATUS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_AutoGetCouponAction_displayName);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder info, Object object) {
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider actionSet = (CommissionActionsProvider)proxy.getActionSet();
            actionSet.setAutoGetCouponStatus(Boolean.TRUE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"auto-get-coupon-status\"";
        }
    }
    ,
    SET_GDS_ACCOUNT{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_SetGdsAccount_displayName);
        }

        public String getRendererId() {
            return ValueTypes.GDS_ACCOUNT.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder info, Object object) {
            if (object != null) {
                info.append(L10n.replace((String)L10n.get((String)Messages.RuleAction_SetGdsAccount_info), (Object[])new Object[]{object}));
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider actionSet = (CommissionActionsProvider)proxy.getActionSet();
            actionSet.setGdsAccount((EntityReference)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"set-gds-account\"";
        }
    }
    ,
    ADD_REMARK{

        public String getDisplayName() {
            return "\u0432\u043d\u0435\u0441\u0442\u0438 \u0440\u0435\u043c\u0430\u0440\u043a\u0443 \u0432 Sabre";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0432\u043d\u0435\u0441\u0442\u0438 \u0440\u0435\u043c\u0430\u0440\u043a\u0443 \u0432 Sabre {0}", (Object[])new Object[]{RulesHelper.toString((Object)value)}));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "Remark-" + value;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            GDSParametersActionsProvider as = (GDSParametersActionsProvider)proxy.getActionSet();
            if (!StringUtils.isEmpty((String)((String)value))) {
                as.addRemark((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

