/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.stat;

import com.gridnine.xtrip.common.gds.stat.RouteItem;
import com.gridnine.xtrip.common.gds.stat.SeatsItem;
import com.gridnine.xtrip.common.gds.stat.TraceDataItem;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class GDSStatEntry
extends BaseAsset {
    private static final long serialVersionUID = 271092952138365586L;
    private Date date;
    private String user;
    private String session;
    private GdsName gds;
    private final List<String> transactionNames = new ArrayList<String>();
    private long timing;
    private String pnr;
    private SalesContext salesContext;
    private DictionaryReference<Airline> airline;
    private final List<RouteItem> route = new ArrayList<RouteItem>();
    private final List<SeatsItem> seats = new ArrayList<SeatsItem>();
    private Message error;
    private final List<TraceDataItem> trace = new ArrayList<TraceDataItem>();

    public GDSStatEntry() {
    }

    public GDSStatEntry(String uid) {
        super(uid);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date value) {
        this.date = value;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String value) {
        this.user = value;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String value) {
        this.session = value;
    }

    public GdsName getGds() {
        return this.gds;
    }

    public void setGds(GdsName value) {
        this.gds = value;
    }

    public List<String> getTransactionNames() {
        return this.transactionNames;
    }

    public String getPnr() {
        return this.pnr;
    }

    public void setPnr(String value) {
        this.pnr = value;
    }

    public SalesContext getSalesContext() {
        return this.salesContext;
    }

    public void setSalesContext(SalesContext value) {
        this.salesContext = value;
    }

    public DictionaryReference<Airline> getAirline() {
        return this.airline;
    }

    public void setAirline(DictionaryReference<Airline> value) {
        this.airline = value;
    }

    public List<RouteItem> getRoute() {
        return this.route;
    }

    public List<SeatsItem> getSeats() {
        return this.seats;
    }

    public long getTiming() {
        return this.timing;
    }

    public void setTiming(long value) {
        this.timing = value;
    }

    public Message getError() {
        return this.error;
    }

    public void setError(Message value) {
        this.error = value;
    }

    public List<TraceDataItem> getTrace() {
        return this.trace;
    }

    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeDate((Element)elm, (String)"date", (Date)this.date);
        XHelper.writeObject((Element)elm, (String)"error", (Object)this.error);
        XHelper.writeEnum((Element)elm, (String)"gds", (Enum)this.gds);
        XHelper.writeString((Element)elm, (String)"pnr", (String)this.pnr);
        for (RouteItem routeItem : this.route) {
            XHelper.writeObject((Element)elm, (String)"route/item", (Object)routeItem);
        }
        XHelper.writeObject((Element)elm, (String)"salesContext", (Object)this.salesContext);
        XHelper.writeObject((Element)elm, (String)"airline", this.airline);
        for (SeatsItem seatsItem : this.seats) {
            XHelper.writeObject((Element)elm, (String)"seats/item", (Object)seatsItem);
        }
        XHelper.writeString((Element)elm, (String)"session", (String)this.session);
        XHelper.writeLong((Element)elm, (String)"timing", (long)this.timing);
        for (TraceDataItem traceDataItem : this.trace) {
            XHelper.writeObject((Element)elm, (String)"trace/item", (Object)traceDataItem);
        }
        for (String string : this.transactionNames) {
            XHelper.writeString((Element)elm, (String)"transactionNames/item", (String)string);
        }
        XHelper.writeString((Element)elm, (String)"user", (String)this.user);
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"date", (Date)this.date);
        XSHelper.writeObject((XMLStreamWriter)writer, (String)"error", (Object)this.error);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"gds", (Enum)this.gds);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"pnr", (String)this.pnr);
        if (!this.route.isEmpty()) {
            writer.writeStartElement("route");
            for (RouteItem routeItem : this.route) {
                XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", (Object)routeItem);
            }
            writer.writeEndElement();
        }
        XSHelper.writeObject((XMLStreamWriter)writer, (String)"salesContext", (Object)this.salesContext);
        XSHelper.writeObject((XMLStreamWriter)writer, (String)"airline", this.airline);
        if (!this.seats.isEmpty()) {
            writer.writeStartElement("seats");
            for (SeatsItem seatsItem : this.seats) {
                XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", (Object)seatsItem);
            }
            writer.writeEndElement();
        }
        XSHelper.writeString((XMLStreamWriter)writer, (String)"session", (String)this.session);
        XSHelper.writeLong((XMLStreamWriter)writer, (String)"timing", (long)this.timing);
        if (!this.trace.isEmpty()) {
            writer.writeStartElement("trace");
            for (TraceDataItem traceDataItem : this.trace) {
                XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", (Object)traceDataItem);
            }
            writer.writeEndElement();
        }
        if (!this.transactionNames.isEmpty()) {
            writer.writeStartElement("transactionNames");
            for (String string : this.transactionNames) {
                XSHelper.writeString((XMLStreamWriter)writer, (String)"item", (String)string);
            }
            writer.writeEndElement();
        }
        XSHelper.writeString((XMLStreamWriter)writer, (String)"user", (String)this.user);
    }

    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        GDSStatEntry source = (GDSStatEntry)sourceAsset;
        this.date = XCloneHelper.cloneDate((Date)source.date);
        this.error = (Message)XCloneHelper.cloneObject((Object)source.error, (boolean)newUids, uids);
        this.gds = source.gds;
        this.pnr = source.pnr;
        this.route.clear();
        this.route.addAll(XCloneHelper.cloneCollection(source.route, (boolean)newUids, uids));
        this.salesContext = (SalesContext)XCloneHelper.cloneObject((Object)source.salesContext, (boolean)newUids, uids);
        this.airline = (DictionaryReference)XCloneHelper.cloneObject(source.airline, (boolean)newUids, uids);
        this.seats.clear();
        this.seats.addAll(XCloneHelper.cloneCollection(source.seats, (boolean)newUids, uids));
        this.session = source.session;
        this.timing = source.timing;
        this.trace.clear();
        this.trace.addAll(XCloneHelper.cloneCollection(source.trace, (boolean)newUids, uids));
        this.transactionNames.clear();
        this.transactionNames.addAll(XCloneHelper.cloneCollection(source.transactionNames, (boolean)newUids, uids));
        this.user = source.user;
    }

    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.date = XHelper.readDate((Element)elm, (String)"date");
        this.error = (Message)XHelper.readObject((Element)elm, (String)"error");
        this.gds = (GdsName)XHelper.readEnum((Element)elm, (String)"gds", GdsName.class);
        this.pnr = XHelper.readString((Element)elm, (String)"pnr");
        this.route.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"route/item")) {
            this.route.add((RouteItem)XHelper.readObject((Element)itemElm, (String)"."));
        }
        this.salesContext = (SalesContext)XHelper.readObject((Element)elm, (String)"salesContext");
        this.airline = (DictionaryReference)XHelper.readObject((Element)elm, (String)"airline");
        this.seats.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"seats/item")) {
            this.seats.add((SeatsItem)XHelper.readObject((Element)itemElm, (String)"."));
        }
        this.session = XHelper.readString((Element)elm, (String)"session");
        this.timing = XHelper.readLong((Element)elm, (String)"timing", (long)0L);
        this.trace.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"trace/item")) {
            this.trace.add((TraceDataItem)XHelper.readObject((Element)itemElm, (String)"."));
        }
        this.transactionNames.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"transactionNames/item")) {
            this.transactionNames.add(XHelper.readString((Element)itemElm, (String)"."));
        }
        this.user = XHelper.readString((Element)elm, (String)"user");
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("date".equals(tagName)) {
            this.date = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("error".equals(tagName)) {
            this.error = (Message)XSHelper.readObject((XMLStreamReader)reader);
            return true;
        }
        if ("gds".equals(tagName)) {
            this.gds = (GdsName)XSHelper.readEnum((XMLStreamReader)reader, GdsName.class);
            return true;
        }
        if ("pnr".equals(tagName)) {
            this.pnr = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("route".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    this.route.add((RouteItem)XSHelper.readObject((XMLStreamReader)reader));
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        if ("salesContext".equals(tagName)) {
            this.salesContext = (SalesContext)XSHelper.readObject((XMLStreamReader)reader);
            return true;
        }
        if ("airline".equals(tagName)) {
            this.airline = (DictionaryReference)XSHelper.readObject((XMLStreamReader)reader);
            return true;
        }
        if ("seats".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    this.seats.add((SeatsItem)XSHelper.readObject((XMLStreamReader)reader));
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        if ("session".equals(tagName)) {
            this.session = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("timing".equals(tagName)) {
            this.timing = XSHelper.readLong((XMLStreamReader)reader, (long)0L);
            return true;
        }
        if ("trace".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    this.trace.add((TraceDataItem)XSHelper.readObject((XMLStreamReader)reader));
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        if ("transactionNames".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    this.transactionNames.add(XSHelper.readString((XMLStreamReader)reader));
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        if ("user".equals(tagName)) {
            this.user = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        return false;
    }

    public static enum Property {
        entryDate,
        entryUser,
        entrySession,
        gds,
        transactionNames,
        timing,
        pnr,
        agencyUid,
        agentUid,
        corporateClientUid,
        customerUid,
        salesPointUid,
        airline,
        routeLocations,
        passengerTypes,
        errorMessage;

    }
}

