/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.trace;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocumentPart;
import com.gridnine.xtrip.common.gds.model.GdsTracingSearchItem;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GdsTracingHelper {
    private static final Logger log = LoggerFactory.getLogger(GdsTracingHelper.class);
    private static ThreadLocal<TracingContext> contexts = new ThreadLocal();

    public static void startNewDocument(String documentName, String user) {
        contexts.set(new TracingContext(documentName, user));
    }

    public static void startNewDocumentPart(String partName) {
        TracingContext context = contexts.get();
        if (context == null || !context.active) {
            return;
        }
        context.flightsData = new LinkedHashMap<Flight, StringBuilder>();
        context.globalLogic = new StringBuilder();
        context.partName = partName;
    }

    public static void finishDocumentPart() {
        TracingContext context = contexts.get();
        if (context == null || !context.active) {
            return;
        }
        GdsTracingDocumentPart part = new GdsTracingDocumentPart();
        com.gridnine.xtrip.common.midoffice.helper.GdsTracingHelper.setGlobalData((GdsTracingDocumentPart)part, (String)context.globalLogic.toString());
        part.setName(context.partName);
        for (Map.Entry<Flight, StringBuilder> item : context.flightsData.entrySet()) {
            Flight flight = item.getKey();
            GdsTracingSearchItem ti = new GdsTracingSearchItem();
            ti.setSource((BaseEntity)flight);
            ti.setTitle(GdsTracingHelper.flightToString(flight));
            com.gridnine.xtrip.common.midoffice.helper.GdsTracingHelper.setData((GdsTracingSearchItem)ti, (String)item.getValue().toString());
            part.getVariants().add(ti);
        }
        context.document.getParts().add(part);
        context.flightsData = null;
        context.globalLogic = null;
        context.partName = null;
    }

    private static String flightToString(Flight flight) {
        if (flight == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (FlightSegment seg : FlightHelper.getSegments(flight)) {
            if (result.length() > 0) {
                result.append('-');
            }
            result.append(seg.getAirline().getCode()).append(seg.getFlightNumber());
        }
        for (SeatPreferences sp : flight.getSeats()) {
            result.append('[');
            result.append(sp.getPassengerType().getCode());
            result.append(": ");
            boolean first = true;
            for (FlightSegment fs : FlightHelper.getSegments(flight)) {
                if (first) {
                    first = false;
                } else {
                    result.append('|');
                }
                Optional<FareInfo> optFareInfo = fs.getFareInfos().stream().filter(fi -> fi.getPassengerType().equals((Object)sp.getPassengerType())).findAny();
                if (optFareInfo.isPresent()) {
                    result.append(optFareInfo.get().getFareBasis());
                    continue;
                }
                result.append("(not found)");
            }
            result.append(']');
        }
        return result.toString();
    }

    public static void traceGlobalLogic(MessageType type, String message) {
        TracingContext context = contexts.get();
        if (context == null || !context.active) {
            return;
        }
        context.globalLogic.append(String.format("\n%s: %s", type, message));
    }

    public static void traceFlightLogic(MessageType type, Flight flight, String message) {
        TracingContext context = contexts.get();
        if (context == null || !context.active) {
            return;
        }
        StringBuilder sb = context.flightsData.get(flight);
        if (sb == null) {
            sb = new StringBuilder();
            context.flightsData.put(flight, sb);
        }
        sb.append(String.format("\n%s: %s", type, message));
    }

    public static boolean isRulesTracingEnabled() {
        return contexts.get() != null && GdsTracingHelper.contexts.get().traceRules;
    }

    public static boolean isRequestTracingEnabled() {
        return contexts.get() != null && GdsTracingHelper.contexts.get().traceSearchRequests;
    }

    public static void finishDocument() {
        TracingContext context = contexts.get();
        if (context == null || !context.active) {
            return;
        }
        try {
            if (context.document == null) {
                return;
            }
            EntityStorage.get().save(EntityContainer.create((BaseEntity)context.document), false);
        }
        catch (Throwable e) {
            log.error("unable to trace document", e);
        }
        finally {
            contexts.set(null);
        }
    }

    private GdsTracingHelper() {
    }

    public static String getCompoundKey(String loginName) {
        return CommonHelper.getCompoundKey((String)loginName);
    }

    static final class TracingContext {
        boolean active;
        boolean traceRules;
        boolean traceSearchRequests;
        GdsTracingDocument document;
        StringBuilder globalLogic;
        Map<Flight, StringBuilder> flightsData;
        String partName;

        TracingContext(String documentName, String user) {
            String compoundKey = GdsTracingHelper.getCompoundKey(user);
            EntityContainer ctr = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)compoundKey);
            if (ctr == null) {
                return;
            }
            GdsTracingSettings ett = (GdsTracingSettings)ctr.getEntity();
            this.active = ett.isActive();
            this.traceRules = ett.isSaveRulesTraces();
            this.traceSearchRequests = ett.isSaveSearchTraces();
            if (this.active) {
                this.document = new GdsTracingDocument();
                this.document.setName(documentName);
                this.document.setSettings(ctr.toReference());
                this.document.setCreated(new Date());
            }
        }
    }
}

