/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.actions.dialogs.AddAttachmentsToProductDialog;
import com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.handlers.BaseIssueHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.RequestForHotelBookingIssue;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class AddAttachmentsToProductAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 63.0;
    }

    public String getName(RootEntityPane<?, ?> context) {
        return "\u041f\u0440\u0438\u043b\u043e\u0436\u0438\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043a \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0443";
    }

    public String getDescription(RootEntityPane<?, ?> context) {
        return "\u041f\u0440\u0438\u043b\u043e\u0436\u0438\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043a \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0443";
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        EntityContainer container;
        DataTransferPackage data = context.getData();
        if (data != null && (container = data.getContainer()) != null) {
            RequestForHotelBookingIssue issue = (RequestForHotelBookingIssue)container.getEntity();
            return issue.getPosts().stream().anyMatch(post -> !post.getAttachments().isEmpty());
        }
        return false;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && RequestForHotelBookingIssue.class.isAssignableFrom(context.getEntityHandler().getEntityClass()) && ((BaseIssueHandler)context.getEntityHandler()).isPostAvailable();
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        EntityContainer container = context.getData().getContainer();
        BaseIssue issue = (BaseIssue)container.getEntity();
        EntityReference bookingRef = issue.getBooking();
        if (bookingRef != null) {
            Notifications.get().submitTask(() -> {
                EntityContainer bookingCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), bookingRef);
                if (bookingCtr != null) {
                    BookingFile booking = (BookingFile)bookingCtr.getEntity();
                    List hotelProducts = BookingHelper.getProductsList((BookingFile)booking, HotelProduct.class);
                    List<EntityReference<Document>> attachments = issue.getPosts().stream().flatMap(post -> post.getAttachments().stream()).collect(Collectors.toList());
                    new AddAttachmentsToProductDialog(source, (EntityContainer<BookingFile>)bookingCtr, hotelProducts, attachments).showDialog();
                }
            }, context.getMutex());
        }
    }

    public String getId() {
        return "add-attachments-to-product";
    }
}

