/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.actions.dialogs;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class AddPostDialog {
    private final Control source;
    private final BiConsumer<Post, Boolean> callback;

    public AddPostDialog(Control source, EntityContainer<BaseIssue> container, BiConsumer<Post, Boolean> callback) {
        this.source = source;
        this.callback = callback;
    }

    public void showDialog() {
        FxUtil.submitToFxThread(this::show);
    }

    private void show() {
        CardsContainer cardsContainer = new CardsContainer();
        GridContainer generalContainer = new GridContainer(3);
        TextAreaWidget commentWidget = new TextAreaWidget(false);
        commentWidget.setMinHeight(100.0);
        commentWidget.setWrapText(true);
        GridCell commentCell = new GridCell("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", (Node)commentWidget);
        commentCell.setColSpan(Integer.MAX_VALUE);
        generalContainer.getCells().add((Object)commentCell);
        CheckBoxWidget isAssignWidget = new CheckBoxWidget(false);
        isAssignWidget.setText("\u041d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u043c");
        isAssignWidget.setSelected(true);
        GridCell isAssignCell = new GridCell("\u041e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439", (Node)isAssignWidget);
        isAssignCell.setColSpan(Integer.MAX_VALUE);
        generalContainer.getCells().add((Object)isAssignCell);
        cardsContainer.getCards().add((Object)new Card("main", UiCardsContainer.Style.STATIC, "\u041e\u0441\u043d\u043e\u0432\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", (Node)generalContainer));
        this.createDialog(cardsContainer, generalContainer, commentWidget, isAssignWidget);
    }

    protected void createDialog(CardsContainer cardsContainer, GridContainer generalContainer, TextAreaWidget commentWidget, CheckBoxWidget isAssignWidget) {
        Dialog dialog = new Dialog().setTitle("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f").setBody((Node)cardsContainer).setAutoClose(false).setExpandToParent(true);
        dialog.setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", () -> {
            String postText = commentWidget.getValue();
            if (TextUtil.isBlank((String)postText)) {
                GridCell messageCell = new GridCell((Node)MessagePane.error((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
                messageCell.setColSpan(3);
                generalContainer.getCells().add(0, (Object)messageCell);
                Notifications.get().getScheduler().schedule(() -> FxUtil.submitToFxThread(() -> generalContainer.getCells().remove((Object)messageCell)), 5L, TimeUnit.SECONDS);
            } else {
                Post post = new Post();
                post.setContent(postText);
                post.setDateCreated(new Date());
                post.setClient(false);
                this.callback.accept(post, isAssignWidget.isSelected());
                dialog.close();
            }
        }).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).show((Node)this.source);
    }

    private Card<?> getCardById(CardsContainer cardsContainer, String cardId) {
        return cardsContainer.getCards().stream().filter(card -> cardId.equals(card.getId())).findFirst().orElse(null);
    }
}

