/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.tasks;

import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.List;

public class AddAttachmentsToProductTask
extends ClientTask {
    private final EntityContainer<BookingFile> bookingFile;
    private final String productUid;
    private final List<EntityReference<Document>> attachments;

    public AddAttachmentsToProductTask(EntityContainer<BookingFile> bookingFile, String productUid, List<EntityReference<Document>> attachments) {
        this.bookingFile = bookingFile;
        this.productUid = productUid;
        this.attachments = attachments;
    }

    protected void execute() throws Exception {
        for (EntityReference<Document> docRef : this.attachments) {
            EntityContainer docCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), docRef);
            Document doc = (Document)XCloneHelper.clone((XCloneable)docCtr.getEntity(), (boolean)true);
            doc.setOwner(this.bookingFile.toReference());
            doc.setNavigationKey(this.productUid);
            Notifications.get().submitTask(() -> ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), EntityContainer.create((BaseEntity)doc), null, true), Messages.Saving);
        }
    }

    protected String getTitle() {
        return com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages.AddAttachmentsToProduct;
    }
}

