/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentSpace;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpMiscService;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDocument;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Scene;
import javafx.scene.control.Control;

public class CreateShipmentReconciliationReportAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 33.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.getEditor() instanceof ShipmentSpace && context.isLastVersion() && Prefetched.getData().isShipmentReconciliationReportEnabled();
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        Notifications.get().enqueueAsyncTask((ClientTask)new CreateShipmentReconciliationReportTask((EntityReference<Shipment>)dtp.getContainer().toReference(), context.getEditor().getScene()));
    }

    public String getId() {
        return "create-shipment-reconciliation-report";
    }

    static class CreateShipmentReconciliationReportTask
    extends ClientTask {
        private final EntityReference<Shipment> shipment;
        private final Scene scene;

        public CreateShipmentReconciliationReportTask(EntityReference<Shipment> shipment, Scene scene) {
            this.shipment = shipment;
            this.scene = scene;
        }

        protected void execute() throws Exception {
            IndexBasedTemplateReportDocument document = ((IbecorpMiscService)RpcServiceManager.get().getService(IbecorpMiscService.class)).getShipmentReconciliationReport(ServiceInvocationContext.get(), this.shipment);
            List<Message> errorMessages = document.getMessages().stream().filter(it -> it.getType() == MessageType.ERROR).collect(Collectors.toList());
            if (!errorMessages.isEmpty()) {
                Notifications.get().showMessages(errorMessages.toArray(new Message[errorMessages.size()]));
                throw Xeption.forEndUser((String)"\u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043e\u0442\u0447\u0435\u0442\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0438 \u043e\u0448\u0438\u0431\u043a\u0438", (Object[])new Object[0]);
            }
            byte[] content = document.getFile().getContent();
            String fileName = document.getFile().getName();
            File file = new File(Environment.getTempFolder(), fileName);
            FxUtil.saveToFile((File)file, (byte[])content);
            FxUtil.openFile((File)file);
        }

        protected String getTitle() {
            return Messages.CreatingReconciliationReport;
        }
    }
}

