/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.actions.fiscal;

import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.entity.actions.fiscal.IbeBookingFileFiscalPayPreviewDialog;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileFiscalSelectFopsPayContainer;
import com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal.BookingFileFiscalPaySelectFopsDialog;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpModelService;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class IbeBookingFileFiscalPaySelectFopsDialog
extends BookingFileFiscalPaySelectFopsDialog {
    private boolean hideOnlineReceiptSelector;
    private BookingFileFiscalSelectFopsPayContainer body;

    IbeBookingFileFiscalPaySelectFopsDialog(Control source) {
        super(source);
    }

    protected void showSelectFopsDialog(Map<BaseProduct, List<GeneralProductFop>> productToFops, List<NestedEntityReference<BookingFile, BaseProduct>> productsReferences, List<String> selectedProductUids) throws Exception {
        HashSet reservations = new HashSet();
        HashSet paymentTypes = new HashSet();
        productToFops.forEach((product, fops) -> {
            reservations.add(Objects.requireNonNull(product.getReservation(), "Missing reservation"));
            paymentTypes.addAll(fops.stream().map(Fop::getType).collect(Collectors.toSet()));
        });
        Notifications.get().submitTask(() -> {
            List settings = ((IbecorpModelService)RpcServiceManager.get().getService(IbecorpModelService.class)).findAtolSettings(ServiceInvocationContext.get(), (Collection)reservations);
            this.hideOnlineReceiptSelector = settings.isEmpty() || paymentTypes.contains(PaymentType.CASH);
            FxUtil.waitForFxThread(() -> super.showSelectFopsDialog(productToFops, productsReferences, selectedProductUids));
        }, Messages.Notifications_getting_data);
    }

    protected BookingFileFiscalSelectFopsPayContainer createBody() {
        this.body = super.createBody();
        this.body.getOnlineReceiptCell().setHidden(this.hideOnlineReceiptSelector);
        return this.body;
    }

    protected List<GeneralProductFop> filterProductFops(List<GeneralProductFop> source, ProductStatus status) {
        Map availablePaymentTypes = Prefetched.getData().getFiscalSettings().getAvailablePaymentTypes();
        return source.stream().filter(fop -> !(fop.getType() != PaymentType.CASH && fop.getType() != PaymentType.ELECTRONIC && fop.getType() != PaymentType.TICKET && !fop.getType().name().contains("CARD") && !availablePaymentTypes.containsKey(fop.getType()) || status != ProductStatus.VOID && fop.getOperationDate() != null || MiscUtil.isZero((BigDecimal)fop.getEquivalentAmount(), (boolean)true))).sorted(Comparator.comparing(GeneralProductHelper::isPaymentFop).reversed()).collect(Collectors.toList());
    }

    protected ReceiptServiceType getReceiptServiceType() {
        return this.body.getOnlineReceiptNode().getValue() ? ReceiptServiceType.ATOL_ONLINE : ReceiptServiceType.ATOL_FISCAL_DEVICE;
    }

    protected IbeBookingFileFiscalPayPreviewDialog createFiscalPreviewDialog(Control source) {
        return new IbeBookingFileFiscalPayPreviewDialog(source, this.getReceiptServiceType());
    }
}

