/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.booking;

import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.EntityIndexDataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.QueryDataViewHandler;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingCorrespondenceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IssueService;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;

public class BookingFileSpaceIbeControllerInterceptor
extends ControllerInterceptor<BookingFileSpaceVM, BookingFileSpaceController> {
    protected Class<BookingFileSpaceController> getControllerClass() {
        return BookingFileSpaceController.class;
    }

    protected void onCreate(BookingFileSpaceController controller) {
        this.hideTiles(controller);
        this.configureCorrespondenceTile(controller);
    }

    private void hideTiles(BookingFileSpaceController controller) {
        if (!AppConfigHelper.isIbeEnabled()) {
            controller.getView().getHiddenTiles().add((Object)controller.getView().getCustomerIbeTile());
        }
    }

    private void configureCorrespondenceTile(BookingFileSpaceController controller) {
        Tile correspondenceTile = controller.getView().getCorrespondenceIbeTile();
        ValueHolder correspondenceLoaded = new ValueHolder((Object)Boolean.FALSE);
        correspondenceTile.expandedProperty().addListener((obj, o, expanded) -> {
            correspondenceTile.getActions().clear();
            if (expanded.booleanValue()) {
                correspondenceTile.getActions().add((Object)CorrespondenceTileActions.CREATE_ISSUE);
                if (!((Boolean)correspondenceLoaded.get()).booleanValue()) {
                    this.reloadCorrespondenceData(controller);
                    correspondenceLoaded.set((Object)Boolean.TRUE);
                }
            }
        });
        ((DataViewWidget)correspondenceTile.getFullNode()).getTableView().setActionHandler((TableActionHandler)new TableActionHandler<BookingCorrespondenceVM>(){

            public boolean isActive(TableColumn<BookingCorrespondenceVM, ?> column, BookingCorrespondenceVM item) {
                return false;
            }

            public void onAction(TableColumn<BookingCorrespondenceVM, ?> column, BookingCorrespondenceVM item) {
                if ("navigate".equals(column.getId())) {
                    RootEntityEditingService.navigateTo((EntityReference)item.getIssueReference());
                }
            }
        });
        ((DataViewWidget)correspondenceTile.getFullNode()).setDefaultActionHandler(() -> {
            BookingCorrespondenceVM item = (BookingCorrespondenceVM)((DataViewWidget)correspondenceTile.getFullNode()).getTableView().getSelectionModel().getSelectedItem();
            if (item != null) {
                RootEntityEditingService.navigateTo((EntityReference)item.getIssueReference());
            }
        });
    }

    protected void afterReadData(BookingFileSpaceController controller, BookingFileSpaceVM model) {
        ((DataViewWidget)controller.getView().getCorrespondenceIbeTile().getFullNode()).setHandler(this.getCorrespondenceHandler(model.getOverview().getOverviewPanel().getBookingNumber()));
        if (controller.getView().getCorrespondenceIbeTile().isExpanded()) {
            this.reloadCorrespondenceData(controller);
        }
    }

    private QueryDataViewHandler<BookingCorrespondenceVM> getCorrespondenceHandler(String bookingNumber) {
        EntityIndexDataViewHandler handler = new EntityIndexDataViewHandler(IssueIndex.class, idx -> {
            BookingCorrespondenceVM result = new BookingCorrespondenceVM();
            result.setIssueReference(idx.getSource());
            result.setTitle(idx.getTitle());
            result.setNumber(idx.getNumber());
            result.setType(idx.getType() == null ? null : idx.getType().toString());
            result.setTotalPosts(String.valueOf(idx.getTotalPosts()));
            return result;
        });
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)IssueIndex.Property.bookingNumber.name(), (Object)bookingNumber));
        handler.setQuery(query);
        return handler;
    }

    private void reloadCorrespondenceData(BookingFileSpaceController controller) {
        DataTransferPackage data = RootEntityPane.lookup((Node)controller.getView()).getData();
        if (data != null && data.getContainer() != null) {
            ((DataViewWidget)controller.getView().getCorrespondenceIbeTile().getFullNode()).reloadData();
        }
    }

    private static enum CorrespondenceTileActions implements TileAction<Node, DataViewWidget<BookingCorrespondenceVM>>
    {
        CREATE_ISSUE{

            public String getName(Tile<Node, DataViewWidget<BookingCorrespondenceVM>> tile) {
                return "\u041d\u043e\u0432\u0430\u044f \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u043a\u0430";
            }

            public String getDescription(Tile<Node, DataViewWidget<BookingCorrespondenceVM>> tile) {
                return "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u043a\u0443 \u043f\u043e \u044d\u0442\u043e\u043c\u0443 \u0437\u0430\u043a\u0430\u0437\u0443";
            }

            public double getWeight() {
                return 1.0;
            }

            public boolean isEnabled(Tile<Node, DataViewWidget<BookingCorrespondenceVM>> tile) {
                RootEntityPane rep = RootEntityPane.lookup((Node)tile.getFullNode());
                return rep != null && rep.getData() != null && rep.getData().getContainer() != null && rep.getMode() != EditingMode.CREATE;
            }

            public AclQuery getACLQuery(Tile<Node, DataViewWidget<BookingCorrespondenceVM>> tile) {
                return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), BaseIssue.class.getName()).build();
            }

            public void execute(Control source, Tile<Node, DataViewWidget<BookingCorrespondenceVM>> tile, boolean alt) {
                EntityContainer ctr = RootEntityPane.lookup((Node)tile.getFullNode()).getData().getContainer();
                Notifications.get().submitTask(() -> {
                    EntityReference issueRef = ((IssueService)RpcServiceManager.get().getService(IssueService.class)).createIssue(ServiceInvocationContext.get(), ctr.toReference());
                    FxUtil.waitForFxThread(() -> {
                        RootEntityEditingService.get().open(issueRef, true);
                        ((DataViewWidget)tile.getFullNode()).reloadData();
                    });
                }, "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u043a\u0438 \u043f\u043e \u0437\u0430\u043a\u0430\u0437\u0443 " + ctr.getEntity());
            }
        };

    }
}

