/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.booking;

import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.booking.AddressFilter;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerContactsEmailVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerContactsGridPanelVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerKeyContactPanelVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerMainPanelVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.ContactPhonesTableVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.KeyContact;
import com.gridnine.xtrip.common.model.profile.Passport;
import java.util.Collection;
import java.util.List;

class CustomerTileHelper {
    CustomerTileHelper() {
    }

    static void toVM(BookingFileCustomerPanelVM vm, Customer model) {
        if (model != null) {
            CustomerTileHelper.mainToVM(vm.getMain(), model);
            if (model.getCommunications() != null) {
                CustomerTileHelper.communicationsToVM(vm.getCommunications(), model.getCommunications());
            }
            if (model.getKeyContact() != null) {
                BookingFileCustomerKeyContactPanelVM keyContactPanelVM = vm.getKeyContact();
                keyContactPanelVM.setEmail(model.getKeyContact().getMail());
                keyContactPanelVM.setPhone(model.getKeyContact().getPhone());
                keyContactPanelVM.setProfile(model.getKeyContact().getProfile());
            }
        }
    }

    static void fromVM(BookingFileCustomerPanelVM vm, Customer model, BookingFileUIData supplement) {
        CustomerTileHelper.mainFromVM(vm.getMain(), model);
        if (model.getPassport() == null) {
            model.setPassport(new Passport());
        }
        CustomerTileHelper.communicationsFromVM(vm.getCommunications(), model.getCommunications());
        KeyContact keyContact = new KeyContact();
        if (vm.getKeyContact() != null) {
            keyContact.setProfile(vm.getKeyContact().getProfile());
            keyContact.setMail(vm.getKeyContact().getEmail());
            keyContact.setPhone(vm.getKeyContact().getPhone());
            model.setKeyContact(keyContact);
        }
    }

    private static void mainToVM(BookingFileCustomerMainPanelVM vm, Customer model) {
        vm.setName(model.getName());
        vm.setProfile(model.getProfile());
    }

    private static void communicationsToVM(BookingFileCustomerContactsGridPanelVM vm, List<Communication> model) {
        AddressFilter filtered = new AddressFilter(model);
        List<Communication> web = filtered.getWeb();
        List<Communication> phone = filtered.getPhone();
        VMHelper.transfer(web, (Collection)vm.getEmail(), res -> new BookingFileCustomerContactsEmailVM(), (mod, modVM) -> {
            modVM.setAddress(mod.getSense());
            modVM.setNotes(mod.getRemarks());
            modVM.setType(mod.getType());
        });
        VMHelper.transfer(phone, (Collection)vm.getPhone(), res -> new ContactPhonesTableVM(), (mod, modVM) -> {
            modVM.setCityCode(mod.getCityCode());
            modVM.setCountryCode(mod.getCountryCode());
            modVM.setInternalNumber(mod.getInternalNumber());
            modVM.setPhoneNumber(mod.getSense());
            modVM.setNotes(mod.getRemarks());
            modVM.setType(mod.getType());
        });
    }

    private static void mainFromVM(BookingFileCustomerMainPanelVM vm, Customer model) {
        model.setName(vm.getName());
        model.setProfile(vm.getProfile());
    }

    private static void communicationsFromVM(BookingFileCustomerContactsGridPanelVM vm, List<Communication> model) {
        AddressFilter filtered = new AddressFilter(model);
        List<Communication> web = filtered.getWeb();
        VMHelper.transfer((Collection)vm.getEmail(), web, res -> new Communication(), (modVM, mod) -> {
            mod.setSense(modVM.getAddress());
            mod.setRemarks(modVM.getNotes());
            mod.setType(modVM.getType());
        });
        List<Communication> phone = filtered.getPhone();
        VMHelper.transfer((Collection)vm.getPhone(), phone, res -> new Communication(), (modVM, mod) -> {
            mod.setCityCode(modVM.getCityCode());
            mod.setCountryCode(modVM.getCountryCode());
            mod.setInternalNumber(modVM.getInternalNumber());
            mod.setSense(modVM.getPhoneNumber());
            mod.setRemarks(modVM.getNotes());
            mod.setType(modVM.getType());
        });
        model.clear();
        model.addAll(web);
        model.addAll(phone);
    }
}

