/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.booking;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullContainerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullRecordLocatorInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullSystemInfoVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.ReservationsTileHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationGdsNameInfo;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;

public class ReservationHelper {
    static void toVM(BookingFile bookingFile, BookingFileReservationsFullPanelVM full) {
        VMHelper.transfer((Collection)bookingFile.getReservations(), (Collection)full.getContent(), reservation -> new BookingFileReservationsFullContainerVM(), (res, resVM) -> {
            resVM.getGeneralParameters().setPqTimeLimit(DateUtils.asLocalDateTime((Date)res.getPqTimeLimit()));
            resVM.getGdsNameInfo().setOnlineGdsAccount(res.getGdsNameInfo().getOnlineGdsAccount());
            resVM.getGeneralParameters().setStaus(res.getStatus());
            resVM.getGdsNameInfo().getSystemInfos().clear();
            ReservationGdsNameInfo gdsNameInfo = res.getGdsNameInfo();
            gdsNameInfo.getSystemInfos().forEach(si -> {
                BookingFileReservationsFullSystemInfoVM siVM = new BookingFileReservationsFullSystemInfoVM();
                siVM.setGdsName(si.getGdsName());
                siVM.setBookingAgentDutyCode(si.getBookingAgentDutyCode());
                siVM.setBookingPcc(si.getBookingPcc());
                siVM.getSuperColumn().getContent().addAll(si.getRecordLocators().stream().map(rli -> {
                    BookingFileReservationsFullRecordLocatorInfoVM rliVM = new BookingFileReservationsFullRecordLocatorInfoVM();
                    ReservationsTileHelper.toVMRecordLocatorInfoCommonParameters((BookingFileReservationsFullRecordLocatorInfoVM)rliVM, (RecordLocatorInfo)rli);
                    return rliVM;
                }).collect(Collectors.toList()));
                resVM.getGdsNameInfo().getSystemInfos().add(siVM);
            });
        });
    }

    static void fromVM(BookingFileReservationsFullPanelVM full, BookingFile model) {
        VMHelper.transfer((Collection)full.getContent(), (Collection)model.getReservations(), resVM -> new Reservation(), (resvVM, res) -> {
            res.setPqTimeLimit(DateUtils.asDate((LocalDateTime)resvVM.getGeneralParameters().getPqTimeLimit()));
            res.getGdsNameInfo().setOnlineGdsAccount(resvVM.getGdsNameInfo().getOnlineGdsAccount());
            res.setStatus(resvVM.getGeneralParameters().getStaus());
            ReservationGdsNameInfo gdsNameInfo = res.getGdsNameInfo();
            gdsNameInfo.getSystemInfos().clear();
            resvVM.getGdsNameInfo().getSystemInfos().forEach(siVM -> {
                ReservationSystemInfo si = new ReservationSystemInfo();
                si.setGdsName(siVM.getGdsName());
                si.setBookingAgentDutyCode(siVM.getBookingAgentDutyCode());
                si.setBookingPcc(siVM.getBookingPcc());
                si.getRecordLocators().addAll(siVM.getSuperColumn().getContent().stream().map(rliVM -> {
                    RecordLocatorInfo rli = new RecordLocatorInfo();
                    ReservationsTileHelper.fromVMRecordLocatorInfoCommonParameters((RecordLocatorInfo)rli, (BookingFileReservationsFullRecordLocatorInfoVM)rliVM);
                    return rli;
                }).collect(Collectors.toList()));
                gdsNameInfo.getSystemInfos().add(si);
            });
        });
    }
}

