/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.booking.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpModelService;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.Node;

public class PaymentGateRefundPaymentAction
extends BaseProductAction<BaseProduct> {
    public double getWeight() {
        return 120.0;
    }

    protected String getName() {
        return Messages.RefundPaymentInPaymentGate;
    }

    protected String getDescription() {
        return Messages.RefundPaymentInPaymentGate_Description;
    }

    protected boolean isSaveRequired() {
        return true;
    }

    protected boolean isEnabled(BaseProduct product) {
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        return handler.getStatus(product) == ProductStatus.REFUND || handler.getStatus(product) == ProductStatus.EXCHANGE || handler.getStatus(product) == ProductStatus.VOID;
    }

    protected void execute(ProductActionContext<BaseProduct> ctx) {
        Notifications.get().submitTask(() -> {
            BaseProduct product = ctx.getSelectedProduct();
            ProductHandler handler = ProductHandler.of((BaseProduct)product);
            Set paymentGatesNames = ((IbecorpModelService)RpcServiceManager.get().getService(IbecorpModelService.class)).getProductPaymentGatesNames(ServiceInvocationContext.get(), product);
            if (paymentGatesNames.size() == 1) {
                BigDecimal refundAmount = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getProductTotalPrice(ServiceInvocationContext.get(), product, ContractType.CLIENT, true);
                String dialogText = String.format("\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u0435\u0440\u043d\u0443\u0442\u044c %s \u043f\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0443 %s \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0448\u043b\u044e\u0437 %s?", refundAmount.abs(), handler.generateShortProductName(product), CollectionUtil.head((Iterable)paymentGatesNames));
                String refundRouteId = handler.getStatus(product) == ProductStatus.VOID ? "pg-connector:refund-payment-for-void" : "pg-connector:refund-payment";
                SimpleContainer body = new SimpleContainer();
                TextFieldWidget fieldWidget = new TextFieldWidget(true);
                fieldWidget.setValue(dialogText);
                body.setContent((Node)fieldWidget);
                FxUtil.waitForFxThread(() -> new Dialog().setTitle("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0434\u0435\u043d\u0435\u0433 \u043d\u0430 \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0443\u044e \u043a\u0430\u0440\u0442\u0443").setBody((Node)body).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_CONTINUE, () -> Notifications.get().submitTask(() -> {
                    boolean allRefunded;
                    HashMap<String, Object> ibusCtx = new HashMap<String, Object>();
                    ibusCtx.put("BOOKING_FILE", ctx.getRootPane().getData().getContainer());
                    ibusCtx.put("BASE_PRODUCTS", Collections.singletonList(product));
                    ibusCtx.put("BOOKING_FILE_RESERVATIONS", Collections.singletonList(product.getReservation()));
                    ibusCtx.put("SALES_CONTEXT", SalesContextHandler.get().createSalesContext(product.getReservation()));
                    Map result = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), refundRouteId, ibusCtx, Collections.singleton("PAYMENT_CONTAINERS"));
                    List paymentContainers = (List)result.get("PAYMENT_CONTAINERS");
                    if (paymentContainers != null && (allRefunded = paymentContainers.stream().map(EntityContainer::getEntity).allMatch(payment -> payment.getStatus() == PaymentStatus.REFUNDED))) {
                        Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0421\u0440\u0435\u0434\u0441\u0442\u0432\u0430 \u0431\u044b\u043b\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u044b", (Object[])new Object[0])});
                        return;
                    }
                    Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442", (Object[])new Object[0])});
                }, "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432")).show((Node)ctx.getRootPane()));
            } else {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041d\u0435\u0442 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", (Object[])new Object[0])});
            }
        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Notifications_getting_data);
    }
}

