/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.hotel;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.hotels2.entity.handlers.HotelAggregatorGdsAccountHandler;
import com.gridnine.xtrip.client.fx.hotels2.model.HotelAggregatorGdsAccountContainerVM;
import com.gridnine.xtrip.client.fx.hotels2.model.HotelsAggregatorDataMainContainerVM;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.hotel.interceptors.HotelAggregatorGdsAccountInterceptor;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.hotels2.model.BaseHotelsProviderAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsAAndAAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsAcademserviceAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorData;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsBronevikAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsHotelbookAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsOstrovokAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsRCRAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsSabreAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsSusaninAccount;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import java.util.List;
import java.util.function.BiConsumer;

public class IbecorpHotelAggregatorGdsAccountHandler
extends HotelAggregatorGdsAccountHandler {
    protected void configureController(List<BiConsumer<DataTransferPackage<HotelsAggregatorGdsAccount, Void>, HotelAggregatorGdsAccountContainerVM>> toVM, List<BiConsumer<HotelAggregatorGdsAccountContainerVM, DataTransferPackage<HotelsAggregatorGdsAccount, Void>>> fromVM) {
        super.configureController(toVM, fromVM);
        ControllersRegistry.register((ControllerInterceptor)new HotelAggregatorGdsAccountInterceptor());
        toVM.add((dtp, vm) -> {
            HotelsAggregatorGdsAccount model = (HotelsAggregatorGdsAccount)dtp.getContainer().getEntity();
            vm.getOptions().setProvider(model.getProvider());
            HotelsAggregatorData modelData = model.getHotelsAggregatorData();
            if (modelData == null) {
                return;
            }
            vm.getHotelsAggregatorData().setCurrency(modelData.getCurrency());
            vm.getHotelsAggregatorData().setMaxSearchTimeMs(modelData.getMaxSearchTimeMs());
            vm.getHotelsAggregatorData().setIgnoreMissingHotels(modelData.getIgnoreMissingHotels());
            this.readProviderData((HotelAggregatorGdsAccountContainerVM)vm, model);
        });
        fromVM.add((vm, dtp) -> {
            HotelsAggregatorGdsAccount model = (HotelsAggregatorGdsAccount)dtp.getContainer().getEntity();
            model.setProvider(vm.getOptions().getProvider());
            HotelsAggregatorData modelData = model.getHotelsAggregatorData();
            if (modelData == null) {
                modelData = new HotelsAggregatorData();
                model.setHotelsAggregatorData(modelData);
            }
            modelData.setCurrency(vm.getHotelsAggregatorData().getCurrency());
            modelData.setMaxSearchTimeMs(vm.getHotelsAggregatorData().getMaxSearchTimeMs());
            modelData.setIgnoreMissingHotels(vm.getHotelsAggregatorData().getIgnoreMissingHotels());
            this.writeProviderData(modelData, (HotelAggregatorGdsAccountContainerVM)vm);
        });
    }

    private void readProviderData(HotelAggregatorGdsAccountContainerVM vm, HotelsAggregatorGdsAccount model) {
        BaseHotelsProviderAccount providerData = (BaseHotelsProviderAccount)model.getHotelsAggregatorData().getVendors().get(model.getProvider());
        this.readCommonProviderData(vm.getHotelsAggregatorData(), providerData);
        if (model.getProvider() == null) {
            return;
        }
        switch (model.getProvider()) {
            case BRONEVIK: {
                this.readProviderData(vm.getHotelsAggregatorData(), (HotelsBronevikAccount)providerData);
                break;
            }
            case ACADEMSERVICE: {
                this.readProviderData(vm.getHotelsAggregatorData(), (HotelsAcademserviceAccount)providerData);
                break;
            }
            case A_AND_A: {
                this.readProviderData(vm.getHotelsAggregatorData(), (HotelsAAndAAccount)providerData);
                break;
            }
            case SABRE: {
                this.readProviderData(vm.getHotelsAggregatorData(), (HotelsSabreAccount)providerData);
                break;
            }
            case OSTROVOK: {
                this.readProviderData(vm.getHotelsAggregatorData(), (HotelsOstrovokAccount)providerData);
            }
        }
    }

    private void readCommonProviderData(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM, BaseHotelsProviderAccount providerData) {
        if (providerData == null) {
            return;
        }
        hotelsAggregatorDataVM.setProviderUrl(providerData.getUrl());
        hotelsAggregatorDataVM.setProviderLogin(providerData.getLogin());
        hotelsAggregatorDataVM.setProviderPassword(providerData.getPassword());
    }

    private void readProviderData(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM, HotelsBronevikAccount providerData) {
        hotelsAggregatorDataVM.setClientKey(providerData.getClientKey());
        hotelsAggregatorDataVM.setUseSearchHotelOffersRequest(providerData.isUseSearchHotelOffersRequest());
        hotelsAggregatorDataVM.setUseNativeSearch(providerData.isUseNativeSearch());
    }

    private void readProviderData(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM, HotelsAcademserviceAccount providerData) {
        hotelsAggregatorDataVM.setOrganizationId(providerData.getOrganizationId());
        hotelsAggregatorDataVM.setInboundConnectionEnabled(providerData.isInboundConnectionEnabled());
        hotelsAggregatorDataVM.setInboundConnectionLogin(providerData.getInboundConnectionLogin());
        hotelsAggregatorDataVM.setInboundConnectionPassword(providerData.getInboundConnectionPassword());
        hotelsAggregatorDataVM.setSearchHostels(providerData.isSearchHostels());
    }

    private void readProviderData(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM, HotelsAAndAAccount providerData) {
        hotelsAggregatorDataVM.setOrganizationId(providerData.getOrganizationId());
        hotelsAggregatorDataVM.setUseNativeSearch(providerData.isUseNativeSearch());
    }

    private void readProviderData(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM, HotelsOstrovokAccount providerData) {
        hotelsAggregatorDataVM.setUseNativeSearch(providerData.isUseNativeSearch());
    }

    private void readProviderData(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM, HotelsSabreAccount providerData) {
        hotelsAggregatorDataVM.setTransactionExecutor(providerData.getTransactionExecutor());
        hotelsAggregatorDataVM.setIpcc(providerData.getIpcc());
        hotelsAggregatorDataVM.setSearchRadius(providerData.getSearchRadius());
    }

    private void writeProviderData(HotelsAggregatorData modelData, HotelAggregatorGdsAccountContainerVM vm) {
        modelData.getVendors().clear();
        HotelProvider provider = vm.getOptions().getProvider();
        BaseHotelsProviderAccount providerAccount = this.buildProviderAccount(provider, vm);
        if (providerAccount != null) {
            modelData.getVendors().put(provider, providerAccount);
        }
    }

    private BaseHotelsProviderAccount buildProviderAccount(HotelProvider provider, HotelAggregatorGdsAccountContainerVM vm) {
        if (provider == null) {
            return null;
        }
        switch (provider) {
            case BRONEVIK: {
                return this.buildHotelsBronevikAccount(vm.getHotelsAggregatorData());
            }
            case OSTROVOK: {
                return this.buildHotelsOstrovokAccount(vm.getHotelsAggregatorData());
            }
            case ACADEMSERVICE: {
                return this.buildHotelsAcademserviceAccount(vm.getHotelsAggregatorData());
            }
            case A_AND_A: {
                return this.buildHotelsAAndAAccount(vm.getHotelsAggregatorData());
            }
            case HOTELBOOK: {
                return this.buildHotelsHotelbookAccount(vm.getHotelsAggregatorData());
            }
            case SUSANIN: {
                return this.buildHotelsSusaninAccount(vm.getHotelsAggregatorData());
            }
            case SABRE: {
                return this.buildHotelsSabreAccount(vm.getHotelsAggregatorData());
            }
            case RCR: {
                return this.buildHotelsRCRAccount(vm.getHotelsAggregatorData());
            }
        }
        return null;
    }

    private BaseHotelsProviderAccount buildHotelsBronevikAccount(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM) {
        HotelsBronevikAccount result = new HotelsBronevikAccount();
        this.updateHotelsProviderAccount((BaseHotelsProviderAccount)result, hotelsAggregatorDataVM);
        result.setClientKey(hotelsAggregatorDataVM.getClientKey());
        result.setUseSearchHotelOffersRequest(hotelsAggregatorDataVM.isUseSearchHotelOffersRequest());
        result.setUseNativeSearch(hotelsAggregatorDataVM.isUseNativeSearch());
        return result;
    }

    private BaseHotelsProviderAccount buildHotelsOstrovokAccount(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM) {
        HotelsOstrovokAccount result = new HotelsOstrovokAccount();
        this.updateHotelsProviderAccount((BaseHotelsProviderAccount)result, hotelsAggregatorDataVM);
        result.setUseNativeSearch(hotelsAggregatorDataVM.isUseNativeSearch());
        return result;
    }

    private BaseHotelsProviderAccount buildHotelsAcademserviceAccount(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM) {
        HotelsAcademserviceAccount result = new HotelsAcademserviceAccount();
        this.updateHotelsProviderAccount((BaseHotelsProviderAccount)result, hotelsAggregatorDataVM);
        result.setOrganizationId(hotelsAggregatorDataVM.getOrganizationId());
        result.setInboundConnectionEnabled(hotelsAggregatorDataVM.isInboundConnectionEnabled());
        result.setInboundConnectionLogin(hotelsAggregatorDataVM.getInboundConnectionLogin());
        result.setInboundConnectionPassword(hotelsAggregatorDataVM.getInboundConnectionPassword());
        result.setSearchHostels(hotelsAggregatorDataVM.isSearchHostels());
        return result;
    }

    private BaseHotelsProviderAccount buildHotelsAAndAAccount(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM) {
        HotelsAAndAAccount result = new HotelsAAndAAccount();
        this.updateHotelsProviderAccount((BaseHotelsProviderAccount)result, hotelsAggregatorDataVM);
        result.setOrganizationId(hotelsAggregatorDataVM.getOrganizationId());
        result.setUseNativeSearch(hotelsAggregatorDataVM.isUseNativeSearch());
        return result;
    }

    private BaseHotelsProviderAccount buildHotelsHotelbookAccount(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM) {
        HotelsHotelbookAccount result = new HotelsHotelbookAccount();
        this.updateHotelsProviderAccount((BaseHotelsProviderAccount)result, hotelsAggregatorDataVM);
        return result;
    }

    private BaseHotelsProviderAccount buildHotelsSusaninAccount(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM) {
        HotelsSusaninAccount result = new HotelsSusaninAccount();
        this.updateHotelsProviderAccount((BaseHotelsProviderAccount)result, hotelsAggregatorDataVM);
        return result;
    }

    private BaseHotelsProviderAccount buildHotelsSabreAccount(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM) {
        HotelsSabreAccount result = new HotelsSabreAccount();
        this.updateHotelsProviderAccount((BaseHotelsProviderAccount)result, hotelsAggregatorDataVM);
        result.setTransactionExecutor(hotelsAggregatorDataVM.getTransactionExecutor());
        result.setIpcc(hotelsAggregatorDataVM.getIpcc());
        result.setSearchRadius(hotelsAggregatorDataVM.getSearchRadius());
        return result;
    }

    private BaseHotelsProviderAccount buildHotelsRCRAccount(HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM) {
        HotelsRCRAccount result = new HotelsRCRAccount();
        this.updateHotelsProviderAccount((BaseHotelsProviderAccount)result, hotelsAggregatorDataVM);
        return result;
    }

    private void updateHotelsProviderAccount(BaseHotelsProviderAccount result, HotelsAggregatorDataMainContainerVM hotelsAggregatorDataVM) {
        result.setUrl(hotelsAggregatorDataVM.getProviderUrl());
        result.setLogin(hotelsAggregatorDataVM.getProviderLogin());
        result.setPassword(hotelsAggregatorDataVM.getProviderPassword());
        result.setIgnoreMissingHotels(hotelsAggregatorDataVM.getIgnoreMissingHotels());
    }
}

