/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.modelcontract;

import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.ModelContractConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.client.fx.standard.rules.RulesWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.rules.StandardFilters;
import com.gridnine.xtrip.common.ibecorp.correspondence.rules.CorrespondenceFilteringCategories;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationAdditionalTargets;
import com.gridnine.xtrip.common.model.rules.subsidized.SubsidizedContractFilteringCategories;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyFilteringCategories;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class IbeModelContractConfigurator
implements ModelContractConfigurator {
    public void configureRulesTile(Tile<Node, CustomWidget<RuleSet>> rulesTile) {
        RulesViewConfiguration config = new RulesViewConfiguration();
        config.getCategories().addAll(Arrays.asList(ContractsFilteringCategories.MODEL_CONTRACT, TravelPolicyFilteringCategories.TRAVEL_POLICY, CorrespondenceFilteringCategories.NOTIFICATION_FILTERING_CATEGORY, IbecorpFilteringCategories.HOTEL_PREPROCESSING, IbecorpFilteringCategories.NOTIFICATION_EXTERNAL_FINDOCS, IbecorpFilteringCategories.NOTIFICATION_TEMPLATE));
        config.getFilters().addAll(Arrays.asList(StandardFilters.values()));
        config.setActionsSupplier(target -> RulesEnvironment.get().getActions(target).stream().filter(action -> {
            boolean flag = false;
            for (RuleFilteringCategory category : config.getCategories()) {
                if (!IbeModelContractConfigurator.checkFilteringCategory(category) || !RulesEnvironment.get().getActions(category).contains(action) || !RulesEnvironment.get().getTargets(category).contains(target)) continue;
                flag = true;
            }
            return flag;
        }).collect(Collectors.toList()));
        config.setTargetsSupplier(() -> {
            boolean additionalTargetsNeeded = Prefetched.getData().isShowSabreSyncRuleTargets();
            HashSet<RuleTarget> targets = new HashSet<RuleTarget>();
            for (RuleFilteringCategory category : config.getCategories()) {
                if (!IbeModelContractConfigurator.checkFilteringCategory(category)) continue;
                for (RuleTarget target : RulesEnvironment.get().getTargets(category)) {
                    if (category == TravelPolicyFilteringCategories.TRAVEL_POLICY) {
                        if (TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION == target && !AppConfigHelper.isTravelPolicyEnabled()) continue;
                        targets.add(target);
                        continue;
                    }
                    if (!additionalTargetsNeeded && Arrays.asList(SabreSynchronizationAdditionalTargets.values()).contains(target)) continue;
                    targets.add(target);
                }
            }
            return new ArrayList(targets);
        });
        RulesWidgetHelper.initTile(rulesTile, (RulesViewConfiguration)config);
    }

    public boolean isAvaible() {
        return AppConfigHelper.isIbeEnabled();
    }

    private static boolean checkFilteringCategory(RuleFilteringCategory object) {
        return ContractsFilteringCategories.contains((Object)object) || SubsidizedContractFilteringCategories.AVIA_SUBSIDIZED_CONTRACT == object || TravelPolicyFilteringCategories.TRAVEL_POLICY == object || CorrespondenceFilteringCategories.NOTIFICATION_FILTERING_CATEGORY == object || IbecorpFilteringCategories.HOTEL_PREPROCESSING == object || IbecorpFilteringCategories.NOTIFICATION_EXTERNAL_FINDOCS == object || IbecorpFilteringCategories.NOTIFICATION_TEMPLATE == object;
    }
}

