/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationGeneralPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationGroupIbeVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationGroupsPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpace;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationUIData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class IbeOrganizationEditorInterceptor
implements RootEntityEditorInterceptor<Organization, OrganizationUIData> {
    public void onLoad(DataTransferPackage<Organization, OrganizationUIData> data, Node editor) {
    }

    public boolean onSave(DataTransferPackage<Organization, OrganizationUIData> data, Node editor) {
        try {
            OrganizationSpace space = (OrganizationSpace)editor;
            HashMap<Message, IndexListParameters<Person, PersonIndex>> messages = new HashMap<Message, IndexListParameters<Person, PersonIndex>>();
            this.checkAclRoles(data, space, messages);
            FxUtil.waitForFxThread(() -> space.addMessages(messages, Messages.Profile_list));
            return messages.isEmpty();
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return false;
        }
    }

    private void checkAclRoles(DataTransferPackage<Organization, OrganizationUIData> data, OrganizationSpace space, Map<Message, IndexListParameters<Person, PersonIndex>> messages) throws Exception {
        List aclRolesEdited = ((OrganizationGroupsPanel)((OrganizationGeneralPanel)space.getMainTile().getFullNode()).getGroupsCard().getContent()).getOrganizationAclRolesIbeTableNode().getRowsData().stream().map(OrganizationGroupIbeVM::getOrganizationAclRoles).filter(Objects::nonNull).collect(Collectors.toList());
        EntityContainer orgCtr = data.getContainer();
        List aclRolesSaved = ((Organization)orgCtr.getEntity()).getAclSettings().getOrganizationAclRoles();
        List aclRolesDeleted = aclRolesSaved.stream().filter(item -> !aclRolesEdited.contains(item)).collect(Collectors.toList());
        if (aclRolesDeleted.isEmpty()) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)PersonIndex.Property.aclRole.name(), (Object[])aclRolesDeleted.toArray()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.company.name(), (Object)orgCtr.toReference()));
        List personIndices = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), PersonIndex.class, query);
        if (personIndices.isEmpty()) {
            return;
        }
        Message message = MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Organization_acl_roles_deletion_error, (Object[])new Object[]{personIndices.stream().map(PersonIndex::getAclRole).distinct().map(EntityReference::getCaption).collect(Collectors.joining(", "))});
        messages.put(message, this.createParameters(personIndices));
    }

    private IndexListParameters<Person, PersonIndex> createParameters(List<PersonIndex> personIndices) {
        IndexListParameters parameters = new IndexListParameters();
        List uids = personIndices.stream().map(PersonIndex::getSource).filter(Objects::nonNull).map(EntityReference::getUid).collect(Collectors.toList());
        parameters.setIndexType(PersonIndex.class);
        parameters.getSearchCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])uids.toArray()));
        ListParametersHelper.setFilters((IndexListParameters)parameters, (String[])new String[]{PersonIndex.Property.name.name(), PersonIndex.Property.code.name(), PersonIndex.Property.aclRole.name()});
        ListParametersHelper.setColumns((IndexListParameters)parameters, (String[])new String[]{PersonIndex.Property.name.name(), PersonIndex.Property.code.name(), PersonIndex.Property.aclRole.name()});
        return parameters;
    }
}

