/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.ibecorp.model.IBEContactPhonesTableVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.IBEOrganizationEmailVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.IBEOrganizationSiteVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.IBESimpleAgencyContainer;
import com.gridnine.xtrip.client.fx.ibecorp.model.IBESimpleAgencyContainerController;
import com.gridnine.xtrip.client.fx.ibecorp.model.IBESimpleAgencyContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;

public class SimpleAgencyHandler
extends BaseRootEntityHandler<Organization, Void, IBESimpleAgencyContainerVM, IBESimpleAgencyContainer> {
    public Class<Organization> getEntityClass() {
        return Organization.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return OrganizationIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<Organization, Void>, IBESimpleAgencyContainerVM>> toVM, List<BiConsumer<IBESimpleAgencyContainerVM, DataTransferPackage<Organization, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            Organization model = (Organization)dtp.getContainer().getEntity();
            vm.getGeneral().setShortName(model.getShortName());
            vm.getGeneral().setFullName(model.getFullName());
            vm.getGeneral().setLogo(model.getLogo());
            vm.getGeneral().setSignature(model.getSignature());
            vm.getGeneral().setStamp(model.getStamp());
            ArrayList<Communication> phones = new ArrayList<Communication>();
            ArrayList<Communication> emails = new ArrayList<Communication>();
            ArrayList<Communication> sites = new ArrayList<Communication>();
            block4: for (Communication cmm2 : model.getCommunications()) {
                if (cmm2.getType() == null) {
                    phones.add(cmm2);
                    continue;
                }
                switch (cmm2.getType()) {
                    case EMAIL: {
                        emails.add(cmm2);
                        continue block4;
                    }
                    case WEB: {
                        sites.add(cmm2);
                        continue block4;
                    }
                }
                phones.add(cmm2);
            }
            VMHelper.transfer(phones, (Collection)vm.getPhones(), cmm -> new IBEContactPhonesTableVM(), (cmm, vvm) -> {
                vvm.setType(cmm.getType());
                vvm.setCountryCode(cmm.getCountryCode());
                vvm.setCityCode(cmm.getCityCode());
                vvm.setPhoneNumber(cmm.getSense());
                vvm.setInternalNumber(cmm.getInternalNumber());
                vvm.setNotes(cmm.getRemarks());
            });
            VMHelper.transfer(emails, (Collection)vm.getEmails(), cmm -> new IBEOrganizationEmailVM(), (cmm, vvm) -> {
                vvm.setAddress(cmm.getSense());
                vvm.setNotes(cmm.getRemarks());
            });
            VMHelper.transfer(sites, (Collection)vm.getSites(), cmm -> new IBEOrganizationSiteVM(), (cmm, vvm) -> {
                vvm.setAddress(cmm.getSense());
                vvm.setNotes(cmm.getRemarks());
            });
        });
        fromVM.add((vm, dtp) -> {
            Organization model = (Organization)dtp.getContainer().getEntity();
            model.getShortName().getValues().clear();
            model.getFullName().getValues().clear();
            model.getShortName().getValues().putAll(vm.getGeneral().getShortName().getValues());
            model.getFullName().getValues().putAll(vm.getGeneral().getFullName().getValues());
            model.setLogo(vm.getGeneral().getLogo());
            model.setSignature(vm.getGeneral().getSignature());
            model.setStamp(vm.getGeneral().getStamp());
            ArrayList communicationVMs = new ArrayList();
            communicationVMs.addAll(vm.getPhones());
            communicationVMs.addAll(vm.getEmails());
            communicationVMs.addAll(vm.getSites());
            VMHelper.transfer(communicationVMs, (Collection)model.getCommunications(), vvm -> new Communication(), (vvm, cmm) -> {
                if (vvm instanceof IBEContactPhonesTableVM) {
                    IBEContactPhonesTableVM phoneVM = (IBEContactPhonesTableVM)vvm;
                    cmm.setType(phoneVM.getType());
                    cmm.setCountryCode(phoneVM.getCountryCode());
                    cmm.setCityCode(phoneVM.getCityCode());
                    cmm.setSense(phoneVM.getPhoneNumber());
                    cmm.setInternalNumber(phoneVM.getInternalNumber());
                    cmm.setRemarks(phoneVM.getNotes());
                } else if (vvm instanceof IBEOrganizationEmailVM) {
                    IBEOrganizationEmailVM emailVM = (IBEOrganizationEmailVM)vvm;
                    cmm.setType(CommunicationType.EMAIL);
                    cmm.setSense(emailVM.getAddress());
                    cmm.setRemarks(emailVM.getNotes());
                } else if (vvm instanceof IBEOrganizationSiteVM) {
                    IBEOrganizationSiteVM siteVM = (IBEOrganizationSiteVM)vvm;
                    cmm.setType(CommunicationType.WEB);
                    cmm.setSense(siteVM.getAddress());
                    cmm.setRemarks(siteVM.getNotes());
                }
            });
        });
    }

    protected ViewController<IBESimpleAgencyContainer, IBESimpleAgencyContainerVM> createSpaceController(boolean readonly) {
        return new IBESimpleAgencyContainerController(readonly);
    }

    protected IBESimpleAgencyContainerVM createVM() {
        return new IBESimpleAgencyContainerVM();
    }
}

