/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.person;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.person.PersonGeneralTileIbeHelper;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.person.PersonNotificationSettingsHelper;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.person.PersonSettingsExportsSbisHelper;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.person.controllerinterceptors.IbePersonBonusCardPanelRailwayControllerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.person.controllerinterceptors.IbePersonEditorInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.person.controllerinterceptors.IbePersonMainPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.person.controllerinterceptors.IbePersonSpaceControllerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.person.controllerinterceptors.PersonOrgNotificationSettingsControllerInterceptor;
import com.gridnine.xtrip.client.fx.model.profile.PersonSapBasicParametersVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.person.PersonHandlerConfigurator;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapIntegrationSyncData;
import com.gridnine.xtrip.common.model.person.uidata.PersonUIData;
import com.gridnine.xtrip.common.model.profile.Person;
import java.util.List;
import java.util.function.BiConsumer;

public class IbePersonHandlerConfigurator
implements PersonHandlerConfigurator {
    public void configureController(List<BiConsumer<DataTransferPackage<Person, PersonUIData>, PersonSpaceVM>> toVM, List<BiConsumer<PersonSpaceVM, DataTransferPackage<Person, PersonUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new IbePersonMainPanelControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new IbePersonSpaceControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new IbePersonBonusCardPanelRailwayControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new PersonOrgNotificationSettingsControllerInterceptor());
        toVM.add((dtp, vm) -> {
            Person model = (Person)dtp.getContainer().getEntity();
            SapIntegrationSyncData sapSyncData = model.getSapIntegrationSyncData();
            PersonGeneralTileIbeHelper.toVM(model, vm.getMainFull());
            if (sapSyncData != null) {
                PersonSapBasicParametersVM sapBasicParameters = vm.getExternalSystemSynchronizationFull().getSapSync().getBasicParameters();
                sapBasicParameters.setLastSyncDate(sapSyncData.getSyncDate());
                sapBasicParameters.setSyncStatus(sapSyncData.getStatusSync());
                sapBasicParameters.setAssistant(model.isSapAssistant());
            }
            PersonSettingsExportsSbisHelper.toVM(model, vm.getSettingsExportSbisFull());
            PersonNotificationSettingsHelper.toVM(model, vm.getNotificationSettingsFull());
        });
        fromVM.add((vm, dtp) -> {
            Person model = (Person)dtp.getContainer().getEntity();
            PersonGeneralTileIbeHelper.fromVM(vm.getMainFull(), model);
            PersonSettingsExportsSbisHelper.fromVM(vm.getSettingsExportSbisFull(), model);
            PersonNotificationSettingsHelper.fromVM(vm.getNotificationSettingsFull(), model);
        });
    }

    public void collectEditorInterceptors(List<RootEntityEditorInterceptor<Person, PersonUIData>> editorInterceptors) {
        editorInterceptors.add(new IbePersonEditorInterceptor());
    }
}

