/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.profile.PersonEmploymentVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonGeneralAccessRightsPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonMainPanelController;
import com.gridnine.xtrip.client.fx.model.profile.PersonMainPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclRole;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class IbePersonMainPanelControllerInterceptor
extends ControllerInterceptor<PersonMainPanelVM, PersonMainPanelController> {
    protected Class<PersonMainPanelController> getControllerClass() {
        return PersonMainPanelController.class;
    }

    protected void onCreate(PersonMainPanelController controller) {
        controller.getView().getAccessRightsIbeCard().setHidden(!AppConfigHelper.isIbeEnabled());
        ComboBoxWidget aclRolesTableNode = ((PersonGeneralAccessRightsPanel)controller.getView().getAccessRightsIbeCard().getContent()).getAclRoleNode();
        this.setupRolesTableWidget((ComboBoxWidget<EntityReference<IbeCorpAclRole>>)aclRolesTableNode, controller.getView());
    }

    private void setupRolesTableWidget(ComboBoxWidget<EntityReference<IbeCorpAclRole>> widget, PersonMainPanel view) {
        widget.setLive(true);
        widget.setAsync(true);
        widget.setItemsSupplier(() -> {
            ArrayList result = new ArrayList();
            for (EntityReference<Organization> org : this.getMainOrganizations(view)) {
                try {
                    EntityContainer orgCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), org);
                    if (orgCtr == null || orgCtr.getEntity() == null) continue;
                    result.addAll(((Organization)orgCtr.getEntity()).getAclSettings().getOrganizationAclRoles());
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }
            return result;
        });
    }

    private List<EntityReference<Organization>> getMainOrganizations(PersonMainPanel view) {
        return ((TableWidget)view.getEmploymentsCard().getContent()).getRowsData().stream().filter(PersonEmploymentVM::isMainEmployment).map(PersonEmploymentVM::getOrganization).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected void afterReadData(PersonMainPanelController controller, PersonMainPanelVM model) {
        ((TableWidget)controller.getEmployments().getView()).setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                this.addListener(controller, event.getRowIndex());
            }
        });
        for (int i = 0; i < ((TableWidget)controller.getEmployments().getView()).getRowsCount(); ++i) {
            this.addListener(controller, i);
        }
    }

    private void addListener(PersonMainPanelController controller, int index) {
        ((BooleanValueWidget)((BooleanValueWidgetColumn)((TableWidget)controller.getEmployments().getView()).getColumn("mainEmployment")).getWidget(index)).valueProperty().addListener((s, o, n) -> {
            if (n.booleanValue()) {
                BooleanValueWidgetColumn mainColumn = (BooleanValueWidgetColumn)((TableWidget)controller.getEmployments().getView()).getColumn("mainEmployment");
                for (int i = 0; i < ((TableWidget)controller.getEmployments().getView()).getRowsCount(); ++i) {
                    if (i == index) continue;
                    ((BooleanValueWidget)mainColumn.getWidget(i)).setValue(false);
                }
            }
        });
    }
}

