/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.security;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasValues;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.security.AspectsDataHelper;
import com.gridnine.xtrip.client.fx.ibecorp.model.security.AclRoleAspectIbeVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.security.AclRoleIbeContainerController;
import com.gridnine.xtrip.client.fx.ibecorp.model.security.AclRoleIbeContainerVM;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspect;
import com.gridnine.xtrip.common.util.Identity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.util.StringConverter;

class AclRoleControllerInterceptor
extends ControllerInterceptor<AclRoleIbeContainerVM, AclRoleIbeContainerController> {
    AclRoleControllerInterceptor() {
    }

    protected Class<AclRoleIbeContainerController> getControllerClass() {
        return AclRoleIbeContainerController.class;
    }

    protected void onCreate(AclRoleIbeContainerController controller) {
        this.configureVariantsTable((TableWidget<AclRoleAspectIbeVM>)controller.getView().getAspectVariantsNode());
    }

    private void configureVariantsTable(TableWidget<AclRoleAspectIbeVM> tableWidget) {
        ComboBoxWidgetColumn aspectColumn = new ComboBoxWidgetColumn(AclRoleAspectIbeVM::getAspectUid, AclRoleAspectIbeVM::setAspectUid);
        aspectColumn.setCaption("\u0410\u0441\u043f\u0435\u043a\u0442");
        aspectColumn.setPrefWidth(Double.valueOf(50.0));
        aspectColumn.setConverter((StringConverter)new StringConverter<String>(){

            public String toString(String object) {
                return AspectsDataHelper.getAspectName(object);
            }

            public String fromString(String string) {
                return null;
            }
        });
        aspectColumn.setItemsSupplier(() -> Prefetched.getData().getAvailableIbeAclAspects().stream().map(Identity::getUid).filter(uid -> {
            int count = tableWidget.getRowsCount();
            for (int i = 0; i < count; ++i) {
                if (!uid.equals(((ComboBoxWidget)aspectColumn.getWidget(i)).getValue())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList()));
        aspectColumn.setNavigationHandler(uid -> RootEntityEditingService.navigateTo((EntityReference)new EntityReference(uid, IbeCorpAclAspect.class, null)));
        RendererWidgetColumn variantsColumn = new RendererWidgetColumn(AclRoleAspectIbeVM::getVariantUids, (vm, uids) -> {
            vm.getVariantUids().clear();
            vm.getVariantUids().addAll((List)uids);
        });
        variantsColumn.setCaption("\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u044b");
        tableWidget.setColumns(Arrays.asList(aspectColumn, variantsColumn));
        tableWidget.setOnRowsAction(evt -> {
            if (evt.getEventType() != TableRowEvent.ROW_ADD) {
                return;
            }
            final ComboBoxWidget aspectWidget = (ComboBoxWidget)aspectColumn.getWidget(evt.getRowIndex().intValue());
            RendererWidget variantWidget = (RendererWidget)variantsColumn.getWidget(evt.getRowIndex().intValue());
            FxUtil.addListener((ObservableValue)aspectWidget.valueProperty(), (s, o, n) -> {
                if (n == null) {
                    variantWidget.setRenderer(null);
                    return;
                }
                variantWidget.setRenderer(new NodeRenderer(){

                    public void setValue(Node node, Object value) {
                        List list = (List)value;
                        if (node instanceof HasValues) {
                            ((HasValues)node).getValues().setAll((Collection)list);
                        } else {
                            ((HasValue)node).valueProperty().set(list.isEmpty() ? null : list.get(0));
                        }
                    }

                    public void setReadonly(boolean readonly, Node node) {
                        ((HasViewState)node).getViewState().setReadonly(readonly);
                    }

                    public Object getValue(Node node) {
                        if (node instanceof HasValues) {
                            return ((HasValues)node).getValues();
                        }
                        Object value = ((HasValue)node).valueProperty().get();
                        return value == null ? Collections.emptyList() : Collections.singletonList(value);
                    }

                    public Node createNode(boolean readonly) {
                        StringConverter<String> converter = new StringConverter<String>(){

                            public String toString(String object) {
                                return AspectsDataHelper.getVariantName((String)aspectWidget.getValue(), object);
                            }

                            public String fromString(String string) {
                                return null;
                            }
                        };
                        Supplier<List> supplier = () -> AspectsDataHelper.getVariantUids((String)aspectWidget.getValue());
                        if (AspectsDataHelper.isExclusion((String)aspectWidget.getValue())) {
                            ComboBoxWidget widget = new ComboBoxWidget(readonly);
                            widget.setConverter((StringConverter)converter);
                            widget.setItemsSupplier(supplier);
                            widget.setLive(true);
                            return widget;
                        }
                        ValuesWidget widget = new ValuesWidget(readonly);
                        widget.setConverter((StringConverter)converter);
                        widget.setItemsSupplier(supplier);
                        return widget;
                    }
                });
            });
        });
    }
}

