/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.security;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.security.AclRoleControllerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.security.AspectsDataHelper;
import com.gridnine.xtrip.client.fx.ibecorp.model.security.AclRoleAspectIbeVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.security.AclRoleIbeContainer;
import com.gridnine.xtrip.client.fx.ibecorp.model.security.AclRoleIbeContainerController;
import com.gridnine.xtrip.client.fx.ibecorp.model.security.AclRoleIbeContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspect;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspectVariant;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclRole;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclRoleIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;

public class AclRoleHandler
extends BaseRootEntityHandler<IbeCorpAclRole, Void, AclRoleIbeContainerVM, AclRoleIbeContainer> {
    protected void configureController(List<BiConsumer<DataTransferPackage<IbeCorpAclRole, Void>, AclRoleIbeContainerVM>> toVM, List<BiConsumer<AclRoleIbeContainerVM, DataTransferPackage<IbeCorpAclRole, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new AclRoleControllerInterceptor());
        toVM.add((dtp, vm) -> {
            IbeCorpAclRole model = (IbeCorpAclRole)dtp.getContainer().getEntity();
            vm.setName(model.getName());
            this.aspectsToVm(model.getAspectVariants(), vm.getAspectVariants());
        });
        fromVM.add((vm, dtp) -> {
            IbeCorpAclRole model = (IbeCorpAclRole)dtp.getContainer().getEntity();
            model.setName(vm.getName());
            this.aspectsFromVm(vm.getAspectVariants(), model.getAspectVariants());
        });
    }

    private void aspectsToVm(List<NestedEntityReference<IbeCorpAclAspect, IbeCorpAclAspectVariant>> refs, List<AclRoleAspectIbeVM> vms) {
        LinkedHashMap<String, AclRoleAspectIbeVM> map = new LinkedHashMap<String, AclRoleAspectIbeVM>();
        for (NestedEntityReference<IbeCorpAclAspect, IbeCorpAclAspectVariant> ref : refs) {
            AclRoleAspectIbeVM variantVm = (AclRoleAspectIbeVM)map.get(ref.getUid());
            if (variantVm == null) {
                variantVm = new AclRoleAspectIbeVM();
                variantVm.setAspectUid(ref.getUid());
                map.put(ref.getUid(), variantVm);
            }
            variantVm.getVariantUids().add(ref.getNestedEntityUid());
        }
        vms.clear();
        vms.addAll(map.values());
    }

    private void aspectsFromVm(List<AclRoleAspectIbeVM> vms, List<NestedEntityReference<IbeCorpAclAspect, IbeCorpAclAspectVariant>> refs) {
        refs.clear();
        for (AclRoleAspectIbeVM vm : vms) {
            if (TextUtil.isBlank((String)vm.getAspectUid())) continue;
            for (String variantUid : vm.getVariantUids()) {
                if (TextUtil.isBlank((String)variantUid)) continue;
                refs.add((NestedEntityReference<IbeCorpAclAspect, IbeCorpAclAspectVariant>)new NestedEntityReference(vm.getAspectUid(), IbeCorpAclAspect.class, variantUid, IbeCorpAclAspectVariant.class, AspectsDataHelper.getVariantName(vm.getAspectUid(), variantUid)));
            }
        }
    }

    public Class<IbeCorpAclRole> getEntityClass() {
        return IbeCorpAclRole.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return IbeCorpAclRoleIndex.class;
    }

    protected ViewController<AclRoleIbeContainer, AclRoleIbeContainerVM> createSpaceController(boolean readonly) {
        return new AclRoleIbeContainerController(readonly);
    }

    protected AclRoleIbeContainerVM createVM() {
        return new AclRoleIbeContainerVM();
    }
}

