/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.ExpandedGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationFinanceDocumentSettingVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSignature;
import com.gridnine.xtrip.client.fx.model.profile.SignaturesPanel;
import com.gridnine.xtrip.client.fx.model.profile.SignaturesPanelController;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.CertificateOfCompletedFlightTask;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.CertificateOfCompletedFlightProperties;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.Signature;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CertificateOfCompletedFlightDialog {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private final Control source;
    private final MultiEntityWidget<TemplateDocument> templatesWidget;
    private final BooleanValueWidget useFacsimileWidget;
    private final SignaturesPanel signersWidget;
    private final TableWidget<ProductTableVM> productsWidget;
    private final TableWidgetController<TableWidget<ProductTableVM>, ProductTableVM> productsController;
    private final SignaturesPanelController organizationSettingController;

    public CertificateOfCompletedFlightDialog(Control src, Map<BaseProduct, EntityReference<BookingFile>> products2Bookings, String selectedProductUid) {
        this.source = src;
        this.templatesWidget = new MultiEntityWidget(TemplateDocument.class, false);
        this.templatesWidget.setListParametersSupplier(this::getTemplateParameters);
        CertificateOfCompletedFlightProperties properties = new CertificateOfCompletedFlightProperties();
        this.loadParams(properties);
        this.templatesWidget.getValues().clear();
        this.templatesWidget.getValues().addAll(properties.getTemplateRefs());
        this.useFacsimileWidget = new BooleanValueWidget(true, false);
        if (properties.isUseFacsimile() != null) {
            this.useFacsimileWidget.setValue(properties.isUseFacsimile().booleanValue());
        }
        this.productsWidget = this.createProductsWidget();
        this.organizationSettingController = new SignaturesPanelController(false);
        this.signersWidget = this.organizationSettingController.getView();
        List signatures = properties.getSignatures();
        if (!signatures.isEmpty()) {
            Object[] organizationSignatures = new OrganizationSignature[signatures.size()];
            for (int i = 0; i < organizationSignatures.length; ++i) {
                OrganizationSignature organizationSignature = new OrganizationSignature(false);
                organizationSignature.getSignerNode().setValue(((Signature)signatures.get(i)).getSigner());
                organizationSignature.getCommentNode().setValue(((Signature)signatures.get(i)).getComment());
                organizationSignature.getTitleNode().setValue(((Signature)signatures.get(i)).getTitle());
                organizationSignature.getPositionNode().setValue(((Signature)signatures.get(i)).getPosition());
                organizationSignatures[i] = organizationSignature;
            }
            ((ExpandedGroupsWidget)this.signersWidget.getSignaturesCard().getContent()).getViews().setAll(organizationSignatures);
        }
        ((ExpandedGroupsWidget)this.signersWidget.getSignaturesCard().getContent()).getViews().forEach(CertificateOfCompletedFlightDialog::selectPositionSignature);
        ((ExpandedGroupsWidget)this.signersWidget.getSignaturesCard().getContent()).getViews().addListener(change -> change.getList().stream().map(organizationSignature -> (OrganizationSignature)organizationSignature).forEach(CertificateOfCompletedFlightDialog::selectPositionSignature));
        this.productsController = new TableWidgetController<TableWidget<ProductTableVM>, ProductTableVM>(){

            public TableWidget<ProductTableVM> getView() {
                return CertificateOfCompletedFlightDialog.this.productsWidget;
            }
        };
        List productsVM = products2Bookings.entrySet().stream().map(item -> {
            BaseProduct prod = (BaseProduct)item.getKey();
            ProductTableVM productVM = new ProductTableVM();
            productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)prod));
            productVM.setProductUID(prod.getUid());
            productVM.setBfRef((EntityReference<BookingFile>)((EntityReference)item.getValue()));
            if (products2Bookings.entrySet().size() == 1) {
                productVM.setChecked(true);
            } else {
                productVM.setChecked(prod.getUid().equals(selectedProductUid));
            }
            return productVM;
        }).collect(Collectors.toList());
        this.productsController.readData(productsVM);
    }

    private static void selectPositionSignature(OrganizationSignature organizationSignature) {
        organizationSignature.getSignerNode().setValueSelectionListener(val -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            Notifications.get().submitTask(() -> {
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer ctr = entityService.load(sic, val.getSource());
                if (ctr != null) {
                    FxUtil.waitForFxThread(() -> {
                        Person person = (Person)ctr.getEntity();
                        if (person != null && !person.getEmployments().isEmpty()) {
                            Date dateNow = new Date();
                            Optional<PersonEmployment> optionalPersonEmployment = person.getEmployments().stream().filter(personEmployment -> MiscUtil.isBetween((Date)personEmployment.getOpened(), (Date)personEmployment.getClosed(), (Date)dateNow) && personEmployment.isMainEmployment()).findFirst();
                            if (optionalPersonEmployment.isPresent()) {
                                organizationSignature.getPositionNode().setValue(optionalPersonEmployment.get().getPosition());
                            } else {
                                organizationSignature.getPositionNode().setValue(null);
                            }
                        }
                    });
                }
            }, Messages.Download_signers);
        });
    }

    private CertificateOfCompletedFlightProperties createAndFillProperties() {
        return new CertificateOfCompletedFlightProperties(this.getTemplates(), Boolean.valueOf(this.useFacsimileWidget.getValue()), this.getProducts2Bookings(), this.getSigners());
    }

    private List<Signature> getSigners() {
        OrganizationFinanceDocumentSettingVM organizationFinanceDocumentSettingVM = new OrganizationFinanceDocumentSettingVM();
        this.organizationSettingController.writeData(organizationFinanceDocumentSettingVM);
        List organizationSignaturesVM = organizationFinanceDocumentSettingVM.getSignatures();
        ArrayList<Signature> signatures = new ArrayList<Signature>();
        VMHelper.transfer((Collection)organizationSignaturesVM, signatures, signatureVM -> new Signature(), (signatureVM, signature) -> {
            signature.setSigner(signatureVM.getSigner());
            signature.setPosition(signatureVM.getPosition());
            if (signatureVM.getTitle() != null) {
                signature.getTitle().getValues().clear();
                signature.getTitle().getValues().putAll(signatureVM.getTitle().getValues());
            }
            signature.setComment(signatureVM.getComment());
        });
        return signatures;
    }

    private IndexListParameters<TemplateDocument, TemplateDocumentIndex> getTemplateParameters() {
        return ControllerInterceptorsHelper.getCertificateOfCompletedFlightTemplates();
    }

    private CertificateOfCompletedFlightTask createTask(CertificateOfCompletedFlightProperties properties) {
        return new CertificateOfCompletedFlightTask(properties);
    }

    private String getPropertiesFileName() {
        return "certificate-of-completed-flight.xml";
    }

    public void showDialog() {
        CardsContainer cardsContainer = this.createCards();
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.certificateOfCompletedFlightParameters).setAutoClose(false).setExpandToParent(true).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Form, () -> this.runnable(dialog, false)).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Print, () -> this.runnable(dialog, true)).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)this.source);
    }

    private void runnable(Dialog dialog, boolean isPrint) {
        Map<String, EntityReference<BookingFile>> products = this.getProducts2Bookings();
        if (products.size() == 0) {
            Dialog.info((String)Messages.Need_at_least_one_certificate);
            return;
        }
        if (this.getTemplates().isEmpty()) {
            Dialog.info((String)Messages.Must_select_a_template);
            return;
        }
        CertificateOfCompletedFlightProperties properties = this.createAndFillProperties();
        properties.setPrint(isPrint);
        this.saveParams(properties);
        Notifications.get().enqueueAsyncTask((ClientTask)this.createTask(properties));
        dialog.close();
    }

    private TableWidget<ProductTableVM> createProductsWidget() {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<InfoWidgetColumn> columns = new ArrayList<InfoWidgetColumn>();
        InfoWidgetColumn column = new InfoWidgetColumn(ProductTableVM::getProduct, ProductTableVM::setProduct);
        column.setId("product");
        column.setCaption(Messages.Name);
        columns.add(column);
        column = new BooleanValueWidgetColumn(ProductTableVM::isChecked, ProductTableVM::setChecked);
        column.setId("checked");
        column.setCaption(Messages.addCertificateOfCompletedFlight);
        column.setPrefWidth(Double.valueOf(30.0));
        columns.add(column);
        widget.setColumns(columns);
        return widget;
    }

    private CardsContainer createCards() {
        CardsContainer cardsContainer = new CardsContainer();
        ((ExpandedGroupsWidget)this.signersWidget.getSignaturesCard().getContent()).getViews().addListener(change -> change.getList().stream().map(organizationSignature -> (OrganizationSignature)organizationSignature).forEach(signature -> signature.getSignerNode().setValueSelectionListener(val -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            Notifications.get().submitTask(() -> {
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer ctr = entityService.load(sic, val.getSource());
                if (ctr != null) {
                    FxUtil.waitForFxThread(() -> {
                        Person person = (Person)ctr.getEntity();
                        if (person != null && !person.getEmployments().isEmpty()) {
                            Date dateNow = new Date();
                            Optional<PersonEmployment> optionalPersonEmployment = person.getEmployments().stream().filter(personEmployment -> MiscUtil.isBetween((Date)personEmployment.getOpened(), (Date)personEmployment.getClosed(), (Date)dateNow) && personEmployment.isMainEmployment()).findFirst();
                            if (optionalPersonEmployment.isPresent()) {
                                signature.getPositionNode().setValue(optionalPersonEmployment.get().getPosition());
                            } else {
                                signature.getPositionNode().setValue(null);
                            }
                        }
                    });
                }
            }, Messages.Download_signers);
        })));
        cardsContainer.getCards().add((Object)new Card("parameters", UiCardsContainer.Style.STATIC, Messages.Parameters, (Node)this.createParametersContainer()));
        cardsContainer.getCards().add((Object)this.signersWidget.getSignaturesCard());
        cardsContainer.getCards().add((Object)new Card("products", UiCardsContainer.Style.STATIC, Messages.Certificates_of_completed_flights, (Node)this.createProductsContainer()));
        return cardsContainer;
    }

    private GridContainer createParametersContainer() {
        GridContainer gridContainer = new GridContainer(4);
        gridContainer.getCells().add((Object)new GridCell(Messages.Templates, this.templatesWidget));
        gridContainer.getCells().add((Object)new GridCell(Messages.useFacsimile, (Node)this.useFacsimileWidget));
        return gridContainer;
    }

    private GridContainer createProductsContainer() {
        GridContainer gridContainer = new GridContainer();
        gridContainer.getCells().add((Object)new GridCell(this.productsWidget));
        return gridContainer;
    }

    protected Collection<EntityReference<TemplateDocument>> getTemplates() {
        return this.templatesWidget.getValues();
    }

    protected Map<String, EntityReference<BookingFile>> getProducts2Bookings() {
        ArrayList products = new ArrayList();
        this.productsController.writeData(products);
        return products.stream().filter(ProductTableVM::isChecked).collect(Collectors.toMap(ProductTableVM::getProductUID, ProductTableVM::getBfRef));
    }

    private void loadParams(CertificateOfCompletedFlightProperties params) {
        File file = new File(Environment.getDataFolder(), "settings/" + this.getPropertiesFileName());
        if (file.isFile()) {
            try {
                params.fromXML(DocumentBuilderHelper.parse((File)file).getDocumentElement());
            }
            catch (Exception e) {
                this.log.warn("failed loading certificate parameters from " + file, (Throwable)e);
            }
        }
    }

    private void saveParams(CertificateOfCompletedFlightProperties params) {
        File file = new File(Environment.getDataFolder(), "settings/" + this.getPropertiesFileName());
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            Document doc = DocumentBuilderHelper.newDocument();
            Element root = doc.createElement("object");
            root.setAttribute("class", params.getClass().getName());
            params.toXML(root);
            doc.appendChild(root);
            XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (Exception e) {
            this.log.warn("failed saving certificate parameters to " + file, (Throwable)e);
        }
    }

    public static class ProductTableVM {
        private String product;
        private String productUID;
        private boolean checked;
        private EntityReference<BookingFile> bfRef;

        public String getProduct() {
            return this.product;
        }

        public void setProduct(String value) {
            this.product = value;
        }

        public String getProductUID() {
            return this.productUID;
        }

        public void setProductUID(String value) {
            this.productUID = value;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean value) {
            this.checked = value;
        }

        public EntityReference<BookingFile> getBfRef() {
            return this.bfRef;
        }

        public void setBfRef(EntityReference<BookingFile> bfRef) {
            this.bfRef = bfRef;
        }
    }
}

